/**
 * Description: ProjectSaler业务接口
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-01-23 下午 17:14:15
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-01-23   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import com.house365.beans.entity.ProjectSalerEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.service.system.Interfaces.Service;

import java.util.List;

/**
 * ProjectSaler业务接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-01-23
 * @see
 * @since 1.0
 */
public interface IProjectSalerService<T extends ProjectSalerEntity> extends Service<T> {

    List<UserEntity> queryUserByPrjId(Integer projectId, String city);

    void deleteByProjectId(Integer projectId);

    Integer getUserByHouse(Integer houseId, String channel, String city);

    ProjectSalerEntity getSalerByHouse(Integer houseId, String channel, String city);

    void deleteByUserId(String userId);

    List<ProjectSalerEntity> queryAllList();
}
