/**
 * Description: 客户-置业顾问关联业务实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-03-14 下午 13:43:59
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-03-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.house365.dao.system.interfaces.Dao;
import com.house365.beans.system.QueryParams;
import com.house365.service.system.impl.DefaultServiceImpl;

import com.house365.ws.dao.interfaces.ICustomerUserDao;
import com.house365.ws.service.interfaces.ICustomerUserService;
import com.house365.beans.entity.CustomerUserEntity;

/**
 * 客户-置业顾问关联业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-03-14
 * @see
 * @since 1.0
 */
@Service("customerUserService")
public class CustomerUserServiceImpl<T extends CustomerUserEntity> extends DefaultServiceImpl<T> implements ICustomerUserService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private ICustomerUserDao<T> customerUserDao;

    @Override
    protected Dao<T> getDao() {
        return customerUserDao;
    }

    @Override
    public void removeStar(Integer customerId, Integer userId){
        customerUserDao.removeStar(customerId,userId);
    }

}
