package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.house365.beans.entity.UserProjectRecommendEntity;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.UserProjectRecommendRequest;
import com.house365.ws.beans.response.UserProjectRecommendResponse;
import com.house365.ws.interfaces.server.IUserProjectRecommend;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

/**
 * Description
 *
 * @author Administrator
 * @date 2018/5/15
 */
@Service("projectRecommendOperate")
public class ProjectRecommendOperate implements IProjectRecommendOperate {

    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectRecommendOperate.class);

    @Autowired
    private IUserProjectRecommend userProjectRecommend;

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        Map<String, Object> map = parameter.getArgs();
        String id = getMapValueByKey("id", map, "");
        String operate = getMapValueByKey("operate", map, "");
        String city = getMapValueByKey("city", map, "");
        String userId = getMapValueByKey("userId", map, "");
        String userName = getMapValueByKey("userName", map, "");
        String projectId = getMapValueByKey("projectId", map, "");
        String projectName = getMapValueByKey("projectName", map, "");
        String channel = getMapValueByKey("channel", map, "");
        String recommendReason = getMapValueByKey("recommendReason", map, "");

        UserProjectRecommendResponse response = null;

        //新增
        if (Integer.valueOf(operate) == 0) {
            UserProjectRecommendRequest request = new UserProjectRecommendRequest();
            UserProjectRecommendEntity entity = new UserProjectRecommendEntity();
            entity.setUserId(Integer.valueOf(userId));
            entity.setUserName(userName);
            entity.setCity(city);
            Date date = new Date();
            entity.setCreateTime(date);
            entity.setUpdateTime(date);
            entity.setIsDeleted(0);
            entity.setChannel(Integer.valueOf(channel));
            entity.setProjectName(projectName);
            entity.setProjectId(Integer.valueOf(projectId));
            entity.setRecommendReason(recommendReason);
            request.setEntity(entity);

            response = userProjectRecommend.addUserProjectRecommend(request);

        }

        //修改
        else if (Integer.valueOf(operate) == 1) {

            UserProjectRecommendRequest request = new UserProjectRecommendRequest();
            UserProjectRecommendEntity entity = userProjectRecommend.getUserProjectRecommendById(Integer.valueOf(id)).getEntity();
            //以下两个字段可以修改
            entity.setUpdateTime(new Date());
            entity.setRecommendReason(recommendReason);
            request.setEntity(entity);

            response = userProjectRecommend.updateUserProjectRecommend(request);

        }

        //删除
        else if (Integer.valueOf(operate) == 2) {

            UserProjectRecommendRequest request = new UserProjectRecommendRequest();

            response = userProjectRecommend.deleteUserProjectRecommendById(Integer.valueOf(id));
        } else {
            return response;
        }
        return JSONObject.fromObject(response).toString();
    }

    /**
     * 获取map中的值
     *
     * @param key          key
     * @param map          map
     * @param defaultValue 默认值
     * @return value
     */
    private String getMapValueByKey(String key, Map<String, Object> map, String defaultValue) {
        String value = "";
        if (map.containsKey(key) && map.get(key) != null && !Strings.isNullOrEmpty(((String[]) map.get(key))[0])) {
            value = ((String[]) map.get(key))[0];
        }

        if (Strings.isNullOrEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }
}
