package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.PlatRuleEntity;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.dao.mapper.PlatRuleMapper;
import com.house365.ws.interfaces.server.IPlatRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;
import java.util.Map;

@Service("platRule")
public class PlatRuleImpl implements IPlatRule{

    /**
     * 日志记录器
     */
    private static final Logger logger = LoggerFactory.getLogger(PlatRuleImpl.class);

    @Autowired
    private PlatRuleMapper platRuleMapper;

    @Override
    public List<PlatRuleEntity> getPlatRuleList(Map<String, Object> map) {
        List<PlatRuleEntity> list = platRuleMapper.getPlatRuleList(map);
        return list;
    }

    @Override
    public Integer countPlatRule(Map<String, Object> map) {
        Integer num = platRuleMapper.countPlatRule(map);
        return num;
    }

    @Override
    public List<PlatRuleEntity> queryDeptList(Integer userId){
        List<PlatRuleEntity> list = platRuleMapper.queryDeptList(userId);
        return list;
    }

    @Override
    public void delRule(String ruleId){
        platRuleMapper.delRule(ruleId);
    }

    @Override
    public PlatRuleEntity getRuleById(String ruleId){
        return platRuleMapper.getRuleById(ruleId);
    }

    @Override
    public void saveRule(PlatRuleEntity pre){
        platRuleMapper.saveRule(pre);
    }

    @Override
    public void modifyRule(PlatRuleEntity pre){
        platRuleMapper.modifyRule(pre);
    }

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
