package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CityCallConfig;
import com.house365.beans.entity.CityEntity;
import com.house365.beans.entity.NewHouseCityEntity;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.dao.mapper.CityConfigMapper;
import com.house365.ws.dao.mapper.CityMapper;
import com.house365.ws.dao.mapper.NewHouseCityMapper;
import com.house365.ws.interfaces.server.ICityCallInterface;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author Created by Administrator on 2019/5/6.
 */
@Service("cityCallConfig")
public class CityCallImpl implements ICityCallInterface {

    @Autowired
    private CityConfigMapper callMapper;
    @Autowired
    private NewHouseCityMapper newHouseCityMapper;
    @Autowired
    private CityMapper cityMapper;

    @Override
    public List<CityCallConfig> queryByCity(String city) {
        List<CityCallConfig> list = callMapper.queryByCity(city);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public void save(NewHouseCityEntity entity) {
        newHouseCityMapper.save(entity);
    }

    @Override
    public List<NewHouseCityEntity> queryByConditions(Map<String, Object> map) {
        List<NewHouseCityEntity> list = newHouseCityMapper.queryByConditions(map);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public List<CityEntity> queryCityList(Map<String, Object> map) {
        List<CityEntity> list = cityMapper.queryList(map);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public void update(NewHouseCityEntity entity) {
        newHouseCityMapper.update(entity);
    }

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }
}
