package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.BaseAttachmentType;
import com.house365.beans.system.QueryParams;
import com.house365.ws.beans.request.AttachmentTypeListRequest;
import com.house365.ws.beans.request.AttachmentTypeRequest;
import com.house365.ws.beans.response.AttachmentTypeListResponse;
import com.house365.ws.beans.response.AttachmentTypeResponse;
import com.house365.ws.interfaces.server.IAttachmentTypeInterface;
import com.house365.ws.service.interfaces.IAttachmentTypeService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * @author jay
 */
@Component("attachmentTypeInterface")
public class AttachmentTypeInterfaceImpl implements IAttachmentTypeInterface {

    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentTypeInterfaceImpl.class);

    @Autowired
    IAttachmentTypeService<BaseAttachmentType> attachmentTypeService;

    /**
     * 查询
     *
     * @param request
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     */
    @SuppressWarnings("unchecked")
    @Override
    public AttachmentTypeListResponse getAttachmentTypes(AttachmentTypeListRequest request) {
        AttachmentTypeListResponse response = new AttachmentTypeListResponse();
        try {
            QueryParams<BaseAttachmentType> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<BaseAttachmentType> attachmentType = attachmentTypeService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(attachmentType);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 查询单个
     *
     * @param id
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     */
    @Override
    public AttachmentTypeResponse getAttachmentType(Integer id) {
        AttachmentTypeResponse response = new AttachmentTypeResponse();
        try {
            BaseAttachmentType attachmentType = attachmentTypeService.getById(id);
            response.setAttachmentType(attachmentType);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 添加
     *
     * @param request
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     */
    @Override
    public AttachmentTypeResponse addAttachmentType(AttachmentTypeRequest request) {
        AttachmentTypeResponse response = new AttachmentTypeResponse();
        try {
            BaseAttachmentType attachmentType = request.getAttachmentType();
            Integer id = attachmentTypeService.save(attachmentType);
            attachmentType.setId(id);
            response.setAttachmentType(attachmentType);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改
     *
     * @param request
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     */
    @Override
    public AttachmentTypeResponse updateAttachmentType(AttachmentTypeRequest request) {
        AttachmentTypeResponse response = new AttachmentTypeResponse();
        try {
            BaseAttachmentType attachmentType = request.getAttachmentType();
            attachmentTypeService.update(attachmentType);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除
     *
     * @param id
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     */
    @Override
    public AttachmentTypeResponse deleteAttachmentType(Integer id) {
        AttachmentTypeResponse response = new AttachmentTypeResponse();
        try {
            attachmentTypeService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 根据文件 后缀 查询 类型
     *
     * @param suffix
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     */
    @Override
    public AttachmentTypeListResponse getAttachmentTypesBySuffix(String suffix) {
        AttachmentTypeListResponse response = new AttachmentTypeListResponse();
        AttachmentTypeListRequest request = new AttachmentTypeListRequest();
        Map<String, Object> searchParams = new TreeMap<>();
        {
            searchParams.put("EQ_suffix", suffix);
        }
        request.setSearchParams(searchParams);
        response = getAttachmentTypes(request);
        return response;
    }
}
