/**
 * Description: Project数据访问接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-18 上午 10:05:24
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.interfaces;

import com.house365.beans.entity.ProjectDynamicEntity;
import com.house365.beans.entity.ProjectEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;

import java.util.List;
import java.util.Map;

/**
 * Project数据访问接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-18
 * @see
 * @since 1.0
 */
public interface IProjectDao<T extends ProjectEntity> extends Dao<T>{

    List<ProjectEntity> queryCustomerProject(Integer customerId);

    List<ProjectEntity> getDynamicById(ProjectDynamicEntity pde);

    List<ProjectDynamicEntity> getDynamicList(QueryParams<ProjectDynamicEntity> queryParams);

    void delDynamic(Integer dynamicId);

    void updateHotline(String buildingId, String shorttel);

    void updateSaler();

    void saveDynamic(ProjectDynamicEntity projectdynamicentity);

    List<ProjectEntity> queryByConditions(Map<String, Object> map);
}
