/**
 * Description: 账户数据访问实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:22
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.RequestLoginEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.beans.entity.UserEvaluateEntity;
import com.house365.beans.entity.VersionEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.IUserDao;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * 账户数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
@Repository("userDao")
public class UserDaoImpl extends DefaultDaoImpl<UserEntity> implements IUserDao<UserEntity> {

    @Override
    public List<String> getMobilesByProject(Integer projectId) {
        return getReadTemplate().queryForList(getStatement(), projectId);
    }

    @Override
    public List<Integer> getUserIdOnPath(Integer parentId) {
        return getReadTemplate().queryForList(getStatement(), parentId);
    }

    @Override
    public List<String> getIdsByProject(Integer projectId) {
        return getReadTemplate().queryForList(getStatement(), projectId);
    }

    @Override
    public Map<String, Object> getSummary(String managerId) {
        return (Map<String, Object>) getObject(getStatement(), managerId);
    }

    @Override
    public List<UserEntity> getUserByPorjectShort(Map<String, Object> queryMap) {
        return getReadTemplate().queryForList(getStatement(), queryMap);
    }

    @Override
    public List queryShortNum4Crm() {
        return getReadTemplate().queryForList(getStatement());
    }

    @Override
    public List<UserEvaluateEntity> queryEvaluateListById(UserEvaluateEntity uue) {
        return getReadTemplate().queryForList(getStatement(), uue);
    }

    @Override
    public List<UserEntity> getRemotePath(Integer resourceId) {
        return getReadTemplate().queryForList(getStatement(), resourceId);
    }

    @Override
    public List<UserEntity> getCityName(String city) {
        return getReadTemplate().queryForList(getStatement(), city);
    }

    @Override
    public List<UserEntity> getByCity(String city) {
        return getReadTemplate().queryForList(getStatement(), city);
    }

    @Override
    public List<UserEntity> getUserEvaluation(String accId) {
        return getReadTemplate().queryForList(getStatement(), accId);
    }

    @Override
    public List<UserEntity> getAccidByName(Map<String, Object> queryMap) {
        return getReadTemplate().queryForList(getStatement(), queryMap);
    }

    @Override
    public void reviewStatus(UserEvaluateEntity uue) {
        getReadTemplate().update(getStatement(), uue);
    }

    @Override
    public void delEvaluationById(UserEvaluateEntity uue) {
        getReadTemplate().update(getStatement(), uue);
    }

    @Override
    public void bindAccid(UserEntity userentity) {
        getReadTemplate().update(getStatement(), userentity);
    }



    @Override
    public List<VersionEntity> getAppVersionList(QueryParams<VersionEntity> queryParams) {
//        if (queryParams != null && queryParams.getPaging() != null) {
//            int records = (Integer) this.getReadTemplate().queryForObject(getStatement(), queryParams);
//            // 如果查询出符合条件的记录数为0，那么就直接返回一个空的List，因为后面的已经没有执行的必要
//            if (records == 0) {
//                return new ArrayList(0);
//            }
//            queryParams.getPaging().setRecords(records);
//        }

        return getReadTemplate().queryForList(getStatement(), queryParams);
    }

    @Override
    public List<RequestLoginEntity> getAuthorizationList(QueryParams<RequestLoginEntity> queryParams) {
        return getReadTemplate().queryForList(getStatement(), queryParams);
    }

    @Override
    public Integer countAuthorizationList(QueryParams<RequestLoginEntity> queryParams) {
        return (Integer)getReadTemplate().queryForObject(getStatement(), queryParams);
    }

//    @Override
//    public int countStatistic(QueryParams<?> params) {
//        if (params == null) {
//            return (Integer) this.getReadTemplate().queryForObject(getStatement());
//        }
//        return (Integer) this.getReadTemplate().queryForObject(getStatement(), params);
//    }


    @Override
    public List<UserEntity> queryByName(Map<String, Object> map) {
        return getReadTemplate().queryForList(getStatement(), map);
    }

    /**
     * 统计下属个数
     *
     * @param userId
     * @return
     */
    @Override
    public Integer countSubordinate(Integer userId) {
        return (Integer) getReadTemplate().queryForObject(getStatement(), userId);
    }

    public void saveUnbindLog(UserEntity entity){
        getReadTemplate().insert(getStatement(), entity);
    }
}
