/**
 * Description: 角色数据访问实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:20
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.RoleEntity;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.IRoleDao;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 角色数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
@Repository("roleDao")
public class RoleDaoImpl extends DefaultDaoImpl<RoleEntity> implements IRoleDao<RoleEntity> {

    @Override
    public List<RoleEntity> getRolesByUserId(Integer userId) {
        return this.getReadTemplate().queryForList(getStatement(), userId);
    }
}
