/**
 * Description: ProjectSaler数据访问实现类
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-01-23 下午 17:14:15
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-01-23   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.ProjectSalerEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.IProjectSalerDao;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * ProjectSaler数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-01-23
 * @see
 * @since 1.0
 */
@Repository("projectSalerDao")
public class ProjectSalerDaoImpl extends DefaultDaoImpl<ProjectSalerEntity> implements IProjectSalerDao<ProjectSalerEntity> {

    @Override
    public List<UserEntity> queryUserByPrjId(Map<String, Object> params) {
        return this.getReadTemplate().queryForList(getStatement(), params);
    }

    @Override
    public void deleteByProjectId(Map<String, Object> params) {
        this.getWriteTemplate().delete(getStatement(), params);
    }

    @Override
    public void deleteByUserId(String userId) {
        this.getWriteTemplate().delete(getStatement(), userId);
    }

    @Override
    public List<ProjectSalerEntity> queryAllList() {
        return this.getReadTemplate().queryForList(getStatement());
    }

    @Override
    public void updateStatus(int id) {
        getWriteTemplate().update(this.getStatement(), id);
    }
}
