/**
 * Description: 客户信息数据访问实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-05 下午 19:21:01
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.MarketCustomerEntity;
import com.house365.beans.entity.MarketingActivityEntity;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.IMarketCustomerDao;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 客户信息数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
@Repository("marketCustomerDao")
public class MarketCustomerDaoImpl extends DefaultDaoImpl<MarketCustomerEntity> implements IMarketCustomerDao<MarketCustomerEntity> {
    @Override
    public void clean() {
        getWriteTemplate().delete(getStatement());
    }

    @Override
    public void updateSignupSourceName() {
        getWriteTemplate().update(getStatement());
    }

    @Override
    public List<MarketCustomerEntity> getByActiveId(Integer activeId) {
        return getWriteTemplate().queryForList(getStatement(), activeId);
    }

    @Override
    public List<MarketCustomerEntity> getUseMarketingActivity(MarketCustomerEntity marketcustomerentity) {
        return (List<MarketCustomerEntity>) getWriteTemplate().queryForList(getStatement(), marketcustomerentity);
    }

    @Override
    public List<MarketCustomerEntity> queryByIds(String customerIds) {
        return getWriteTemplate().queryForList(getStatement(), customerIds);
    }

    @Override
    public MarketCustomerEntity queryByCustomerid(Integer custmerId) {
        return (MarketCustomerEntity) getWriteTemplate().queryForObject(getStatement(), custmerId);
    }

    @Override
    public List<MarketCustomerEntity> getOverTimeCustomers() {
        return getWriteTemplate().queryForList(getStatement());
    }


}
