/**
 * Description: 客户-置业顾问关联数据访问实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-03-14 下午 13:43:59
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-03-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.CustomerUserEntity;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.ICustomerUserDao;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.Map;

/**
 * 客户-置业顾问关联数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-03-14
 * @see
 * @since 1.0
 */
@Repository("customerUserDao")
public class CustomerUserDaoImpl extends DefaultDaoImpl<CustomerUserEntity> implements ICustomerUserDao<CustomerUserEntity> {

    @Override
    public void removeStar(Integer customerId, Integer userId) {
        Map<String, Object> para = new HashMap();
        para.put("customerId", customerId);
        para.put("userId", userId);
        this.delete(getStatement(), para);
    }

}
