/**
 * Description: 客户项目信息WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-15 下午 15:36:18
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.beans.entity.CustomerProjectEntity;
import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CustomerProjectListRequest;
import com.house365.ws.beans.request.CustomerProjectRequest;
import com.house365.ws.beans.response.CustomerProjectListResponse;
import com.house365.ws.beans.response.CustomerProjectResponse;
import com.house365.ws.beans.response.MapListResponse;
import com.house365.ws.beans.util.HResult;

import java.util.List;
import java.util.Map;


/**
 * 客户项目信息WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
public interface ICustomerProject extends IService {

    /**
     * 客户项目信息列表查询
     *
     * @param request 客户项目信息列表查询请求
     * @return 客户项目信息列表查询响应
     */
    CustomerProjectListResponse getCustomerProjectList(CustomerProjectListRequest request);

    int getCount(CustomerProjectListRequest request);

    /**
     * 保存客户项目信息
     *
     * @param request 客户项目信息请求
     * @return 保存客户项目信息响应
     */
    CustomerProjectResponse addCustomerProject(CustomerProjectRequest request);

    /**
     * 删除客户项目信息通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除客户项目信息响应
     */
    CustomerProjectResponse deleteCustomerProjectById(Integer id);

    /**
     * 修改客户项目信息
     *
     * @param request 修改客户项目信息请求
     * @return 修改客户项目信息响应
     */
    CustomerProjectResponse updateCustomerProject(CustomerProjectRequest request);

    /**
     * 通过ID获取客户项目信息
     *
     * @param id 唯一标识
     * @return 通过ID获取客户项目信息响应
     */
    CustomerProjectResponse getCustomerProjectById(Integer id);

    CustomerProjectResponse changeStatus(Integer id, String oper, Integer status, String remark, String occurTime) throws Exception;

    int checkRepeat(String phone, String pid);

    void updateProjectNameAndCode(Integer id, String name, String code);

    List<CustomerProjectEntity> queryList(Map<String, Object> map);

    CustomerProjectResponse changeStatusNew(Integer id, String oper, Integer status, String remark, String occurTime) throws Exception;

    List<CustomerProjectEntity> getCustomerProjectList(Map<String, Object> map);

    List<CustomerProjectEntity> getCustomerProjectInfo(Map<String, Object> map);

    int queryPlatCustomerStatus(Map<String, Object> map);

    HResult setMajorCustomer(int id, String userName);

    MapListResponse list(CustomerProjectListRequest request, String city, String startTime, String endTime);

    HResult updateJgData(List<Integer> list, int type, String userName);

}
