/**
 * Description: BaseTreeWS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-08 下午 15:16:07
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-08   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.beans.entity.BaseTreeEntity;
import com.house365.rest.context.IService;
import com.house365.ws.beans.request.BaseTreeListRequest;
import com.house365.ws.beans.request.BaseTreeRequest;
import com.house365.ws.beans.response.BaseTreeListResponse;
import com.house365.ws.beans.response.BaseTreeResponse;


/**
 * BaseTreeWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-08
 * @see
 * @since 1.0
 */
public interface IBaseTree extends IService, IBaseTreeableService<BaseTreeEntity> {

    /**
     * BaseTree列表查询
     *
     * @param request
     *            BaseTree列表查询请求
     * @return BaseTree列表查询响应
     */
    BaseTreeListResponse getBaseTreeList(
        BaseTreeListRequest request
    );

    /**
     * 保存BaseTree
     *
     * @param request
     *            BaseTree请求
     * @return 保存BaseTree响应
     */
    BaseTreeResponse addBaseTree(BaseTreeRequest request);

    /**
     * 删除BaseTree通过唯一标识
     *
     * @param id
     *            唯一标识
     * @return 删除BaseTree响应
     */
    BaseTreeResponse deleteBaseTreeById(Integer id);

    /**
     * 修改BaseTree
     *
     * @param request
     *            修改BaseTree请求
     * @return 修改BaseTree响应
     */
    BaseTreeResponse updateBaseTree(
        BaseTreeRequest request
    );

    /**
     * 通过ID获取BaseTree
     *
     * @param id
     *            唯一标识
     * @return 通过ID获取BaseTree响应
     */
    BaseTreeResponse getBaseTreeById(Integer id);

    BaseTreeEntity getRootBySourceType(String sourceType);

    public void updateUrlPath(Integer parentId);

}
