<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib prefix="house365" uri="http://www.house365.com/taglibs" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<c:set var="ctx" value="${pageContext.request.contextPath}"/>

<div class="row-fluid">
    <c:choose>
        <c:when test="${null != permissions && 0 < fn:length(permissions)}">
            <table class="table table-striped table-advance table-hover">
                <thead>
                <tr>
                    <th>权限编码</th>
                    <th>权限名称</th>
                </tr>
                </thead>
                <tbody>

                <c:forEach items="${permissions}" var="permission">
                    <tr>
                        <td>${permission.code}</td>
                        <td>
                            <c:if test="${permission.hierarchy eq 1}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</c:if>
                                ${permission.name}
                        </td>
                    </tr>
                </c:forEach>
                </tbody>
            </table>
        </c:when>
        <c:otherwise>
            <span>请分配权限</span>
        </c:otherwise>
    </c:choose>
</div>