<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>IM通知人员管理</title>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>组织架构
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>IM通知人员管理
            </li>
        </ul>
    </div>
</div>

<div class="page-container">
    <div class="row${fluid}">
        <form id="filterForm" name="filterForm" class="form-inline filterForm" action="${ctx}/userrole/wxUserList" method="get">
            <div style="margin-top:10px;">
                全链条姓名：<input type="text" id="search_realName" style="border: 1px solid #d5d5d5;" name="search_realName"
                            value="${param['search_realName']}"
                            class="m-wrap small" placeholder="全链条姓名">&nbsp;&nbsp;&nbsp;&nbsp;
                企业微信绑定人：<input type="text" id="search_userName" style="border: 1px solid #d5d5d5;" name="search_userName"
                              value="${param['search_userName']}"
                              class="m-wrap small" placeholder="企业微信绑定人">&nbsp;&nbsp;&nbsp;&nbsp;
                <a class="btn" onclick="btnSubmit();">搜索</a>
            </div>
        </form>
    </div>

    <table class="table table-bordered table-advance table-hover">
        <tr class="info">
            <td width="100" style="text-align:center">序号</td>
            <td width="100" style="text-align:center">城市</td>
            <td width="100" style="text-align:center">全链条用户名</td>
            <td width="100" style="text-align:center">全链条姓名</td>
            <td width="100" style="text-align:center">企业微信绑定人</td>

            <td width="100" style="text-align:center">绑定时间</td>
            <td width="100" style="text-align:center">操作者</td>
            <td width="100" style="text-align:center">操作</td>
        </tr>
        <c:if test="${not empty dataList}">
            <c:forEach items="${dataList}" var="item" varStatus="i">
                <tr>
                    <td nowrap="nowrap" style="text-align:center;">
                            ${i.index+1}
                    </td>
                    <td nowrap="nowrap" style="text-align:center;">
                            ${item.city}
                    </td>
                    <td nowrap="nowrap" style="text-align:center;">
                            ${item.name}
                    </td>
                    <td nowrap="nowrap" style="text-align:center;">
                            ${item.realName}
                    </td>
                    <td nowrap="nowrap" style="text-align:center;">
                            ${item.userName}
                    </td>

                    <td nowrap="nowrap" style="text-align:center;">
                        <c:if test="${null ne item.createTime && '' ne item.createTime}">
                            <f:formatDate value='${item.createTime}'
                                          pattern='yyyy-MM-dd HH:mm:ss'/>
                        </c:if>
                        <c:if test="${null eq item.createTime || '' eq item.createTime}">
                            -
                        </c:if>
                    </td>
                    <td nowrap="nowrap" style="text-align:center;">
                            ${item.createName}
                    </td>

                    <td nowrap="nowrap" style="text-align:center;">
                        <button onclick="deleteById(${item.id})">解绑</button>
                    </td>
                </tr>
            </c:forEach>
        </c:if>
        <c:if test="${ empty dataList}">
            <tr>
                <td colspan="15" style="text-align: center">暂未找到与条件相关的数据，请重新搜索</td>
            </tr>
        </c:if>
    </table>

</div>

<script type="text/javascript">

    function btnSubmit() {
        $('#filterForm').submit();
    }

    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    });

    function deleteById(id) {
        House365Util.createModal("解绑关系", "解绑后将无法收到企业微信通知，确认解绑？", function () {
            console.log(id);
            $.ajax({
                url: '${ctx}/userrole/deleteRelation/' + id,
                type: 'POST',
                contentType: 'application/json',
                data: '',
                dataType: 'json',
                cache: false,
                success: function (result) {
                    if (result.status == 0) {
                        alert("解除绑定关系成功！");
                        window.location.reload();
                    } else {
                        alert(result.errorMessage);
                    }
                }
            });
        });

    }

</script>
</body>
</html>
