<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>直销人员楼盘推荐列表</title>
</head>
<body>
<%-- <div class="row${fluid}">
    <div class="span6">
        <h2 class="page-title">直销人员楼盘推荐列表</h2>
    </div>
    <div class="span6 header_buttons">
        <a href="${ctx}/userprojectrecommend?action=create" class="btn blue pull-right"><i class="icon-plus"></i></a>
    </div>
</div> --%>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <!-- <li><a href="/house365-hmc-web/">首页</a> <span class="divider"></span></li> -->
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>直销人员楼盘推荐列表</li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/userprojectrecommend" method="get">
                <div class="buttons pull-right" style="margin-left:15px;">
                    <a href="javascript:void(0);" onclick="recommendProject()" class="btn blue pull-right" title="新增"><i
                            class="icon-plus"></i></a>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="100">id</th>
            <th width="100">楼盘名称</th>
            <th width="100">推荐理由</th>
            <th width="100">修改时间</th>
            <th width="150">操作</th>
        </tr>
        </thead>
        <c:forEach items="${userProjectRecommends}" var="userProjectRecommend">
            <tr>
                <td nowrap="nowrap">${userProjectRecommend.id}</td>
                <td nowrap="nowrap">
                    <c:if test="${null ne userProjectRecommend.projectName && '' ne userProjectRecommend.projectName}">
                        <c:out value="${userProjectRecommend.projectName}"/>
                    </c:if>
                    <c:if test="${null eq userProjectRecommend.projectName || '' eq userProjectRecommend.projectName}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne userProjectRecommend.recommendReason && '' ne userProjectRecommend.recommendReason}">
                        ${fn:substring(userProjectRecommend.recommendReason, 0, 35)}<c:if
                            test="${fn:length(userProjectRecommend.recommendReason)>35}">...</c:if>
                    </c:if>
                    <c:if test="${null eq userProjectRecommend.recommendReason || '' eq userProjectRecommend.recommendReason}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne userProjectRecommend.updateTime && '' ne userProjectRecommend.updateTime}">
                        <f:formatDate value='${userProjectRecommend.updateTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq userProjectRecommend.updateTime || '' eq userProjectRecommend.updateTime}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <i class="icon-edit pointer icon-large"
                       onclick="recommendProject('${userProjectRecommend.id}')"></i>
                    &nbsp;&nbsp; <i
                        title="删除"
                        class="icon-minus pointer icon-large"
                        onclick="deleteById('${userProjectRecommend.id}')"> </i>
                </td>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script type="text/javascript">

    function recommendProject(id) {
        var url = "${ctx}/userprojectrecommend/recommend";
        if (id != undefined) {
            url += "/" + id;
        }
        House365Util.createRemoteModal("推荐楼盘", url, null, function () {
                if ($("#recommendReason").val().length == 0) {
                    alert("请输入推荐理由！");
                    return false;
                }
                if ($("#recommendReason").val().length > 500) {
                    alert("最多输入500字！");
                    return false;
                }
                if ($("#projectName").val().length == 0) {
                    alert("请输入楼盘名！");
                    return false;
                }
                //                $("#input_form").submit();
                var projectId = $("#projectId").val();
                var projectName = $("#projectName").val();
                var channel = $("#channel").val();
                var recommendReason = $("#recommendReason").val();
                var data;
                if (id != undefined) {
                    data = {
                        id: id,
                        recommendReason:recommendReason
                    };
                    data = JSON.stringify(data);
                    $.ajax({
                        url: '${ctx}/userprojectrecommend/update',
                        type: 'POST',
                        contentType: 'application/json',
                        data: data,
                        dataType: 'json',
                        cache: false,
                        success: function (result) {
                            if (result.status == 0) {
                                alert("修改推荐楼盘成功！");
                                var url = "/house365-hgs-web/userprojectrecommend";
                                window.location.href = url;
                            } else {
                                alert(result.errorMessage);
                            }
                        }
                    });
                } else {
                    data = {
                        projectId: projectId,
                        projectName: projectName,
                        recommendReason:recommendReason,
                        channel: channel
                    };
                    data = JSON.stringify(data);
                    $.ajax({
                        url: '${ctx}/userprojectrecommend/save',
                        type: 'POST',
                        contentType: 'application/json',
                        data: data,
                        dataType: 'json',
                        cache: false,
                        success: function (result) {
                            if (result.status == 0) {
                                alert("新增推荐楼盘成功！");
                                var url = "/house365-hgs-web/userprojectrecommend";
                                window.location.href = url;
                            } else {
                                alert(result.errorMessage);
                            }
                        }
                    });
                }

            }
        )
        ;
        $(".modal").css("width", "750px");
    }

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除确认", "请至少选择一条记录!", function () {
            });
        }
        else {
            House365Util.createModal("删除确认", "确定要删除该记录？", function () {
                $.ajax({
                    url: '${ctx}/userprojectrecommend/' + selectedId,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

</script>
</body>
</html>
