<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>驻场报表</title>
</head>
<body>

<div class="page-container">
    <div class="row${fluid}">
        <form id="filterForm" name="filterForm" class="form-inline filterForm"
              action="${ctx}/statistic/localReportStatistic" method="get">
            <div style="margin-top:10px;">
                &nbsp;&nbsp;项目:&nbsp;&nbsp;&nbsp;&nbsp;
                <select name="project" id="project" class="span10 nochosen  multiselect" multiple="multiple"
                        data-placeholder="项目">
                    <option value='all'
                            <c:if test="${param['project'] eq 'all' or param['project'] eq null}">selected="selected"</c:if>>
                        全部
                    </option>
                    <c:forEach items="${projects}" var="p">
                        <option value="${p.id}"
                                <c:if test="${p.flag}">selected="selected"</c:if> >${p.projectName}</option>
                    </c:forEach>
                </select>
                &nbsp;&nbsp;&nbsp;&nbsp;渠道:&nbsp;&nbsp;&nbsp;&nbsp;
                <select name="channel" id="channel" class="span10 nochosen  multiselect" multiple="multiple"
                        data-placeholder="渠道">
                    <option value='all'
                            <c:if test="${param['channel'] eq 'all' or param['channel'] eq null}">selected="selected"</c:if>>
                        全部
                    </option>
                    <c:forEach items="${channelList}" var="c">
                        <option value="${c.id}"
                                <c:if test="${'1' eq c.creater}">selected="selected"</c:if> >${c.name}</option>
                    </c:forEach>
                </select>
                &nbsp;&nbsp;
            </div>
            <c:if test="${not empty departmentList}">
                <div style="margin-top:10px;">
                    &nbsp;&nbsp;部门：&nbsp;&nbsp;
                    <select name="department" id="department" class="span10 nochosen  multiselect" multiple="multiple"
                            data-placeholder="部门">
                        <option value='all'
                                <c:if test="${param['department'] eq 'all' or param['department'] eq null}">selected="selected"</c:if>>
                            全部
                        </option>
                        <c:forEach items="${departmentList}" var="d">
                            <option value="${d.id}"
                                    <c:if test="${'1' eq d.type}">selected="selected"</c:if>>${d.name}</option>
                        </c:forEach>
                    </select>
                    &nbsp;&nbsp;&nbsp;&nbsp;职员：&nbsp;&nbsp;
                    <span id="userDiv">
                <select name="user" id="user" class="span10 nochosen  multiselect" multiple="multiple"
                        data-placeholder="职员">
                    <option value='all' <c:if test="${param['user'] eq 'all'}">selected="selected"</c:if>>全部</option>
                    <%--<c:forEach items="${userList}" var="u">--%>
                        <%--<option value="${u.id}"--%>
                                <%--<c:if test="${'1' eq u.weiXinId}">selected="selected"</c:if>>${u.realName}</option>--%>
                    <%--</c:forEach>--%>

                </select>
            </span>
                    &nbsp;&nbsp;
                </div>
            </c:if>
            <div style="margin-top:10px;">&nbsp;&nbsp;日期类型：&nbsp;&nbsp;
                <select name="dateViewType" id="dateViewType" class="form-inline chosen">
                    <option value="1" <c:if test="${param['dateViewType']==1}">selected="selected"</c:if>>日视图</option>
                    <option value="2" <c:if test="${param['dateViewType']==2}">selected="selected"</c:if>>周视图</option>
                    <option value="3" <c:if test="${param['dateViewType']==3}">selected="selected"</c:if>>月视图</option>
                </select>
                &nbsp;&nbsp;
            </div>

            <div style="margin-top:10px;">&nbsp;&nbsp;数据日期：&nbsp;&nbsp;
                <input type="text" name="startTime" id="startTime"
                       value="${startDate}"
                       class="m-wrap small mydate span2 " placeholder="起始时间">到
                <input type="text" name="endTime" id="endTime"
                       value="${endDate}"
                       class="m-wrap small mydate span2 " placeholder="截止时间">

                &nbsp;&nbsp;<a class="btn " onclick="btnSubmit();">提交</a>
                &nbsp;&nbsp;<a class="btn "
                               onclick="$('#filterForm').attr('action','${ctx}/statistic/localReportStatisticExcel');$('#filterForm').submit();$('#filterForm').attr('action','${ctx}/statistic/localReportStatistic');">Excel下载</a>
            </div>

            <input type="hidden" id="departmentIds" name="departmentIds" value="${departmentIds}"/>
            <input type="hidden" id="departmentNames" name="departmentNames" value="${departmentNames}"/>
            <input type="hidden" id="userIds" name="userIds" value="${userIds}"/>
            <input type="hidden" id="userNames" name="userNames" value="${userNames}"/>
            <input type="hidden" id="displayTab" name="displayTab" value="${displayTab}"/>

        </form>

        <table class="table table-bordered table-advance table-hover">
            <tr class="info">
                <td width="100" style="text-align:center">日期</td>
                <td width="100" style="text-align:center">项目</td>
                <td width="100" style="text-align:center">渠道</td>
                <td width="100" style="text-align:center">部门</td>
                <td width="100" style="text-align:center">姓名</td>
                <td width="100" style="text-align:center">报备</td>
                <td width="100" style="text-align:center">到访</td>
                <td width="100" style="text-align:center">认筹</td>
                <td width="100" style="text-align:center">认购</td>
                <td width="100" style="text-align:center">业绩</td>
            </tr>
            <c:if test="${not empty tableData}">
                <c:forEach items="${tableData}" var="item">
                    <tr>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.reportDate}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.projectname}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.channelName}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.departName}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.name}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.record}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.visit}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.buyorder}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.buy}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.score}
                        </td>
                    </tr>
                </c:forEach>
            </c:if>
            <c:if test="${ empty tableData}">
                <tr>
                    <td colspan="10">暂未找到与条件相关的数据，请重新搜索</td>
                </tr>
            </c:if>

        </table>

    </div>

</div>

<input type="hidden" value="${queryUser}" name="queryUser" id="queryUser">

<link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-multiselect.css" type="text/css">
<script type="text/javascript" src="${static_common }/script/bootstrap/js/bootstrap-multiselect.js"></script>
<script src="${ctx}/resources/script/echarts/echarts.min.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>

<script type="text/javascript">
    $(document).ready(function () {

        $('#project').multiselect({
            includeSelectAllOption: true,
            enableFiltering: true,
            maxHeight: 500,
            buttonWidth: 320,
            numberDisplayed: 2,
            filterPlaceholder: '请输入项目名',
            includeSelectAllOption: false,
            templates: {
                filterClearBtn: '<span></span>',
            },
            buttonText: function (options) {
                if (options.length == 0) {
                    return '未选择项目 ';
                } else if (options.length > 5) {
                    return '已选' + options.length + '个 ';
                } else {
                    var selected = '';
                    options.each(function () {
                        selected += $(this).text() + ', ';
                    });
                    return selected.substr(0, selected.length - 2);
                }
            },
            /*  label: function(element) {
             return "<label style='margin-top:7px;'>"+$(element).html()+"</label>";
             }, */
            optionLabel: function (element) {
                return $(element).html();
            },
            /*  optionClass: function(element) {
             return "aa";
             }, */
            onInitialized: function (select, container) {
                var selectedOptions = $('#project option:selected');

                if (selectedOptions.val() == 'all') {
                    var nonSelectedOptions = $('#project option').filter(function () {
                        return !$(this).is(':selected');
                    });

                    var dropdown = $('#project').siblings('.open');
                    nonSelectedOptions.each(function () {
                        var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                        input.prop('disabled', true);
                        input.parent('li').addClass('disabled');
                    });
                }
                else {
                    var dropdown = $('#project').siblings('.open');
                    $('#project option').each(function () {
                        var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                        input.prop('disabled', false);
                        input.parent('li').addClass('disabled');
                    });
                }
            },
            onChange: function (option, checked) {
                var selectedOptions = $('#project option:selected');

                if (selectedOptions.val() == 'all') {
                    var nonSelectedOptions = $('#project option').filter(function () {
                        return !$(this).is(':selected');
                    });

                    var dropdown = $('#project').siblings('.open');
                    nonSelectedOptions.each(function () {
                        var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                        input.prop('disabled', true);
                        input.parent('li').addClass('disabled');
                    });

                    $('#project option').each(function () {
                        if ('all' != $(this).val()) {
                            $(this).removeAttr("selected");
                            $('#project').multiselect('refresh');
                        }
                    });
                }
                else {
                    var dropdown = $('#project').siblings('.open');
                    $('#project option').each(function () {
                        var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                        input.prop('disabled', false);
                        input.parent('li').addClass('disabled');
                    });
                }
            }
        });

        if ($('#department')) {
            $('#department').multiselect({
                includeSelectAllOption: true,
                enableFiltering: true,
                maxHeight: 500,
                buttonWidth: 320,
                numberDisplayed: 2,
                filterPlaceholder: '请输入部门名',
                includeSelectAllOption: false,
                templates: {
                    filterClearBtn: '<span></span>',
                },
                buttonText: function (options) {
                    if (options.length == 0) {
                        return '未选择部门 ';
                    } else if (options.length > 5) {
                        return '已选' + options.length + '个 ';
                    } else {
                        var selected = '';
                        options.each(function () {
                            selected += $(this).text() + ', ';
                        });
                        return selected.substr(0, selected.length - 2);
                    }

                },
                optionLabel: function (element) {
                    return $(element).html();
                },
                onInitialized: function (select, container) {
                    var selectedOptions = $('#department option:selected');
                    var userSelectedOptions = $('#user option:selected').val();
                    var contain = $('#userDiv');
                    contain.empty();
                    if (userSelectedOptions == 'all') {
                        contain.append("<select name=\"user\" id=\"user\" class=\"span10 nochosen  multiselect\" multiple=\"multiple\" data-placeholder=\"职员\"><option value='all' selected>全部</option></select>");
                    } else {
                        contain.append("<select name=\"user\" id=\"user\" class=\"span10 nochosen  multiselect\" multiple=\"multiple\" data-placeholder=\"职员\"><option value='all'>全部</option></select>");
                    }

                    var deptId = "";
                    if (selectedOptions.val() == 'all') {
                        var nonSelectedOptions = $('#department option').filter(function () {
                            return !$(this).is(':selected');
                        });

                        var dropdown = $('#department').siblings('.open');
                        nonSelectedOptions.each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', true);
                            input.parent('li').addClass('disabled');
                        });

                        $('#department option').each(function () {
                            if ('all' != $(this).val()) {
                                deptId += $(this).val() + ",";
                            }
                        });
                    } else {
                        var dropdown = $('#department').siblings('.open');
                        $('#department option').each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', false);
                            input.parent('li').addClass('disabled');
                        });
                        selectedOptions.each(function () {
                            deptId += $(this).val() + ",";
                        });
                    }

                    if (selectedOptions.val()) {
                        $.ajax({
                            url: "${ctx}/user/getUserAjax",
                            type: "GET",
                            data: {dept: deptId, queryUser: $("#queryUser").val()},
                            dataType: "json",
                            success: function (data) {
                                var user = $('#user');
                                $(data).each(function () {
                                    if ('1' == this.weiXinId) {
                                        user.append("<option selected value='" + this.id + "'>" + this.realName + "</option>");
                                    } else {
                                        user.append("<option value='" + this.id + "'>" + this.realName + "</option>");
                                    }
                                });
                            },
                            complete: function () {
                                initUser();
                            }
                        });
                    } else {
                        initUser();
                    }

                },
                onChange: function (option, checked) {
                    var selectedOptions = $('#department option:selected');
                    var contain = $('#userDiv');
                    contain.empty();
                    contain.append("<select name=\"user\" id=\"user\" class=\"span10 nochosen  multiselect\" multiple=\"multiple\" data-placeholder=\"职员\">\n" +
                        "<option value='all'>全部</option></select>");

                    var deptId = "";
                    if (selectedOptions.val() == 'all') {
                        var nonSelectedOptions = $('#department option').filter(function () {
                            return !$(this).is(':selected');
                        });
                        var dropdown = $('#department').siblings('.open');
                        nonSelectedOptions.each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', true);
                            input.parent('li').addClass('disabled');
                        });

                        $('#department option').each(function () {
                            if ('all' != $(this).val()) {
                                deptId += $(this).val() + ",";
                                $(this).removeAttr("selected");
                                $('#department').multiselect('refresh');
                            }
                        });
                    } else {
                        var dropdown = $('#department').siblings('.open');
                        $('#department option').each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', false);
                            input.parent('li').addClass('disabled');
                        });
                        selectedOptions.each(function () {
                            deptId += $(this).val() + ",";
                        });
                    }

                    if (selectedOptions.val()) {
                        $.ajax({
                            url: "${ctx}/user/getUserAjax",
                            type: "GET",
                            data: {dept: deptId},
                            dataType: "json",
                            success: function (data) {
                                var user = $('#user');
                                $(data).each(function () {
                                    user.append("<option value='" + this.id + "'>" + this.realName + "</option>");
                                });
                            },
                            complete: function () {
                                initUser();
                            }
                        });
                    } else {
                        initUser();
                    }

                }
            });
        }

        $('#channel').multiselect({
            includeSelectAllOption: true,
            enableFiltering: true,
            maxHeight: 500,
            buttonWidth: 320,
            numberDisplayed: 2,
            filterPlaceholder: '请输入渠道名',
            includeSelectAllOption: false,
            templates: {
                filterClearBtn: '<span></span>',
            },
            buttonText: function (options) {
                if (options.length == 0) {
                    return '未选择渠道 ';
                } else if (options.length > 5) {
                    return '已选' + options.length + '个 ';
                } else {
                    var selected = '';
                    options.each(function () {
                        selected += $(this).text() + ', ';
                    });
                    return selected.substr(0, selected.length - 2);
                }

            },
            optionLabel: function (element) {
                return $(element).html();
            },
            onInitialized: function (select, container) {
                var selectedOptions = $('#channel option:selected');

                if (selectedOptions.val() == 'all') {
                    var nonSelectedOptions = $('#channel option').filter(function () {
                        return !$(this).is(':selected');
                    });

                    var dropdown = $('#channel').siblings('.open');
                    nonSelectedOptions.each(function () {
                        var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                        input.prop('disabled', true);
                        input.parent('li').addClass('disabled');
                    });
                }
                else {
                    var dropdown = $('#channel').siblings('.open');
                    $('#channel option').each(function () {
                        var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                        input.prop('disabled', false);
                        input.parent('li').addClass('disabled');
                    });
                }
            },
            onChange: function (option, checked) {
                var selectedOptions = $('#channel option:selected');
                if (selectedOptions.val() == 'all') {
                    var nonSelectedOptions = $('#channel option').filter(function () {
                        return !$(this).is(':selected');
                    });

                    var dropdown = $('#channel').siblings('.open');
                    nonSelectedOptions.each(function () {
                        var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                        input.prop('disabled', true);
                        input.parent('li').addClass('disabled');
                    });

                    $('#channel option').each(function () {
                        if ('all' != $(this).val()) {
                            $(this).removeAttr("selected");
                            $('#channel').multiselect('refresh');
                        }
                    });

                } else {
                    var dropdown = $('#channel').siblings('.open');
                    $('#channel option').each(function () {
                        var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                        input.prop('disabled', false);
                        input.parent('li').addClass('disabled');
                    });
                }
            }
        });

        var startTime = $("#startTime");
        var endTime = $("#endTime");
        endTime.bind("focus", function () {
            WdatePicker({startDate: "%y-{%M}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: false, maxDate: '%y-%M-{%d}'});
        });
        startTime.bind("focus", function () {
            WdatePicker({
                startDate: "%y-{%M}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: false, maxDate: '%y-%M-{%d}',
                onpicked: function () {
                    WdatePicker({
                        /* doubleCalendar: true, */
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        maxDate: '%y-%M-{%d}',
                        el: 'endTime'
                    })
                }
            });
        });

        <c:if test="${'1' eq param['dateViewType']}">
        $(".mydate").unbind("focus");
        $(".mydate").bind("focus", function () {
            WdatePicker({dateFmt: 'yyyy-MM-dd', maxDate: '%y-%M-{%d}'});
        });
        </c:if>
        <c:if test="${'2' eq param['dateViewType']}">
        $(".mydate").unbind("focus");
        $(".mydate").bind("focus", function () {
            WdatePicker({isShowWeek: true, maxDate: '%y-%M-{%d}'});
        });
        </c:if>
        <c:if test="${'3' eq param['dateViewType']}">
        $(".mydate").unbind("focus");
        $(".mydate").bind("focus", function () {
            WdatePicker({dateFmt: 'yyyy-MM', maxDate: '%y-%M-{%d}'});
        });
        </c:if>

        $("#dateViewType").change(function () {
            var val = $(this).val();
            $(".mydate").val("");
            if (val == 1) {
                $(".mydate").unbind("focus");
                $(".mydate").bind("focus", function () {
                    WdatePicker({dateFmt: 'yyyy-MM-dd', maxDate: '%y-%M-{%d}'});
                });
            } else if (val == 2) {
                $(".mydate").unbind("focus");
                $(".mydate").bind("focus", function () {
                    WdatePicker({isShowWeek: true, maxDate: '%y-%M-{%d}'});
                });
            } else {
                $(".mydate").unbind("focus");
                $(".mydate").bind("focus", function () {
                    WdatePicker({dateFmt: 'yyyy-MM', maxDate: '%y-%M-{%d}'});
                });
            }
            setTime();
        });

//        drawReport();

        dispayFun("${displayTab}");
        setTime();
//        initUser();
    });

    function setTime() {
        var val = $("#dateViewType").val();
        var startTime = $("#startTime");
        var endTime = $("#endTime");

        if ($("#dateViewType").val() != '') {
            if (val == 1) {
                if (startTime.val() == '') {
                    startTime.val(getToday());
                }
                if (endTime.val() == '') {
                    endTime.val(getToday());
                }
            } else if (val == 2) {
                if (startTime.val() == '') {
                    startTime.val(getCurrentWeekStartDate());
                }
                if (endTime.val() == '') {
                    endTime.val(getCurrentWeekEndDate());
                }
            } else {
                if (startTime.val() == '') {
                    startTime.val(getCurrentMonthStartDate());
                }
                if (endTime.val() == '') {
                    endTime.val(getCurrentMonthEndDate());
                }
            }
        }

    }

    function initUser() {
        if ($('#user')) {
            $('#user').multiselect({
                includeSelectAllOption: true,
                enableFiltering: true,
                maxHeight: 500,
                buttonWidth: 320,
                numberDisplayed: 2,
                filterPlaceholder: '请输入职员名',
                includeSelectAllOption: false,
                templates: {
                    filterClearBtn: '<span></span>',
                },
                buttonText: function (options) {
                    if (options.length == 0) {
                        return '未选择职员 ';
                    } else if (options.length > 5) {
                        return '已选' + options.length + '个 ';
                    } else {
                        var selected = '';
                        options.each(function () {
                            selected += $(this).text() + ', ';
                        });
                        return selected.substr(0, selected.length - 2);
                    }
                },
                optionLabel: function (element) {
                    return $(element).html();
                },
                onInitialized: function (select, container) {
                    var selectedOptions = $('#user option:selected');

                    if (selectedOptions.val() == 'all') {
                        var nonSelectedOptions = $('#user option').filter(function () {
                            return !$(this).is(':selected');
                        });

                        var dropdown = $('#user').siblings('.open');
                        nonSelectedOptions.each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', true);
                            input.parent('li').addClass('disabled');
                        });
                    }
                    else {
                        var dropdown = $('#user').siblings('.open');
                        $('#user option').each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', false);
                            input.parent('li').addClass('disabled');
                        });
                    }
                },
                onChange: function (option, checked) {
                    var selectedOptions = $('#user option:selected');

                    if (selectedOptions.val() == 'all') {
                        var nonSelectedOptions = $('#user option').filter(function () {
                            return !$(this).is(':selected');
                        });

                        var dropdown = $('#user').siblings('.open');
                        nonSelectedOptions.each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', true);
                            input.parent('li').addClass('disabled');
                        });

                        $('#user option').each(function () {
                            if ('all' != $(this).val()) {
                                $(this).removeAttr("selected");
                                $('#user').multiselect('refresh');
                            }
                        });
                    } else {
                        var dropdown = $('#user').siblings('.open');
                        $('#user option').each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', false);
                            input.parent('li').addClass('disabled');
                        });
                    }
                }
            });

        }

    }

    function exportExcel() {
        document.filterForm.action = "${ctx}/statistic/projectSourceExcel";
        filterForm.submit();
        document.filterForm.action = "${ctx}/statistic/projectSource";
    }

    function btnSubmit() {
        $('#filterForm').submit();
    }

    function dispayFun(obj) {
        if (obj == 1) {
            $("#report").show();
            $("#table").hide();
            $("#reportLi").addClass("active");
            $("#tableLi").removeClass("active");
            $("#displayTab").val("1");
        } else {
            $("#table").show();
            $("#report").hide();
            $("#tableLi").addClass("active");
            $("#reportLi").removeClass("active");
            $("#displayTab").val("2");
        }
    }
</script>
</body>
</html>
