<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
    <link href="${static_common}/script/select2-3.5.2/select2.css" type="text/css" rel="stylesheet"/>
    <script type="text/javascript" src="${static_common}/script/select2-3.5.2/select2.js"></script>
    <link rel="stylesheet" href="${static_common}/script/bootstrap/css/bootstrap-select.min.css" type="text/css"/>
    <script src="${static_common }/script/jquery/bootstrap-select.min.js" type="text/javascript"></script>
    <style type="text/css">

        .span12 .control-label {
            padding-top: 0px;
        }

        .pos .show-tick {
            vertical-align: top;
        }
    </style>
</head>

<body>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/project<c:if test="${action=='edit'}">/${entity.id}</c:if><c:if test="${fromMyProjectsFlag}">?fromMyProjectsFlag=true</c:if>"
      method="post">

    <input type="hidden" id="updateIp" name="entity.updateIp" value="${entity.updateIp}">
    <input type="hidden" id="shorttel" name="entity.shorttel" value="${entity.shorttel}">
    <input type="hidden" id="createUserid" name="entity.createUserid" value="${entity.createUserid}">
    <input type="hidden" id="createUsername" name="entity.createUsername" value="${entity.createUsername}">
    <input type="hidden" id="showStatus" name="entity.showStatus" value="${entity.showStatus}">
    <input type="hidden" id="city" name="entity.city" value="${entity.city}">
    <input type="hidden" id="cityName" name="entity.cityName" value="${entity.cityName}">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <%-- <a href="${ctx}/project">项目管理 </a> --%>
                    <c:choose>
                        <c:when test="${fromMyProjectsFlag}">
                            <a href="${ctx}/project/myProjects">我的驻场项目 </a>
                        </c:when>
                        <c:otherwise>
                            <a href="${ctx}/project">项目管理 </a>
                        </c:otherwise>
                    </c:choose>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <span class="inline">新增</span>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <span class="inline"> ${entity.id} </span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline"> ${entity.id}</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span12">
            <div class="portlet-header">
                <div class="operation-btn pull-right">
                    <c:choose>
                        <c:when test="${action=='edit' and fromMyProjectsFlag}">
                            <button class="btn blue" type="submit"><i
                                    class="icon-save"></i>&nbsp;保存
                            </button>
                            <a href="${ctx}/project/myProjects" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;取消</a>
                        </c:when>
                        <c:when test="${action=='edit' and !fromMyProjectsFlag}">
                            <button class="btn blue" type="submit"><i
                                    class="icon-save"></i>&nbsp;保存
                            </button>
                            <a href="${ctx}/project/${entity.id}" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;取消</a>
                        </c:when>
                        <c:when test="${action=='create'}">
                            <button class="btn blue"><i class="icon-save"></i>&nbsp;保存</button>
                            <a href="${ctx}/project" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:when>
                        <c:otherwise>
                            <c:if test="${fromMyProjectsFlag}">
                                <a href="${ctx}/project/${entity.id}?action=edit&fromMyProjectsFlag=true"
                                   class="btn blue"><i
                                        class="icon-edit"></i>&nbsp;编辑</a>
                                <a href="${ctx}/project/myProjects" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                            </c:if>
                            <c:if test="${not fromMyProjectsFlag}">
                                <a href="${ctx}/project/${entity.id}?action=edit" class="btn blue"><i
                                        class="icon-edit"></i>&nbsp;编辑</a>
                                <a href="${ctx}/project" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                            </c:if>

                        </c:otherwise>
                    </c:choose>
                </div>
            </div>
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <c:choose>
                            <c:when test="${action=='create'}">
                                <h5>新增</h5>
                            </c:when>
                            <c:when test="${action=='edit'}">
                                <h5>编辑</h5>
                            </c:when>
                            <c:otherwise>
                                <h5>详情</h5>
                            </c:otherwise>
                        </c:choose>
                    </div>
                    <%--  <input name="entity.id" type="hidden" value="${entity.id}"/> --%>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">合同号<span style="color: red;">*</span>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create'}">
                                        <input type="text" id="contractCode"
                                               name="entity.contractCode" class="required"
                                               value="${entity.contractCode}"/>
                                        <span color="red"><form:errors path="projectVo.entity.contractCode"/></span>
                                    </c:when>
                                    <c:when test="${action=='edit'}">
                                        <input type="text" id="contractCode"
                                               name="entity.contractCode" class="required"
                                               value="${entity.contractCode}"/>
                                        <span color="red"><form:errors path="projectVo.entity.contractCode"/></span>
                                        <span><button type="button" onclick="syncMan()">同步经管</button></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.contractCode}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">项目名称<span style="color: red;">*</span>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="projectName"
                                               name="entity.projectName" class="required"
                                               value="${entity.projectName}"/>
                                        <span color="red"><form:errors path="projectVo.entity.projectName"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.projectName}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <c:choose>
                        <c:when test="${action=='edit'}">
                            <div class="row-fluid">
                                <div class="span6 control-group">
                                    <div class="controls">
                                        <h6 style="color: blue">填入正式合同号后，请点击右侧“同步经管” 按钮</h6>
                                    </div>
                                </div>
                            </div>
                        </c:when>
                    </c:choose>

                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">项目状态<span style="color: red;">*</span>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create'}">
                                        <select class="chosen required" id="status" name="entity.status"
                                                data-placeholder="项目状态">
                                            <option value="1">默认</option>
                                            <option value="2">执行中</option>
                                            <option value="3">办结</option>
                                            <option value="4">合同周期结束</option>
                                            <option value="5">终止</option>
                                            <option value="6">立项审核中</option>
                                            <option value="7">删除</option>
                                        </select>
                                        <span color="red"><form:errors path="userVo.entity.status"/></span>
                                    </c:when>
                                    <c:when test="${action=='edit'}">
                                        <select class="chosen required" id="status" name="entity.status"
                                                data-placeholder="项目状态">
                                            <option value="1"
                                                    <c:if test="${entity.status eq 1}">selected="selected"</c:if>>默认
                                            </option>
                                            <option value="2"
                                                    <c:if test="${entity.status eq 2}">selected="selected"</c:if>>执行中
                                            </option>
                                            <option value="3"
                                                    <c:if test="${entity.status eq 3}">selected="selected"</c:if>>办结
                                            </option>
                                            <option value="4"
                                                    <c:if test="${entity.status eq 4}">selected="selected"</c:if>>合同周期结束
                                            </option>
                                            <option value="5"
                                                    <c:if test="${entity.status eq 5}">selected="selected"</c:if>>终止
                                            </option>
                                            <option value="6"
                                                    <c:if test="${entity.status eq 6}">selected="selected"</c:if>>立项审核中
                                            </option>
                                            <option value="7"
                                                    <c:if test="${entity.status eq 7}">selected="selected"</c:if>>删除
                                            </option>
                                        </select>
                                        <span color="red"><form:errors path="userVo.entity.status"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">
                                        		<c:if test="${entity.status eq 1}">默认</c:if>
                                        		<c:if test="${entity.status eq 2}">执行中</c:if>
                                        		<c:if test="${entity.status eq 3}">办结</c:if>
                                        		<c:if test="${entity.status eq 4}">合同周期结束</c:if>
                                        		<c:if test="${entity.status eq 5}">终止</c:if>
                                        		<c:if test="${entity.status eq 6}">立项审核中</c:if>
                                        		<c:if test="${entity.status eq 7}">删除</c:if>
                                                &nbsp;
                                        </span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">项目编号<span style="color: red;">*</span>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="projectCode"
                                               name="entity.projectCode" class="required"
                                               value="${entity.projectCode}"/>
                                        <span color="red"><form:errors path="projectVo.entity.projectCode"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.projectCode}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">关联楼盘ID<span style="color: red;">*</span>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="buildingId"
                                               name="entity.buildingId" class="required"
                                               value="${entity.buildingId}"/>
                                        <span color="red"><form:errors path="projectVo.entity.buildingId"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.buildingId}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">关联楼盘名称<span style="color: red;">*</span>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="chooseRelBuilding" class="span4"/>
                                        <input type="hidden" id="buildingName"
                                               name="entity.buildingName" class="required span4"
                                               value="${entity.buildingName}"/>
                                        <span color="red"><form:errors path="projectVo.entity.buildingName"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.buildingName}&nbsp;<c:if
                                                test="${not empty entity.type}">(${entity.type})</c:if></span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>

                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">项目经理<span style="color: red;">*</span>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="manager"
                                               name="entity.manager" class="required"
                                               value="${entity.manager}"/>
                                        <span color="red"><form:errors path="projectVo.entity.manager"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.manager}&nbsp;(${entity.type})</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">物业类型<span style="color: red;">*</span>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="type"
                                               name="entity.type" class="required"
                                               value="${entity.type}"/>
                                        <span color="red"><form:errors path="projectVo.entity.type"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.type}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">开发企业<span style="color: red;">*</span>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="kfs"
                                               name="entity.kfs" class="required"
                                               value="${entity.kfs}"/>
                                        <span color="red"><form:errors path="projectVo.entity.kfs"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.kfs}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                        <div class="span6 control-group" style="max-height: 50px">
                            <label class="control-label">业务类型<span style="color: red;">*</span>:</label>
                            <div class="controls pos">
                                <c:choose>
                                    <c:when test="${action=='create'}">
                                        <select id="business" name="entity.business"
                                                class="selectpicker show-tick form-control" multiple
                                                data-live-search="false" style="">
                                            <option value="电商">电商</option>
                                            <option value="分销 & 代理">分销 & 代理</option>
                                            <option value="广告">广告</option>
                                            <option value="活动">活动</option>
                                            <option value="产品">产品</option>
                                            <option value="非我方收筹">非我方收筹</option>
                                            <option value="资金类">资金类</option>
                                        </select>
                                        <span color="red"><form:errors path="userVo.entity.business"/></span>
                                    </c:when>
                                    <c:when test="${action=='edit'}">
                                        <select id="selectpicker" name="selectpicker"
                                                class="selectpicker show-tick form-control" multiple
                                                data-live-search="false" val="" style="">
                                            <option value="电商" selected="selected">电商</option>
                                            <option value="分销 & 代理" selected="selected">分销 & 代理</option>
                                            <option value="广告" selected="selected">广告</option>
                                            <option value="活动" selected="selected">活动</option>
                                            <option value="产品" selected="selected">产品</option>
                                            <option value="非我方收筹" selected="selected">非我方收筹</option>
                                            <option value="资金类" selected="selected">资金类</option>
                                        </select>
                                        <span color="red"><form:errors path="userVo.entity.business"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.business}&nbsp;</span>
                                        <%--<c:if test="${entity.business eq '电商'}">电商</c:if>--%>
                                        <%--<c:if test="${entity.status eq '分销 & 代理'}">分销 & 代理</c:if>--%>
                                        <%--<c:if test="${entity.status eq '广告'}">广告</c:if>--%>
                                        <%--<c:if test="${entity.status eq '活动'}">活动</c:if>--%>
                                        <%--<c:if test="${entity.status eq '产品'}">产品</c:if>--%>
                                        <%--<c:if test="${entity.status eq '非我方收筹'}">非我方收筹</c:if>--%>
                                        <%--<c:if test="${entity.status eq '资金类'}">资金类</c:if>--%>
                                        &nbsp;
                                        <%--<select id="selectpicker" name="selectpicker"--%>
                                        <%--class="selectpicker show-tick form-control" multiple--%>
                                        <%--data-live-search="false" val="" style="max-height: 50px" >--%>
                                        <%--<option value="电商" selected="selected">电商</option>--%>
                                        <%--<option value="分销 & 代理" selected="selected">分销 & 代理</option>--%>
                                        <%--<option value="广告" selected="selected">广告</option>--%>
                                        <%--<option value="活动" selected="selected">活动</option>--%>
                                        <%--<option value="产品" selected="selected">产品</option>--%>
                                        <%--<option value="非我方收筹" selected="selected">非我方收筹</option>--%>
                                        <%--<option value="资金类" selected="selected">资金类</option>--%>
                                        <%--</select>--%>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">项目地址<span style="color: red;">*</span>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="address"
                                               name="entity.address" class="required"
                                               value="${entity.address}"/>
                                        <span color="red"><form:errors path="projectVo.entity.address"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.address}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">开盘时间<span style="color: red;">*</span>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="startTimeStr" class="datetime-picker required"
                                               name="entity.startTimeStr" date-language="zh-CN"
                                               data-date-minView="month"
                                               value="<fmt:formatDate value='${entity.startTime}' pattern='yyyy-MM-dd'/>"/>
                                        <span color="red"><form:errors path="projectVo.entity.startTime"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">
                                            <fmt:formatDate type='both' value='${entity.startTime}'
                                                            pattern='yyyy-MM-dd'/>&nbsp;
                                        </span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <c:choose>
                            <c:when test="${action!='create' && action!='edit'}">
                                <div class="span6 control-group">
                                    <label class="control-label">创建人用户名:</label>
                                    <div class="controls">
                                        <span class="inline">${entity.createUsername}&nbsp;</span>
                                    </div>
                                </div>
                            </c:when>
                        </c:choose>
                        <c:choose>
                            <c:when test="${action!='create' && action!='edit'}">
                                <div class="span6 control-group">
                                    <label class="control-label">创建时间:</label>
                                    <div class="controls">
                                        <span class="inline"><fmt:formatDate type='both' value='${entity.createTime}'
                                                                             pattern='yyyy-MM-dd HH:mm:ss'/>&nbsp;</span>
                                    </div>
                                </div>
                            </c:when>
                        </c:choose>
                    </div>
                    <div class="row-fluid">
                        <c:choose>
                            <c:when test="${action!='create' && action!='edit'}">
                                <div class="span6 control-group">
                                    <label class="control-label">最后一次修改人:</label>
                                    <div class="controls">
                                        <span class="inline">${entity.updateUsername}&nbsp;</span>
                                    </div>
                                </div>
                            </c:when>
                        </c:choose>
                        <c:choose>
                            <c:when test="${action!='create' && action!='edit'}">
                                <div class="span6 control-group">
                                    <label class="control-label">最后一次修改时间:</label>
                                    <div class="controls">
                                        <span class="inline"><fmt:formatDate type='both' value='${entity.updateTime }'
                                                                             pattern='yyyy-MM-dd HH:mm:ss'/>&nbsp;</span>

                                    </div>
                                </div>
                            </c:when>
                        </c:choose>
                    </div>
                </div>
            </div>

            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <h5>其他信息</h5>
                    </div>
                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <label class="control-label">房源状况:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <%-- <input type="text" id="entity.source"
                                            name="entity.source"
                                            value="${entity.source}" /> --%>
                                        <textarea class="span9" id="entity.source" name="entity.source" rows="6"
                                                  placeholder="房源状况">${entity.source}</textarea>
                                        <span color="red"><form:errors path="projectVo.entity.source"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.source}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <label class="control-label">即时销售信息:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <%-- <input type="text" id="entity.jitInfo"
                                            name="entity.jitInfo"
                                            value="${entity.jitInfo}" /> --%>
                                        <textarea class="span9" id="entity.jitInfo" name="entity.jitInfo" rows="6"
                                                  placeholder="即时销售信息">${entity.jitInfo}</textarea>
                                        <span color="red"><form:errors path="projectVo.entity.jitInfo"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.jitInfo}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <label class="control-label">佣金标准:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <%-- <input type="text" id="entity.hireMoney"
                                            name="entity.hireMoney"
                                            value="${entity.hireMoney}" /> --%>
                                        <textarea class="span9" id="entity.hireMoney" name="entity.hireMoney" rows="6"
                                                  placeholder="佣金标准">${entity.hireMoney}</textarea>
                                        <span color="red"><form:errors path="projectVo.entity.hireMoney"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.hireMoney}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <c:choose>
                            <c:when test="${action=='edit'}">
                                <div class="span12 control-group">
                                    <label class="control-label">项目图片:</label>
                                    <div class="controls">
                                        <tags:imageSection resourceId="${entity.id}"
                                                           resourceType="hgs" bizType="5" editAble="true" title="楼盘图片"
                                                           maxSize="12"/>
                                    </div>
                                </div>
                            </c:when>
                            <c:when test="${action!='edit'&&action!='create'}">
                                <div class="span12 control-group">
                                    <label class="control-label">项目图片:</label>
                                    <div class="controls">
                                        <tags:imageSection resourceId="${entity.id}"
                                                           resourceType="hgs" bizType="5" editAble="false" title="楼盘图片"
                                                           maxSize="12"/>
                                    </div>
                                </div>
                            </c:when>
                        </c:choose>
                    </div>
                </div>
            </div>

            <c:choose>
                <c:when test="${action=='create'}">
                </c:when>
                <c:when test="${action=='edit'}">
                </c:when>
                <c:otherwise>
                    <div class="form-horizontal house365Page">
                        <div class="house365Border">
                            <!-- 片段头 begin -->
                            <div class="sectionTitle">
                                <h5>项目日志</h5>
                            </div>
                            <ul>
                                <c:forEach items="${logList}" var="log">
                                    <li>
                                        <c:out value="${log}"/>
                                    </li>
                                </c:forEach>
                            </ul>
                        </div>
                    </div>
                </c:otherwise>
            </c:choose>

        </div>
    </div>

</form>

<script>
    var relContent = "${entity.buildingName}" == "" ? "请选择关联楼盘" : "${entity.buildingName}(${entity.type})";
    var business = "${business}";

    $(function () {
        $('#selectpicker').val(business ? business.split(',') : '');
    });

    $(function () {
        // 加载楼盘名称
        $("#chooseRelBuilding").select2({
            placeholder: relContent,
            // 输入几个字符开始联想
            minimumInputLength: 1,
            // 最大返回记录数
            minimumResultsForSearch: 10,
            maximumSelectionLength: 1,
            minimumSelectionLength: 1,
            containerCssClass: "chosen, chosen-with-diselect",
            query: function (query) {
                $.ajax({
                    timeout: 1000,
                    url: "${ctx}/remoteJson/getJson",
                    data: {
                        url: "http://newapi.house365.com/projects/name",
                        city: "${city}",
                        limit: 10,
                        name: query.term,
                        like: 1
                    },
                    type: "GET",
                    dataType: "json",
                    success: function (data, status) {
                        var pageData = {
                            results: []
                        };
                        $.each(data.data.list, function (i, item) {
                            pageData.results.push({
                                id: item.itemname + "@#" + item.listid + "@#" + item.channel_name + "@#" + item.mobileshorttel + "@#" + item.channel + "@#" + item.shorttel,
                                text: item.itemname + "(" + item.channel_name + ")"
                            });
                        });
                        query.callback(pageData);
                    },
                    error: function () {
                        var pageData = {
                            results: []
                        };
                        query.callback(pageData);
                    }
                });
            }
        });

        $.ajaxSetup({
            async: false
        });

        $("#chooseRelBuilding").change(function () {
            var chooseHouse = $(this).val();
            if (chooseHouse) {
                var houses = chooseHouse.split("@#");
                var buildingName = houses[0];
                var buildingId = houses[1];
                var channelName = houses[2];
                var hotlineShort = houses[3];
                var channel = houses[4];
                var shorttel = houses[5];
                $("#buildingName").val(buildingName);
                $("#buildingId").val(buildingId);
                $("#type").val(channelName);
                $("#updateIp").val(hotlineShort);
                $("#channel").val(hotlineShort);
                $("#shorttel").val(shorttel);
            }
        });
    });

    function syncMan() {
        var contractNo = $("#contractCode").val();
        var oldContractNo = "${entity.contractCode}";
        $.ajax({
            timeout: 1000,
            url: "${ctx}/remote/getProject",
            data: {
                limit: 10,
                contractCode: contractNo,
                oldContractNo: oldContractNo
            },
            type: "GET",
            dataType: "json",
            success: function (result) {
                if (result.status == 0) {
                    var i = result.data;
                    console.log(i);
                    $("#projectCode").val(i.projectCode);
                    $("#projectName").val(i.projectName);
                    $("#buildingId").val(i.buildingId);
                    $("#buildingName").val(i.buildingName);
                    $('#select2-chosen-1').text(i.buildingName + "(" + i.type + ")");

                    $("#status").val(i.status);
                    $("#status").find("option[value=" + i.status + "]").attr("selected", true);
                    $("#status").trigger("chosen:updated");

                    $("#manager").val(i.manager);
                    $("#type").val(i.type);
                    $("#kfs").val(i.kfs);
                    $("#city").val(i.city);
                    $("#address").val(i.address);
                    $("#startTimeStr").val(i.startTime);
                    $("#business").val(i.business);

                    $('#selectpicker').val(i.business ? i.business.split(',') : '');
                    $('#selectpicker').selectpicker('render');
                } else {
                    alert(result.errorMessage);
                }
            }
        });
    }
</script>
</body>

</html>
