<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/customersource<c:if test="${action=='edit'}">/${entity.id}</c:if>"
      method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <a href="${ctx}/customersource">客户活动来源列表</a>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <span class="inline">新增</span>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <span class="inline"> ${entity.sourceName} </span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline"> ${entity.sourceName}</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span12">
            <div class="portlet-header">
                <div class="operation-btn pull-right">
                    <c:choose>
                        <c:when test="${action=='edit'}">
                            <button class="btn blue" onclick="saveForm()"><i
                                    class="icon-save"></i>&nbsp;保存
                            </button>
                            <a href="${ctx}/customersource/${entity.id}" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;取消</a>
                        </c:when>
                        <c:when test="${action=='create'}">
                            <button class="btn blue" onclick="saveForm()"><i class="icon-save"></i>&nbsp;保存</button>
                            <a href="${ctx}/customersource" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:when>
                        <c:otherwise>
                            <a href="${ctx}/customersource/${entity.id}?action=edit" class="btn blue"><i
                                    class="icon-edit"></i>&nbsp;编辑</a>
                            <a href="${ctx}/customersource" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:otherwise>
                    </c:choose>
                </div>
            </div>
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <c:choose>
                            <c:when test="${action=='create'}">
                                <h5>新增</h5>
                            </c:when>
                            <c:when test="${action=='edit'}">
                                <h5>编辑</h5>
                            </c:when>
                            <c:otherwise>
                                <h5>详情</h5>
                            </c:otherwise>
                        </c:choose>
                    </div>
                    <input name="entity.id" type="hidden" value="${entity.id}"/>
                    <input name="entity.source" type="hidden" value="${entity.source}"/>
                    <input name="entity.createTimeStr" type="hidden"
                           value="<f:formatDate value='${entity.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>"/>
                    <input name="entity.city" type="hidden" value="${entity.city}"/>
                    <input name="entity.status" type="hidden" value="${entity.status}"/>
                    <input name="entity.creater" type="hidden" value="${entity.creater}"/>

                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">来源名称:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.sourceName" maxlength="12"
                                               name="entity.sourceName"
                                               value="${entity.sourceName}"/>
                                        <span color="red"><form:errors
                                                path="customerSourceVo.entity.sourceName"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.sourceName}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">排序:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity_sort"
                                               name="entity.sort" class="required number"
                                               value="${entity.sort}"/>
                                        <span color="red"><form:errors path="customerSourceVo.entity.sort"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.sort}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">类别:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create'}">
                                        <select name="entity.type" id="type">
                                            <option value="0" selected="selected">
                                                私客管理
                                            </option>
                                            <option value="1">
                                                平台客户管理
                                            </option>
                                            <option value="2">
                                                外部客户管理
                                            </option>
                                        </select>
                                    </c:when>
                                    <c:otherwise>
                                        <select name="entity.type" id="type">
                                            <option value="0"
                                                    <c:if test="${0 == entity.type}">selected="selected"</c:if>>
                                                私客管理
                                            </option>
                                            <option value="1"
                                                    <c:if test="${1 == entity.type}">selected="selected"</c:if>>
                                                平台客户管理
                                            </option>
                                            <option value="2"
                                                    <c:if test="${2 == entity.type}">selected="selected"</c:if>>
                                                外部客户管理
                                            </option>
                                        </select>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<script>

    $(function () {
        <c:if test="${null ne param['message'] and '' ne param['message']}">
        alert("${param['message']}");
        </c:if>
    });

    function saveForm() {
        var flag = true;
        if (!$.isNumeric($("#entity_sort").val())) {
            flag = false;
            $("#entity_sort").focus();
            alert("排序请输入数字!");
            return false;
        } else {
            if (flag) {
                $("#input_form").submit();
            }
        }
    }
</script>

</body>

</html>
