<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>我的400来电</title>
</head>
<body>
<link rel="stylesheet" href="${static_common}/jquery.qtip.custom/jquery.qtip.min.css" type="text/css">
<style>
    tr.header {
        cursor: pointer;
    }

    .header .sign:after {
        content: "-";
        display: inline-block;
    }

    .header.expand .sign:after {
        content: "+";
    }

    .temp {
        border: 1px solid #cccccc;
        width: 430px !important;
        height: 160px !important;
        position: relative;
        top: -26px;
        left: 81px;
    }

    .bat {
        padding: 5px 10px;
        background-color: white;
        border-radius: 5px;
        outline: 0;
        border-color: transparent;
        box-shadow: none;
        margin: 0 5px;
    }

    .color_999 {
        border: 1px solid #999;
        color: #999;
    }

    .color_d9534f {
        border: 1px solid #d9534f;
        color: #d9534f;
    }

    .color_f0ad4e {
        border: 1px solid #f0ad4e;
        color: #f0ad4e;
    }

    .color_5cb85c {
        border: 1px solid #5cb85c;
        color: #5cb85c;
    }

    .color_5bc0de {
        border: 1px solid #5bc0de;
        color: #5bc0de;
    }

    .color_0275d8 {
        border: 1px solid #0275d8;
        color: #0275d8;
    }

    .color_663399 {
        border: 1px solid #663399;
        color: #663399;
    }

    .bt_last {
        background-color: #f0f0f0 !important;
        border: none !important;
        background-image: none !important;
    }
</style>
<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                我的400来电
            </li>
        </ul>
    </div>
</div>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li class="active"><b>今日新增客户：</b>
                <font color="red" style="cursor:pointer;">
                    <b>${summary['newadd']}</b>
                </font>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <b>累计客户：</b>
                <font color="red" style="cursor:pointer;">${summary['allCount']}</font>
            </li>
        </ul>
    </div>
</div>

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/customer/hotlineList" method="get">
                <input type="hidden" name="summaryType" value="${summaryType}"/>
                <input style="width: 6rem" type="text" name="search_LIKE_likephone"
                       value="${param['search_LIKE_likephone']}"
                       class="m-wrap small span2" placeholder="客户手机号码">
                <input style="width: 6rem" type="text" name="search_LIKE_managerName"
                       value="${param['search_LIKE_managerName']}"
                       class="m-wrap small span2" placeholder="置业顾问">
                <input style="width: 6rem" type="text" name="search_LIKE_actSource"
                       value="${param['search_LIKE_actSource']}"
                       class="m-wrap small span2" placeholder="电话来源">
                <input style="width: 10rem" type="text" name="search_GTE_createTimeStart"
                       id="search_GTE_createTimeStart"
                       value="${param['search_GTE_createTimeStart']}"
                       class="m-wrap small mydate span2 " placeholder="来电开始时间">到
                <input style="width: 10rem" type="text" name="search_LTE_createTimeEnd" id="search_LTE_createTimeEnd"
                       value="${param['search_LTE_createTimeEnd']}"
                       class="m-wrap small mydate span2 " placeholder="来电结束时间">

                <select style="width: 6rem" name="search_EQ_status" id="search_EQ_status" data-placeholder="状态">
                    <option value="" <c:if test="${param['search_EQ_status']}">selected="selected"</c:if>></option>
                    <option value="98"
                            <c:if test="${'98' eq param['search_EQ_status']}">selected="selected"</c:if>>
                        待跟踪
                    </option>
                    <option value="0"
                            <c:if test="${'0' eq param['search_EQ_status']}">selected="selected"</c:if>>
                        已跟踪
                    </option>
                    <option value="2"
                            <c:if test="${'2' eq param['search_EQ_status']}">selected="selected"</c:if>>
                        已放弃
                    </option>
                </select>

                <input type="hidden" name="orderColumn" value="${param['orderColumn']}"/>
                <input type="hidden" name="orderMode" value="${param['orderMode']}"/>

                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-advance table-hover">
        <thead>
        <tr>
            <th width="40">序号</th>
            <th width="100">电话</th>
            <th width="100">置业顾问</th>
            <th width="40">400电话来源</th>
            <th width="80">来电时间</th>
            <th width="80">添加日期</th>
            <th width="150">操作</th>
        </tr>
        </thead>
        <c:forEach items="${customers}" var="customer" varStatus="vs">
            <td nowrap="nowrap">
                <c:if test="${null ne customer.id && '' ne customer.id}">
                    <c:out value="${customer.id}"/>
                </c:if>
                <c:if test="${null eq customer.id || '' eq customer.id}">
                    &nbsp;
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:if test="${null ne customer.phone && '' ne customer.phone}">
                    <c:out value="${customer.phone}"/>
                </c:if>
                <c:if test="${null eq customer.phone || '' eq customer.phone}">
                    &nbsp;
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:if test="${null ne customer.managerName && '' ne customer.managerName}">
                    <c:out value="${customer.managerName}"/>
                </c:if>
                <c:if test="${null eq customer.managerName || '' eq customer.managerName}">
                    &nbsp;
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:choose>
                    <c:when test="${customer.actSource}">
                        <c:out value="${customer.actSource}"/>
                    </c:when>
                    <c:otherwise>
                        <c:out value="${customer.actSource}"/>
                    </c:otherwise>
                </c:choose>
                <c:if test="${null eq customer.actSource || '' eq customer.actSource}">
                    &nbsp;
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:if test="${null ne customer.createTime && '' ne customer.createTime}">
                    <f:formatDate value='${customer.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                </c:if>
                <c:if test="${null eq customer.createTime || '' eq customer.createTime}">
                    &nbsp;
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:if test="${null ne customer.createTime && '' ne customer.createTime}">
                    <f:formatDate value='${customer.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                </c:if>
                <c:if test="${null eq customer.createTime || '' eq customer.createTime}">
                    &nbsp;
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:if test="${customer.status eq '98'}">
                    <button type="button" class="btn btn-default"
                            onclick="checkCustomerPhone('${customer.id}','${customer.phone}', '${customer.managerId}', '${customer.markedLabelId}','${customer.starCustomer}')">
                        跟踪
                    </button>
                    <button type="button" class="btn btn-default"
                            onclick="abandonHotlineCustomer(${customer.id}, ${customer.phone})">
                        放弃
                    </button>
                </c:if>
                <c:if test="${customer.status eq '0'}">
                    <b class="active">已跟踪</b>
                </c:if>
                <c:if test="${customer.status eq '2'}">
                    <b class="active">已放弃</b>
                </c:if>
                <button type="button" class="btn btn-default" onclick="deleteById(${customer.id})"
                        style="display: none">删除
                </button>
            </td>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/jquery.qtip.custom/jquery.qtip.min.js"></script>

<script type="text/javascript">
    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    });
    $(function () {
        var startTime = $("#search_GTE_createTimeStart")
        var endTime = $("#search_LTE_createTimeEnd");
        endTime.bind("click", function () {
            WdatePicker({startDate: "%y-{%M}-%d 00:00:00", dateFmt: "yyyy-MM-dd HH:mm:ss", autoPickDate: true});
        });
        startTime.bind("click", function () {
            WdatePicker({startDate: "%y-{%M}-%d 00:00:00", dateFmt: "yyyy-MM-dd HH:mm:ss", autoPickDate: true});
        });

        $('.baobei').each(function () { // Notice the .each() loop, discussed below
            $(this).qtip({
                content: {
                    text: $(this).next('div') // Use the "div" element next to this for the content
                }, position: {
                    at: 'bottom center', // at the bottom right of...
                    target: $(this) // my target
                }
            });
        });

        $('.header').each(function () {
            $(this).nextUntil('tr.header').hide();
        });

        $('.header').click(function () {
            $(this).toggleClass('expand').nextUntil('tr.header').slideToggle(100);
        });
    });

    function abandonHotlineCustomer(customerId, phone) {
        House365Util.createModal("确认", "确认放弃" + phone + "?", function () {
            $.ajax({
                url: '${ctx}/customer/abandonHotlineCustomer',
                data: {"customerId": customerId},
                type: "GET",
                success: function (data) {
                    if (data.result == '1') {
                        window.location.reload();
                    } else {
                        alert("操作失败，" + data.msg);
                    }
                }
            });
        });
    }


    function checkCustomerPhone(customerId, phone, managerId, markedLabelId, star) {
        if (markedLabelId != undefined && markedLabelId != '') {
            arr = markedLabelId.split(",");
        }
        $.ajax({
            url: "${ctx}/customer/checkCustomerPhone",
            data: {
                customerPhone: phone
            },
            async: true,
            type: "get",
            success: function (data) {
                if (data.result === "0") {
                    House365Util.createModal("提示", data.msg + "是否继续？", function () {

                        addCallBack(customerId, phone, managerId, markedLabelId, star);
                        return false;
                    });
                } else {

                    addCallBack(customerId, phone, managerId, markedLabelId, star);
                    return false;
                }
            }
        });
    }

    function setCallbackContent(template) {
        var content = $(template).text();
        var obj = document.getElementById("callContent");
        obj.innerHTML = content;
    }

    var arr = new Array();
    var callId;
    function addCallBack(customerId, _phone, managerId, markedLabelId, star) {
        callId = customerId;


        var hasOwnlabel = ${hasOwnlabel};
        var callContentHtml = "";
        callContentHtml += "<div class='row-fluid'><div class='span5 control-group' style='position: relative'>"
            + " <label class='control-label'>购房意向：</label>"
            + "<div class='controls' style='position: absolute;top: -4px;left: 80px'><select style='width: 96px' name='entity.buyIntention' id='buyIntention'>";
        callContentHtml += "<option value=''>请选择</option>";
        callContentHtml += "<option value='1'>A</option>";
        callContentHtml += "<option value='2'>B</option>";
        callContentHtml += "<option value='3'>C</option>";
        callContentHtml += "<option value='4'>D</option>";

        callContentHtml += "</select></div></div></div>";

        callContentHtml += "<div class='row-fluid'><div class='span5 control-group'  style='width: 100%;position: relative;'>"

        callContentHtml += "<span style='margin-left: 200px;'>";
        if (star == 1) {
            callContentHtml += "<img style='margin-left: 283px;margin-top: -71px' id='starImage' class='collect' src='${ctx}/resources/img/collect_yes.png' alt=''>";
        } else {
            callContentHtml += "<img style='margin-left: 283px;margin-top: -71px' id='starImage' class='collect' src='${ctx}/resources/img/collect_no.png' alt=''>";
        }
//        callContentHtml += "</div></div></div><div class='row-fluid'><div class='span5 control-group'>"

        callContentHtml += "<div class='row-fluid'><div class='span5 control-group'  style='width: 100%;position: relative;'>"
            + " <label class='control-label'>回访内容：</label>";
        callContentHtml += "<p contenteditable='true' class='temp' cols='10' rows='5' style='margin: 0px 0px 10px; width: 436px; height: 70px;' id='callContent'>" +
            "<div style='position: absolute;bottom: 39px;width: 80%;left:85px'>" +
            "<c:forEach items='${callbackTemplateList}' var='item'>" +
            "<button type='button' class='btn bt_last' style='margin: 5px' onclick='setCallbackContent(this)'>${item.content}</button>" +
            "</c:forEach>" +
            "</div></p></div>";


        callContentHtml += "<div class='row-fluid'>" + "<div style='display: inline-flex;'><span>客户标签：</span>";
        if (hasOwnlabel == 1) {
            callContentHtml += "<div class='clearfix' style='display: flex;flex-wrap: wrap;width: 370px;\n" +
                "    line-height: 35px;\n" +
                "    height: auto;'>";
            callContentHtml += "<div style='margin-top: -5px;float:left;margin-left: 6px'>";

            callContentHtml += "<c:forEach items='${userLabelList}' var='lid'>";
            <c:choose>
            <c:when test="${1 eq lid.selected}">
            callContentHtml += "<c:if test='${1 eq lid.colorId}'><span class='bat color_999' data-index='${lid.labelId}' opsel='' style='background-color: rgb(153, 153, 153); color: white;'>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${2 eq lid.colorId}'><span class='bat color_d9534f' data-index='${lid.labelId}' opsel='' style='background-color: rgb(217, 83, 79); color: white;'>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${3 eq lid.colorId}'><span class='bat color_f0ad4e' data-index='${lid.labelId}' opsel='' style='background-color: rgb(240, 173, 78); color: white;'>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${4 eq lid.colorId}'><span class='bat color_5cb85c' data-index='${lid.labelId}' opsel='' style='background-color: rgb(92, 184, 92); color: white;'>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${5 eq lid.colorId}'><span class='bat color_5bc0de' data-index='${lid.labelId}' opsel='' style='background-color: rgb(91, 192, 222); color: white;'>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${6 eq lid.colorId}'><span class='bat color_0275d8' data-index='${lid.labelId}' opsel='' style='background-color: rgb(2, 117, 216); color: white;'>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${7 eq lid.colorId}'><span class='bat color_663399' data-index='${lid.labelId}' opsel='' style='background-color: rgb(102, 51, 153); color: white;'>${lid.labelName}</span>";
            callContentHtml += "</c:if>";
            </c:when>
            <c:otherwise>
            callContentHtml += "<c:if test='${1 eq lid.colorId}'><span class='bat color_999' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${2 eq lid.colorId}'><span class='bat color_d9534f' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${3 eq lid.colorId}'><span class='bat color_f0ad4e' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${4 eq lid.colorId}'><span class='bat color_5cb85c' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${5 eq lid.colorId}'><span class='bat color_5bc0de' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${6 eq lid.colorId}'><span class='bat color_0275d8' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${7 eq lid.colorId}'><span class='bat color_663399' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
            callContentHtml += "</c:if>";
            </c:otherwise>
            </c:choose>
            callContentHtml += "</c:forEach></div></div></div></div>";
            callContentHtml += decodeURI('%3Cscript%3E for (lableId in arr) { $(".bat[data-index=" + arr[lableId] + "]").trigger("click"); }%3C/script%3E');
        } else {
            callContentHtml += "暂无标签,请到标签管理中添加</div></div>";
        }

        House365Util.createModal("跟踪该客户", callContentHtml, function () {
//            var callContent = $("#callContent").val();
//            var callContent = $("#callContent").val().replace(/(^\s*)|\s*$/g, '');
            var callContent = $("#callContent").text().replace(/(^\s*)|\s*$/g, '');

            var ids = "";
            if (arr.length > 0) {
                for (var i = 0; i < arr.length; i++) {
                    ids += arr[i] + ",";
                }
            }
            if (ids.indexOf(",") != -1) {
                ids = ids.substring(0, ids.length - 1);
            }
            var buyIntention = $("#buyIntention").val();
            var starImage = $('#starImage').attr("src");
            var customerStar;
            if (starImage === '${ctx}/resources/img/collect_no.png') {
                customerStar = 0;
            } else {
                customerStar = 1;
            }

            $("#hiddenBuyIntention").val(buyIntention);
            if (buyIntention == null || buyIntention == '') {
                alert("请选择购房意向");
                return false;
            }
            if (!callContent) {
                alert("回访内容不能为空");
                return false;
            } else if (callContent.length > 600) {
                alert("不能超过600个字");
                return false;
            } else if (buyIntention == 5) {
                House365Util.createModal("提示", "您确定要将客户移入公海吗？", function () {
                    $.ajax({
                        url: '${ctx}/customer/addCall',
                        data: {
                            "content": callContent,
                            "customerId": customerId,
                            "buyIntention": buyIntention,
                            "labelIds": ids,
                            "phone": _phone,
                            "managerId": managerId,
                            "addFrom": "400"
                        },
                        type: "GET",
                        success: function (data) {
                            if (data.result == '1') {
                                $.ajax({
                                    url: '${ctx}/customermanagement/updateStar',
                                    contentType: 'application/json',
                                    data: JSON.stringify({
                                        id: customerId,
                                        buyIntention: buyIntention,
                                        starCustomer: customerStar
                                    }),
                                    dataType: 'json',
                                    type: "POST",
                                    success: function (data) {
                                        if (data.status == 0) {
                                            window.location.href = "${ctx}/customer/";
                                        } else {
                                            alert(data.errorMessage);
                                        }
                                    }
                                });
                            } else {
                                alert("操作失败，" + data.msg);
                            }
                        }
                    });
                });
                return false;
            } else {
                $.ajax({
                    url: '${ctx}/customer/addCall',
                    data: {
                        "content": callContent,
                        "customerId": customerId,
                        "buyIntention": buyIntention,
                        "labelIds": ids,
                        "phone": _phone,
                        "managerId": managerId,
                        "addFrom": "400"
                    },
                    type: "GET",
                    success: function (data) {
                        if (data.result == '1') {
                            $.ajax({
                                url: '${ctx}/customermanagement/updateStar',
                                contentType: 'application/json',
                                data: JSON.stringify({
                                    id: customerId,
                                    buyIntention: buyIntention,
                                    starCustomer: customerStar
                                }),
                                dataType: 'json',
                                type: "POST",
                                success: function (data) {
                                    if (data.status == 0) {
                                        window.location.reload();
                                    } else {
                                        alert(data.errorMessage);
                                    }
                                }
                            });
                        } else {
                            alert("操作失败，" + data.msg);
                        }
                    }
                });
                return false;
            }

        });
    }

    $(document).on('click', '.bat', function () {
//        var bor_color = $(this).css("border-color");
        var bor_color = $(this).css("borderRightColor");
        var bg_color = $(this).css("background-color");
        var labelIds = $("#labelIds").val();


        if (bg_color === 'rgb(255, 255, 255)') {
            $(this).css("background-color", bor_color);
            $(this).css("color", "white");
            $(this).attr("opsel", 1);
            var lid = $(this).attr("data-index");
            if (arr.indexOf(lid) == -1) {
                arr.push(lid);
            }
        } else {
            $(this).css("background-color", "rgb(255, 255, 255)");
            $(this).css("color", bor_color);
            $(this).attr("opsel", 0);
            var lid = $(this).attr("data-index");
            for (var i = 0; i < arr.length; i++) {
                if (arr[i] == lid) {
                    arr.splice(i, 1);
                }
            }
        }
    });
    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (var i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除400客户", "请至少选择一个400客户!", function () {
            });
        }
        else {
            House365Util.createModal("删除400客户", "确定要删除该400客户？", function () {
                $.ajax({
                    url: '${ctx}/customer/deleteHotLineCustomer/' + selectedId,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

    //排序
    function sortBy(column, mode) {
        $("form input[name='orderColumn']").val(column);
        $("form input[name='orderMode']").val(mode);
        $('#filterForm').submit();
    }

    $(document).on('click', '.collect', function () {
        var customerId = callId;
        $.ajax({
            url: '${ctx}/customermanagement/judgeStar/' + customerId,
            type: "GET",
            success: function (data) {
                if (data.status == 0) {
                    var img_src = $('#starImage').attr("src");
                    if (img_src === '${ctx}/resources/img/collect_no.png') {
                        $('#starImage').attr("src", "${ctx}/resources/img/collect_yes.png")
                    } else {
                        $('#starImage').attr("src", "${ctx}/resources/img/collect_no.png")
                    }
                } else {
                    alert(data.errorMessage);
                }
            }
        });
    });
</script>
</body>
</html>
