package com.house365.web.controller;

import com.house365.beans.entity.ReportLogEntity;
import com.house365.web.system.controller.BaseController;
import com.house365.ws.interfaces.server.IPropertyReportInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * 置业顾问日志controller
 *
 * @author Created by Administrator on 2020/4/29.
 */
@Controller
@RequestMapping("/reportlog")
public class ReportLogController extends BaseController {

    private static final Logger logger = LoggerFactory.getLogger(ReportLogController.class);

    @Autowired
    private IPropertyReportInterface reportInterface;

    @RequestMapping(value = "/list/{id}")
    public String list(Model model, @PathVariable int id) {
        try {
            //注释111222
            List<ReportLogEntity> list = reportInterface.queryReportLog(id);
            model.addAttribute("dataList", list);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("查询置业顾问日志失败", e);
        }
        return getAutoUrl();
    }
}
