/**
 * Description: ProjectSaler控制器
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-01-23 下午 17:14:15
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-01-23   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import com.house365.beans.entity.ProjectSalerEntity;
import com.house365.beans.system.Page;
import com.house365.beans.vo.ProjectSalerVo;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.request.ProjectSalerListRequest;
import com.house365.ws.beans.request.ProjectSalerRequest;
import com.house365.ws.beans.response.ProjectSalerListResponse;
import com.house365.ws.beans.response.ProjectSalerResponse;
import com.house365.ws.interfaces.server.IProjectSaler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.Map;

/**
 * ProjectSaler控制器<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-01-23
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/projectsaler")
public class ProjectSalerController extends BaseController {

    /**
     * 自动注入ProjectSalerWS实现
     */
    @Autowired
    private IProjectSaler projectSaler;

    /**
     * 去新增ProjectSaler
     *
     * @return 结果视图
     */
    @RequestMapping(value = "", params = "action=create")
    public String createForm(Model model) {
        model.addAttribute("action", "create");
        return getAutoUrl("form");
    }

    /**
     * 新增ProjectSaler
     *
     * @param vo     ProjectSaler页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "", method = {RequestMethod.POST})
    public String createProjectSaler(@Valid ProjectSalerVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model) {
        ProjectSalerEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                ProjectSalerRequest request = new ProjectSalerRequest();
                request.setEntity(entity);
                ProjectSalerResponse response = projectSaler
                        .addProjectSaler(request);
                Integer id = response.getEntity().getId();
                return "redirect:/projectsaler/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 删除ProjectSaler
     *
     * @param id ProjectSaler页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.DELETE})
    @ResponseStatus(HttpStatus.OK)
    public void delete(@PathVariable String id) {
        if (!StringUtils.isEmpty(id)) {
            if (id.contains(",")) {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    projectSaler.deleteProjectSalerById(Integer.valueOf(ids[i]));
                }
            } else {
                projectSaler.deleteProjectSalerById(Integer.valueOf(id));
            }
        }
    }

    /**
     * 去查看ProjectSaler
     *
     * @param id ProjectSaler页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET})
    public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        ProjectSalerResponse response = projectSaler.getProjectSalerById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
    }

    /**
     * 去修改ProjectSaler
     *
     * @param id ProjectSaler页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET}, params = "action=edit")
    public String updateForm(@PathVariable(value = "id") Integer id, Model model) {
        ProjectSalerResponse response = projectSaler
                .getProjectSalerById(id);
        model.addAttribute("entity", response.getEntity());
        model.addAttribute("action", "edit");
        return getAutoUrl("form");
    }

    /**
     * 修改ProjectSaler
     *
     * @param vo     ProjectSaler页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.POST})
    public String updateProjectSaler(@Valid ProjectSalerVo vo, BindingResult result, @PathVariable Integer id, RedirectAttributes redirectAttributes, Model model) {
        ProjectSalerEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                ProjectSalerRequest request = new ProjectSalerRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused")
                ProjectSalerResponse rersponse = projectSaler
                        .updateProjectSaler(request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/projectsaler/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 查询ProjectSaler
     *
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "", method = RequestMethod.GET)
    public String list(Integer number, Model model, HttpServletRequest request) {
        // 获取查询条件
        Map<String, Object> searchParams = Servlets.getParametersStartingWith(
                request, "search_");
        Page page = new Page();
        if (null != number) {
            page.setCurrentPage(number);
        }
        ProjectSalerListRequest listRequest = new ProjectSalerListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        ProjectSalerListResponse response = projectSaler.getProjectSalerList(listRequest);
        model.addAttribute("page", response.getPaging());
        model.addAttribute("projectSalers", response.getObjectList());
        model.addAttribute("searchParams", Servlets
                .encodeParameterStringWithPrefix(searchParams, "search_"));
        return getAutoUrl();
    }

}
