/**
 * Description: CustomerCallbackLog控制器
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-05 下午 22:04:06
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import com.google.common.base.Strings;
import com.house365.beans.entity.CustomerCallbackLogEntity;
import com.house365.beans.entity.CustomerCallbackTemplateEntity;
import com.house365.beans.entity.DepartmentEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.beans.system.Page;
import com.house365.beans.vo.CustomerCallbackLogVo;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.SessionConstants;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.request.CustomerCallbackLogListRequest;
import com.house365.ws.beans.request.CustomerCallbackLogRequest;
import com.house365.ws.beans.request.CustomerCallbackTemplateListRequest;
import com.house365.ws.beans.response.*;
import com.house365.ws.interfaces.server.ICustomer;
import com.house365.ws.interfaces.server.ICustomerCallbackLog;
import com.house365.ws.interfaces.server.ICustomerCallbackTemplate;
import com.house365.ws.interfaces.server.IDepartment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * CustomerCallbackLog控制器<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-05
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/customercallbacklog")
public class CustomerCallbackLogController extends BaseController {

    /**
     * 自动注入CustomerCallbackLogWS实现
     */
    @Autowired
    private ICustomerCallbackLog customerCallbackLog;

    @Autowired
    private ICustomer customer;

    @Autowired
    private IDepartment department;

    @Autowired
    private ICustomerCallbackTemplate customerCallbackTemplate;

    /**
     * 去新增CustomerCallbackLog
     *
     * @return 结果视图
     */
    @RequestMapping(value = "", params = "action=create")
    public String createForm(Model model) {
        model.addAttribute("action", "create");
        return getAutoUrl("form");
    }

    /**
     * 新增CustomerCallbackLog
     *
     * @param vo     CustomerCallbackLog页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "", method = {RequestMethod.POST})
    public String createCustomerCallbackLog(
            @Valid CustomerCallbackLogVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model
    ) {
        CustomerCallbackLogEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                CustomerCallbackLogRequest request = new CustomerCallbackLogRequest();
                request.setEntity(entity);
                CustomerCallbackLogResponse response = customerCallbackLog.addCustomerCallbackLog(request);
                Integer id = response.getEntity().getId();
                return "redirect:/customercallbacklog/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 删除CustomerCallbackLog
     *
     * @param id CustomerCallbackLog页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.DELETE})
    @ResponseStatus(HttpStatus.OK)
    public void delete(@PathVariable String id) {
        if (!StringUtils.isEmpty(id)) {
            if (id.contains(",")) {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    customerCallbackLog.deleteCustomerCallbackLogById(Integer.valueOf(ids[i]));
                }
            } else {
                customerCallbackLog.deleteCustomerCallbackLogById(Integer.valueOf(id));
            }
        }
    }

    /**
     * 去查看CustomerCallbackLog
     *
     * @param id CustomerCallbackLog页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET})
    public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        CustomerCallbackLogResponse response = customerCallbackLog.getCustomerCallbackLogById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
    }

    /**
     * 去修改CustomerCallbackLog
     *
     * @param id CustomerCallbackLog页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET}, params = "action=edit")
    public String updateForm(@PathVariable(value = "id") Integer id, Model model) {
        CustomerCallbackLogResponse response = customerCallbackLog.getCustomerCallbackLogById(id);
        model.addAttribute("entity", response.getEntity());
        model.addAttribute("action", "edit");
        return getAutoUrl("form");
    }

    /**
     * 修改CustomerCallbackLog
     *
     * @param vo     CustomerCallbackLog页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.POST})
    public String updateCustomerCallbackLog(
            @Valid CustomerCallbackLogVo vo, BindingResult result, @PathVariable Integer id,
            RedirectAttributes redirectAttributes, Model model
    ) {
        CustomerCallbackLogEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                CustomerCallbackLogRequest request = new CustomerCallbackLogRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused") CustomerCallbackLogResponse rersponse = customerCallbackLog.updateCustomerCallbackLog(
                        request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/customercallbacklog/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 查询CustomerCallbackLog
     *
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "", method = RequestMethod.GET)
    public String list(Integer number, Model model, HttpServletRequest request) {
        // 获取查询条件
        Map<String, Object> searchParams = Servlets.getParametersStartingWith(request, "search_");
        String customerId = request.getParameter("customerId");
        if (!Strings.isNullOrEmpty(customerId)) {
            UserEntity userEntity = (UserEntity) request.getSession().getAttribute(SessionConstants.THREAD_USER_KEY);
            Page page = new Page(20);
            if (null != number) {
                page.setCurrentPage(number);
            }
            searchParams.put("EQ_customerId", customerId);
            CustomerCallbackLogListRequest listRequest = new CustomerCallbackLogListRequest();
            listRequest.setPaging(page);
            listRequest.setSearchParams(searchParams);
            CustomerCallbackLogListResponse response = customerCallbackLog.getCustomerCallbackLogList(listRequest);
            CustomerResponse customerResponse = customer.getCustomerById(Integer.valueOf(customerId));

            DepartmentEntity departmentEntity = (DepartmentEntity) request.getSession().getAttribute(
                    SessionConstants.SESSION_CURRNET_DEPT_KEY);
            String cityId = departmentEntity.getCityID();
            DepartmentResponse departmentResponse = department.getDepartmentById(Integer.valueOf(cityId));
            String cityCode = departmentResponse.getEntity().getDescripition();

            // 获取回访内容模板
            CustomerCallbackTemplateListRequest callbackTemplateReq = new CustomerCallbackTemplateListRequest();
            callbackTemplateReq.setPaging(new Page(100));
            Map<String, Object> callbackTemplateParams = new HashMap<>();
            callbackTemplateParams.put("EQ_cityKey", cityCode);
            callbackTemplateReq.setSearchParams(callbackTemplateParams);
            CustomerCallbackTemplateListResponse callbackTemplateResponse =
                    customerCallbackTemplate.getCustomerCallbackTemplateList(callbackTemplateReq);
            List<CustomerCallbackTemplateEntity> callbackTemplateList = callbackTemplateResponse.getObjectList();

            // 回访内容模板
            model.addAttribute("callbackTemplateList", callbackTemplateList);

            model.addAttribute("page", response.getPaging());
            model.addAttribute("customerId", customerId);
            model.addAttribute("buyIntention", customerResponse.getEntity().getBuyIntention());
            model.addAttribute("customerCallbackLogs", response.getObjectList());
            model.addAttribute("searchParams", Servlets.encodeParameterStringWithPrefix(searchParams, "search_"));
            model.addAttribute("isPeer", customerResponse.getEntity().getIsPeer());
        }
        return getAutoUrl();
    }
}
