/**
 * Description: 客户活动来源页面表单对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-18 上午 08:58:25
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.vo;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.house365.beans.entity.CustomerSourceEntity;

/**
 * 客户活动来源页面表单对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-18
 * @see
 * @since 1.0
 */
public class CustomerSourceVo{
	/**
	 * 客户活动来源实体
	 */
    @NotNull
    @Valid
	private CustomerSourceEntity entity;
	

	/**
	 * 设置客户活动来源实体
	 * @param entity 客户活动来源实体
	 */
	public void setEntity(CustomerSourceEntity entity) {
		this.entity = entity;
	}

	/**
	 * 获取客户活动来源实体
	 * @return 客户活动来源实体
	 */
	public CustomerSourceEntity getEntity() {
		return this.entity;
	}
}