/**
 * Description: 抢客规则数据库实体/领域对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-29 下午 13:57:20
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

/**
 * 抢客规则数据库实体/领域对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-29
 * @see
 * @since 1.0
 */
public class RushCustomerRuleEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 部门
     */
    @Length(max = 255, message = "长度需要大于0且小于255")
    private String department;

    /**
     * 生效时间
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String activeTime;

    /**
     * 项目
     */
    @Length(max = 255, message = "长度需要大于0且小于255")
    private String project;

    /**
     * 来源
     */
    @Length(max = 255, message = "长度需要大于0且小于255")
    private String source;

    /**
     * 启用状态 0：未启用；1：启用；
     */

    private Integer status;

    /**
     * 项目名称
     */
    @Length(max = 255, message = "长度需要大于0且小于255")
    private String projectName;

    /**
     * 来源名称
     */
    @Length(max = 255, message = "长度需要大于0且小于255")
    private String sourceName;

    /**
     * 生效时间名称
     */
    @Length(max = 255, message = "长度需要大于0且小于255")
    private String activeTimeName;

    /**
     * 部门名称
     */
    @Length(max = 255, message = "长度需要大于0且小于255")
    private String departmentName;

    /**
     * createUserId
     */

    private Integer createUserId;

    /**
     * createUserName
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String createUserName;

    /**
     * createTime
     */

    private java.util.Date createTime;

    /**
     * updateUserId
     */

    private Integer updateUserId;

    /**
     * updateUserName
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String updateUserName;

    /**
     * updateTime
     */

    private java.util.Date updateTime;

    private String cityCode;

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    //columns END
    /*
	public RushCustomerRule(){
	}

	public RushCustomerRule(
		Integer id
	){
		this.id = id;
	}

    */

    /**
     * 获取部门
     * @return 部门
     */
    public String getDepartment() {
        return this.department;
    }

    /**
     * 设置部门
     * @param department 部门
     */
    public void setDepartment(String department) {
        this.department = department;
    }

    /**
     * 获取生效时间
     * @return 生效时间
     */
    public String getActiveTime() {
        return this.activeTime;
    }

    /**
     * 设置生效时间
     * @param activeTime 生效时间
     */
    public void setActiveTime(String activeTime) {
        this.activeTime = activeTime;
    }

    /**
     * 获取项目
     *
     * @return 项目
     */
    public String getProject() {
        return this.project;
    }

    /**
     * 设置项目
     * @param project 项目
     */
    public void setProject(String project) {
        this.project = project;
    }

    /**
     * 获取来源
     *
     * @return 来源
     */
    public String getSource() {
        return this.source;
    }

    /**
     * 设置来源
     *
     * @param source 来源
     */
    public void setSource(String source) {
        this.source = source;
    }

    /**
     * 获取启用状态 0：未启用；1：启用；
     *
     * @return 启用状态 0：未启用；1：启用；
     */
    public Integer getStatus() {
        return this.status;
    }

    /**
     * 设置启用状态 0：未启用；1：启用；
     *
     * @param status 启用状态 0：未启用；1：启用；
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取项目名称
     *
     * @return 项目名称
     */
    public String getProjectName() {
        return this.projectName;
    }

    /**
     * 设置项目名称
     *
     * @param projectName 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 获取来源名称
     * @return 来源名称
     */
    public String getSourceName() {
        return this.sourceName;
    }

    /**
     * 设置来源名称
     * @param sourceName 来源名称
     */
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    /**
     * 获取生效时间名称
     *
     * @return 生效时间名称
     */
    public String getActiveTimeName() {
        return this.activeTimeName;
    }

    /**
     * 设置生效时间名称
     * @param activeTimeName 生效时间名称
     */
    public void setActiveTimeName(String activeTimeName) {
        this.activeTimeName = activeTimeName;
    }

    /**
     * 获取部门名称
     *
     * @return 部门名称
     */
    public String getDepartmentName() {
        return this.departmentName;
    }

    /**
     * 设置部门名称
     *
     * @param departmentName 部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    /**
     * 获取createUserId
     *
     * @return createUserId
     */
    public Integer getCreateUserId() {
        return this.createUserId;
    }

    /**
     * 设置createUserId
     *
     * @param createUserId createUserId
     */
    public void setCreateUserId(Integer createUserId) {
        this.createUserId = createUserId;
    }

    /**
     * 获取createUserName
     *
     * @return createUserName
     */
    public String getCreateUserName() {
        return this.createUserName;
    }

    /**
     * 设置createUserName
     *
     * @param createUserName createUserName
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    /**
     * 设置createTime字符串格式
     *
     * @param createTime createTime
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取createTime
     *
     * @return createTime
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置createTime
     *
     * @param createTime createTime
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取updateUserId
     *
     * @return updateUserId
     */
    public Integer getUpdateUserId() {
        return this.updateUserId;
    }

    /**
     * 设置updateUserId
     *
     * @param updateUserId updateUserId
     */
    public void setUpdateUserId(Integer updateUserId) {
        this.updateUserId = updateUserId;
    }

    /**
     * 获取updateUserName
     *
     * @return updateUserName
     */
    public String getUpdateUserName() {
        return this.updateUserName;
    }

    /**
     * 设置updateUserName
     *
     * @param updateUserName updateUserName
     */
    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    /**
     * 设置updateTime字符串格式
     *
     * @param updateTime updateTime
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
                this.updateTime = java.text.DateFormat.getDateTimeInstance().parse(updateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取updateTime
     *
     * @return updateTime
     */
    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 设置updateTime
     *
     * @param updateTime updateTime
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("Department", getDepartment())
                .append("ActiveTime", getActiveTime())
                .append("Project", getProject())
                .append("Source", getSource())
                .append("Status", getStatus())
                .append("ProjectName", getProjectName())
                .append("SourceName", getSourceName())
                .append("ActiveTimeName", getActiveTimeName())
                .append("DepartmentName",getDepartmentName())
                .append("CreateUserId",getCreateUserId())
			.append("CreateUserName",getCreateUserName())
			.append("CreateTime",getCreateTime())
			.append("UpdateUserId",getUpdateUserId())
			.append("UpdateUserName",getUpdateUserName())
			.append("UpdateTime",getUpdateTime())
			.toString();
	}

	/**
     * 获取hash码
	 * @return HASH码
	 */
	public int hashCode() {
		return new HashCodeBuilder()
			.append(getId())
			.toHashCode();
	}

	/**
     * 对象比较
	 * @param obj 待比较对象
	 * @return 是否相同<li>true--相同<li>false--不相同
	 */
	public boolean equals(Object obj) {
		if(obj instanceof RushCustomerRuleEntity == false) return false;
		if(this == obj) return true;
		RushCustomerRuleEntity other = (RushCustomerRuleEntity)obj;
		return new EqualsBuilder()
			.append(getId(),other.getId())
			.isEquals();
	}
}

