package com.house365.commons.system;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 自定义注释注解
 * 
 * @author duhui
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER })
public @interface Description {

    // 方法的描述
    public String desc();

    // 返回值的描述
    public String returnDesc() default "";

    // 类型
    public enum type {
        STRING, SHORT, INT, BOOLEAN, LONG, INTEGER, OBJECT
    };

    // 类型
    public type type() default type.STRING;

    // 参数列表
    public DescriptionParameter[] parameters() default @DescriptionParameter(name = "", nameDesc = "");
}
