package com.house365.ws.service.impl;

import com.house365.beans.entity.VersionEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IVersionDao;
import com.house365.ws.service.interfaces.IVersionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("versionService")
public class VersionServiceImpl<T extends VersionEntity> extends DefaultServiceImpl<T> implements IVersionService<T> {

    @Autowired
    private IVersionDao<T> versionDao;

    @Override
    protected Dao<T> getDao() {
        return versionDao;
    }

    @Override
    public VersionEntity getLastVersion(VersionEntity ve) {
        List<VersionEntity> list = versionDao.getLastVersion(ve);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public void deleteVersionById(Integer id) {
        versionDao.deleteVersionById(id);
    }

    @Override
    public List<VersionEntity> getAppVersionList(QueryParams<VersionEntity> queryParams) {
        return versionDao.getAppVersionList(queryParams);
    }


}
