/**
 * Description: ReportChannel业务实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2017-07-17 上午 10:14:16
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.house365.dao.system.interfaces.Dao;
import com.house365.beans.system.QueryParams;
import com.house365.service.system.impl.DefaultServiceImpl;

import com.house365.ws.dao.interfaces.IReportChannelDao;
import com.house365.ws.service.interfaces.IReportChannelService;
import com.house365.beans.entity.ReportChannelEntity;

/**
 * ReportChannel业务实现类<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
@Service("reportChannelService")
public class ReportChannelServiceImpl<T extends ReportChannelEntity> extends DefaultServiceImpl<T> implements IReportChannelService<T> {
	/**
	 * 自动注入的数据访问对象
	 */
	@Autowired
	private IReportChannelDao<T> reportChannelDao;

    @Override
    protected Dao<T> getDao() {
        return reportChannelDao;
    }
}