/**
 * Description: Project业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-18 上午 10:05:24
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.ProjectDynamicEntity;
import com.house365.beans.entity.ProjectEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IProjectDao;
import com.house365.ws.service.interfaces.IProjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Project业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-18
 * @see
 * @since 1.0
 */
@Service("projectService")
public class ProjectServiceImpl<T extends ProjectEntity> extends DefaultServiceImpl<T> implements IProjectService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IProjectDao<T> projectDao;

    @Override
    protected Dao<T> getDao() {
        return projectDao;
    }

    @Override
    public List<ProjectEntity> queryCustomerProject(Integer customerId) {
        return projectDao.queryCustomerProject(customerId);
    }
    @Override
    public List<ProjectEntity> getDynamicById(ProjectDynamicEntity pde){
//        Map<String, Object> map = new HashMap<String, Object>();
//        map.put("projectId", projectId);
//        map.put("pageNo", pageNo);
//        map.put("pageSize", pageSize);
        return projectDao.getDynamicById(pde);
    }

    @Override
    public List<ProjectDynamicEntity> getDynamicList(QueryParams<ProjectDynamicEntity> queryParams){
        return projectDao.getDynamicList(queryParams);
    }

    @Override
    public void updateHotline(String buildingId, String shorttel) {
        projectDao.updateHotline(buildingId, shorttel);
    }

    @Override
    public void updateSaler() {
        projectDao.updateSaler();
    }

    @Override
    public List<ProjectEntity> queryByConditions(Map<String, Object> map) {
        return projectDao.queryByConditions(map);
    }
}
