/**
 * Description: 客户状态变更纪录业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-15 下午 15:36:20
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.google.common.base.Strings;
import com.house365.beans.entity.CustomerEntity;
import com.house365.beans.entity.CustomerStatusLogEntity;
import com.house365.beans.po.ProjectSrouceParaPo;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.ICustomerDao;
import com.house365.ws.dao.interfaces.ICustomerStatusLogDao;
import com.house365.ws.dao.mapper.CustomerStatusLogMapper;
import com.house365.ws.service.interfaces.ICustomerStatusLogService;
import com.house365.ws.util.Constant;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 客户状态变更纪录业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
@Service("customerStatusLogService")
public class CustomerStatusLogServiceImpl<T extends CustomerStatusLogEntity> extends DefaultServiceImpl<T> implements ICustomerStatusLogService<T> {

    /**
     * 日志记录器
     */
    private final Logger logger = LoggerFactory.getLogger(getClass());

    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private ICustomerStatusLogDao<T> customerStatusLogDao;

    @Autowired
    private ICustomerDao customerService;

    @Autowired
    private CustomerStatusLogMapper logMapper;

    @Override
    protected Dao<T> getDao() {
        return customerStatusLogDao;
    }

    @Override
    public void addStatusLog(
            Integer customerId, Integer fromStatus, Integer toStatus, String remark, String updater
    ) throws Exception {
        CustomerStatusLogEntity customerStatusLogEntity = new CustomerStatusLogEntity();

        if (fromStatus != null && toStatus != null) {
            if (fromStatus >= toStatus) {
                throw new Exception("状态变更无效");
            }
        }

        customerStatusLogEntity.setCustomerId(customerId);
        if (fromStatus != null) {
            customerStatusLogEntity.setFromStatusId(fromStatus);
            customerStatusLogEntity.setFromStatusName(Constant.CustomerStatusEnum.getMsgByStatus(fromStatus));
        }
        if (toStatus != null) {
            customerStatusLogEntity.setToStatusId(toStatus);
            customerStatusLogEntity.setToStatusName(Constant.CustomerStatusEnum.getMsgByStatus(toStatus));
        }

        customerStatusLogEntity.setRemark(remark);
        customerStatusLogEntity.setCreater(
                Strings.isNullOrEmpty(updater) ? Constant.CustomerSourceEnum.SYSTEM.getMsg() : updater);
        customerStatusLogEntity.setCreateTime(new Date());
        //        customerStatusLogDao.addCustomerStatusLog(customerStatusLogEntity);

        save((T) customerStatusLogEntity);
    }

    /**
     * @param customerId
     * @param fromStatus
     * @param toStatus
     * @param remark
     * @param updater
     * @param projectId
     * @param isRepeat      是否重客  1是 0 否
     * @param statisticFlag 源状态和目标状态相同时标记为不参与统计 1参与统计0不参与统计
     * @throws Exception
     */
    @Override
    public void addStatusLogWithProject(
            Integer customerId, Integer fromStatus, Integer toStatus, String remark, String updater, Date occurTime, Integer projectId,
            Integer isRepeat, Integer statisticFlag
    ) throws Exception {
        //添加日志时更新以前日志有效性
        Map<String, Object> map = new HashMap<>(10);
        map.put("customerId", customerId);
        map.put("toStatusId", 0);
        map.put("projectId", projectId);
        List<CustomerStatusLogEntity> logList = logMapper.queryByConditions(map);
        if (CollectionUtils.isNotEmpty(logList) && toStatus != null) {
            for (CustomerStatusLogEntity e : logList) {
                if (e.getToStatusId() != null && e.getToStatusId() >= toStatus) {
                    Map<String, Object> updateMap = new HashMap<>(5);
                    updateMap.put("id", e.getId());
                    logMapper.updateIsDelete(updateMap);
                }
            }
        }

        CustomerStatusLogEntity customerStatusLogEntity = new CustomerStatusLogEntity();

        CustomerEntity customer = (CustomerEntity) customerService.getById(customerId);
        customerStatusLogEntity.setOccurTime(occurTime);
        customerStatusLogEntity.setCustomerId(customerId);
        if (fromStatus != null) {
            customerStatusLogEntity.setFromStatusId(fromStatus);
            customerStatusLogEntity.setFromStatusName(Constant.CustomerStatusEnum.getMsgByStatus(fromStatus));
        }
        if (toStatus != null) {
            customerStatusLogEntity.setToStatusId(toStatus);
            customerStatusLogEntity.setToStatusName(Constant.CustomerStatusEnum.getMsgByStatus(toStatus));
        }

        customerStatusLogEntity.setRemark(remark);
        customerStatusLogEntity.setCreater(
                Strings.isNullOrEmpty(updater) ? Constant.CustomerSourceEnum.SYSTEM.getMsg() : updater);
        customerStatusLogEntity.setCreateTime(new Date());
        //        customerStatusLogDao.addCustomerStatusLog(customerStatusLogEntity);
        customerStatusLogEntity.setProjectId(projectId);
        customerStatusLogEntity.setIsRepeat(isRepeat);

        //同一个项目 同一个客户 同一个状态 同一个置业顾问 状态变更 标记是否统计为否 1参与统计0不参与统计
        Map<String, Object> queryMap = new HashMap<>(10);
        queryMap.put("EQ_toStatusId", toStatus);
        queryMap.put("EQ_customerId", customerId);
        queryMap.put("EQ_projectId", projectId);
        queryMap.put("EQ_customerManagerId", customer.getManagerId());
        QueryParams queryParams = new QueryParams(queryMap);
        int checkNum = getTotalCount(queryParams);
        if (checkNum > 0) {
            statisticFlag = 0;
        } else {
            statisticFlag = 1;
        }

        customerStatusLogEntity.setNonStatistic(statisticFlag);
        if (customer != null) {
            customerStatusLogEntity.setCustomerManagerId(customer.getManagerId());
            customerStatusLogEntity.setCustomerManagerName(customer.getManagerName());
        }

        save((T) customerStatusLogEntity);

    }

    @Override
    public List<Map<String, Long>> getProjectTransform(Map<String, Object> map) {
        return customerStatusLogDao.getProjectTransform(map);
    }

    @Override
    public List<Map<String, Object>> getProjectSource(ProjectSrouceParaPo map) {
        return customerStatusLogDao.getProjectSource(map);
    }

    @Override
    public int getSeeCount(Integer managerId) {
        Map<String, Object> searchParams = new HashMap<>();
        searchParams.put("EQ_customerManagerId", managerId);
        searchParams.put("EQ_toStatusId", 2);
        QueryParams statusLogQueryParams = new QueryParams(searchParams);
        return customerStatusLogDao.getTotalCount(statusLogQueryParams);
    }
}
