/**
 * Description: CustomerCallbackLog业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-15 下午 15:36:17
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.house365.dao.system.interfaces.Dao;
import com.house365.beans.system.QueryParams;
import com.house365.service.system.impl.DefaultServiceImpl;

import com.house365.ws.dao.interfaces.ICustomerCallbackLogDao;
import com.house365.ws.service.interfaces.ICustomerCallbackLogService;
import com.house365.beans.entity.CustomerCallbackLogEntity;

/**
 * CustomerCallbackLog业务实现类<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
@Service("customerCallbackLogService")
public class CustomerCallbackLogServiceImpl<T extends CustomerCallbackLogEntity> extends DefaultServiceImpl<T> implements ICustomerCallbackLogService<T> {
	/**
	 * 自动注入的数据访问对象
	 */
	@Autowired
	private ICustomerCallbackLogDao<T> customerCallbackLogDao;

    @Override
    protected Dao<T> getDao() {
        return customerCallbackLogDao;
    }
}