package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.house365.beans.entity.UserEntity;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.response.CustomerResponse;
import com.house365.ws.service.interfaces.IUserService;
import com.house365.ws.system.ReturnAppResult;
import com.house365.ws.util.Constant;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

/**
 * <p>Title: 更新直销人员信息</p>
 * <p>Description: </p>
 * <p>Date: 2018/5/10</p>
 *
 * @author XN
 * @version 1.0
 */
@Service("updateUser")
public class UpdateUserImpl implements IUpdateUser {

    @Autowired
    private IUserService userService;

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<CustomerResponse> response = new House365RestResponse<CustomerResponse>();

        // 业务校验统一入口
        try {
            checkInterfaceParameter(map, Constant.IdParams);
            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
            response.setMsg(ReturnAppResult.APP_SUCCESS.getResultMessage());
        } catch (IllegalServiceParameterException e) {
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg(e.getMessage());
            return JSONObject.fromObject(response).toString();
        }

        String id = getMapValueByKey("id", map, "");
        String hotlinephone = getMapValueByKey("hotlinephone", map, "");
        String goodat = getMapValueByKey("goodat", map, "");
        String description = getMapValueByKey("description", map, "");
        String headImgURL = getMapValueByKey("headImgURL", map, "");
        String fullImgURL = getMapValueByKey("fullImgURL", map, "");
        String defaultVisit = getMapValueByKey("defaultVisit", map, "");

        if (Strings.isNullOrEmpty(id) || !StringUtils.isNumeric(id)) {
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg("ID不能为空");
            return JSONObject.fromObject(response).toString();
        }

        System.out.println("=========" + id + "," + hotlinephone + "," + goodat + "," + description + "," + headImgURL + "," + fullImgURL);

        UserEntity userEntity = (UserEntity) userService.getById(Integer.parseInt(id));
        if (userEntity == null) {
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg("记录不存在");
            return JSONObject.fromObject(response).toString();
        }
        userEntity.setGoodat(goodat);
        userEntity.setDescription(description);
        userEntity.setHeadImgURL(headImgURL);
        userEntity.setFullImgURL(fullImgURL);
        userEntity.setHotlinephone(hotlinephone);

        userEntity.setUpdateTime(new Date());
        userEntity.setUpdateUsername("UpdateUserImpl");
        userEntity.setDefaultVisit(Integer.parseInt(defaultVisit));
        userService.update(userEntity);
        response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
        response.setMsg(ReturnAppResult.APP_SUCCESS.getResultMessage());
        return JSONObject.fromObject(response).toString();
    }

    /**
     * 业务层统校验自己所需参数是否存在
     * 所有参数都要存在
     *
     * @author hqc
     */
    protected void checkInterfaceParameter(
            Map<String, Object> map, String[] checkParams
    ) throws IllegalServiceParameterException {
        // 方法所需参数
        for (String str : checkParams) {
            // 如果不存在跳出 同时抛出相应异常
            if (!map.containsKey(str)) {
                throw new IllegalServiceParameterException("业务入口参数异常：" + str + "参数为空!");
            }
        }
    }

    /**
     * 获取map中的值
     *
     * @param key          key
     * @param map          map
     * @param defaultValue 默认值
     * @return value
     */
    private String getMapValueByKey(String key, Map<String, Object> map, String defaultValue) {
        String value = "";
        if (map.containsKey(key) && map.get(key) != null && !Strings.isNullOrEmpty(((String[]) map.get(key))[0])) {
            value = ((String[]) map.get(key))[0];
        }

        if (Strings.isNullOrEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }
}
