package com.house365.ws.interfaces.rest;

import com.house365.beans.entity.AppUrl;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.service.interfaces.IGetAppUrlService;
import com.house365.ws.system.ReturnAppResult;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Created by Administrator on 2018/9/13.
 */
@Service("getAppUrl")
public class GetAppUrlImpl implements IGetAppUrl {

    private static final Logger logger = LoggerFactory.getLogger(GetAppUrlImpl.class);

    @Autowired
    private IGetAppUrlService appUrlService;

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        House365RestResponse<Map<String, Object>> response = new House365RestResponse<>();
        // 业务层统一处理
        try {
            List<AppUrl> list = appUrlService.getListByType(1);
            List<AppUrl> list1 = appUrlService.getListByType(2);
            List<AppUrl> list2 = appUrlService.getListByType(3);
            List<AppUrl> list3 = appUrlService.getListByType(4);
            List<AppUrl> list4 = appUrlService.getListByType(5);
            Map<String, Object> map1 = new HashMap<>(10);
            House365RestObject<Map<String, Object>> restObject = new House365RestObject<>();
            map1.put("topList", list);
            map1.put("centerList", list1);
            map1.put("myList", list2);
            map1.put("projectList", list3);
            map1.put("userConfigList", list4);

            restObject.setEntity(map1);
            response.setData(restObject);
            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());

        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), e);
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg((ReturnAppResult.APP_FAIL.getResultMessage() + ":" + e.getMessage()));
        }
        return JSONObject.fromObject(response).toString();
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }
}
