/**
 * Description: UserStarWS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-05-15 下午 17:04:55
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-05-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.UserStarEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.UserStarListRequest;
import com.house365.ws.beans.request.UserStarRequest;
import com.house365.ws.beans.response.UserStarListResponse;
import com.house365.ws.beans.response.UserStarResponse;
import com.house365.ws.interfaces.server.IUserStar;
import com.house365.ws.service.interfaces.IUserStarService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * UserStarWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-05-15
 * @see
 * @since 1.0
 */
@Service("userStar")
public class UserStarImpl implements IUserStar {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(UserStarImpl.class);

    /**
     * UserStar服务对象
     */
    @Autowired
    private IUserStarService<UserStarEntity> userStarService;

    /**
     * UserStar列表查询
     *
     * @param request UserStar列表查询请求
     * @return UserStar列表查询响应
     */
    @Override
    public UserStarListResponse getUserStarList(UserStarListRequest request) {
        UserStarListResponse response = new UserStarListResponse();
        try {
            QueryParams<UserStarEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<UserStarEntity> userStars = userStarService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(userStars);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存UserStar
     *
     * @param request UserStar请求
     * @return 保存UserStar响应
     */
    @Override
    public UserStarResponse addUserStar(UserStarRequest request) {
        UserStarResponse response = new UserStarResponse();
        try {
            UserStarEntity entity = request.getEntity();
            userStarService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除UserStar通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除UserStar响应
     */
    @Override
    public UserStarResponse deleteUserStarById(Integer id) {
        UserStarResponse response = new UserStarResponse();
        try {
            userStarService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改UserStar
     *
     * @param request 修改UserStar请求
     * @return 修改UserStar响应
     */
    @Override
    public UserStarResponse updateUserStar(UserStarRequest request) {
        UserStarResponse response = new UserStarResponse();
        try {
            userStarService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取UserStar
     *
     * @param id 唯一标识
     * @return 通过ID获取UserStar响应
     */
    @Override
    public UserStarResponse getUserStarById(Integer id) {
        UserStarResponse response = new UserStarResponse();
        try {
            UserStarEntity entity = userStarService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
