/**
 * Description: RushCustomerRuleDepartmentRelWS接口
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-01-10 上午 09:00:35
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-01-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.DepartmentEntity;
import com.house365.beans.entity.RushCustomerRuleDepartmentRelEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.RushCustomerRuleDepartmentRelListRequest;
import com.house365.ws.beans.request.RushCustomerRuleDepartmentRelRequest;
import com.house365.ws.beans.response.RushCustomerRuleDepartmentRelListResponse;
import com.house365.ws.beans.response.RushCustomerRuleDepartmentRelResponse;
import com.house365.ws.interfaces.server.IRushCustomerRuleDepartmentRel;
import com.house365.ws.service.interfaces.IDepartmentService;
import com.house365.ws.service.interfaces.IRushCustomerRuleDepartmentRelService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * RushCustomerRuleDepartmentRelWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-01-10
 * @see
 * @since 1.0
 */
@Service("rushCustomerRuleDepartmentRel")
public class RushCustomerRuleDepartmentRelImpl implements IRushCustomerRuleDepartmentRel {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(RushCustomerRuleDepartmentRelImpl.class);

    /**
     * RushCustomerRuleDepartmentRel服务对象
     */
    @Autowired
    IRushCustomerRuleDepartmentRelService<RushCustomerRuleDepartmentRelEntity> rushCustomerRuleDepartmentRelService;
    @Autowired
    IDepartmentService<DepartmentEntity> departmentService;

    /**
     * RushCustomerRuleDepartmentRel列表查询
     *
     * @param request RushCustomerRuleDepartmentRel列表查询请求
     * @return RushCustomerRuleDepartmentRel列表查询响应
     */
    @Override
    public RushCustomerRuleDepartmentRelListResponse getRushCustomerRuleDepartmentRelList(
            RushCustomerRuleDepartmentRelListRequest request) {
        RushCustomerRuleDepartmentRelListResponse response = new RushCustomerRuleDepartmentRelListResponse();
        try {
            QueryParams<RushCustomerRuleDepartmentRelEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            List<RushCustomerRuleDepartmentRelEntity> rushCustomerRuleDepartmentRels = rushCustomerRuleDepartmentRelService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(rushCustomerRuleDepartmentRels);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存RushCustomerRuleDepartmentRel
     *
     * @param request RushCustomerRuleDepartmentRel请求
     * @return 保存RushCustomerRuleDepartmentRel响应
     */
    @Override
    public RushCustomerRuleDepartmentRelResponse addRushCustomerRuleDepartmentRel(RushCustomerRuleDepartmentRelRequest request) {
        RushCustomerRuleDepartmentRelResponse response = new RushCustomerRuleDepartmentRelResponse();
        try {
            RushCustomerRuleDepartmentRelEntity entity = request.getEntity();
            rushCustomerRuleDepartmentRelService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除RushCustomerRuleDepartmentRel通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除RushCustomerRuleDepartmentRel响应
     */
    @Override
    public RushCustomerRuleDepartmentRelResponse deleteRushCustomerRuleDepartmentRelById(Integer id) {
        RushCustomerRuleDepartmentRelResponse response = new RushCustomerRuleDepartmentRelResponse();
        try {
            rushCustomerRuleDepartmentRelService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改RushCustomerRuleDepartmentRel
     *
     * @param request 修改RushCustomerRuleDepartmentRel请求
     * @return 修改RushCustomerRuleDepartmentRel响应
     */
    @Override
    public RushCustomerRuleDepartmentRelResponse updateRushCustomerRuleDepartmentRel(
            RushCustomerRuleDepartmentRelRequest request) {
        RushCustomerRuleDepartmentRelResponse response = new RushCustomerRuleDepartmentRelResponse();
        try {
            rushCustomerRuleDepartmentRelService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取RushCustomerRuleDepartmentRel
     *
     * @param id 唯一标识
     * @return 通过ID获取RushCustomerRuleDepartmentRel响应
     */
    @Override
    public RushCustomerRuleDepartmentRelResponse getRushCustomerRuleDepartmentRelById(Integer id) {
        RushCustomerRuleDepartmentRelResponse response = new RushCustomerRuleDepartmentRelResponse();
        try {
            RushCustomerRuleDepartmentRelEntity entity = rushCustomerRuleDepartmentRelService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    @Override
    public void saveDepartmentRuleRel(Integer ruleId, String departmentIds) {
        deleteDepartmentRuleRelByRuleId(ruleId);

        String[] departmentIdArray = departmentIds.split(",");
        for (String departmentId : departmentIdArray) {
            DepartmentEntity departmentEntity = departmentService.getById(Integer.valueOf(departmentId));
            RushCustomerRuleDepartmentRelEntity rel = new RushCustomerRuleDepartmentRelEntity();
            rel.setDepartmentId(Integer.valueOf(departmentId));
            rel.setRushCustomerRuleId(ruleId);
            rel.setDepartmentName(departmentEntity.getName());
            rushCustomerRuleDepartmentRelService.save(rel);
        }
    }

    @Override
    public void deleteDepartmentRuleRelByRuleId(Integer ruleId) {
        Map<String, Object> searchParams = new HashMap<>();
        searchParams.put("EQ_rushCustomerRuleId", ruleId);
        //每次保存，先删除，再添加
        QueryParams<RushCustomerRuleDepartmentRelEntity> queryParams = new QueryParams<>(searchParams);
        List<RushCustomerRuleDepartmentRelEntity> rushCustomerRuleDepartmentRels = rushCustomerRuleDepartmentRelService.queryAll(queryParams);
        for (RushCustomerRuleDepartmentRelEntity rel : rushCustomerRuleDepartmentRels) {
            rushCustomerRuleDepartmentRelService.delete(rel.getId());
        }
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
