package com.house365.ws.interfaces.impl;


import com.house365.beans.entity.BaseAttachment;
import com.house365.beans.entity.ProjectDynamicEntity;
import com.house365.beans.system.Page;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.ProjectDynamicRequest;
import com.house365.ws.beans.response.ProjectDynamicResponse;
import com.house365.ws.interfaces.server.IProjectDynamic;
import com.house365.ws.service.interfaces.IProjectDynamicService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author
 */
@Service("projectDynamic")
public class ProjectDynamicImpl implements IProjectDynamic {

    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectImpl.class);

    /**
     * Project服务对象
     */
    @Autowired
    private IProjectDynamicService<ProjectDynamicEntity> projectDynamicService;

    @Override
    public ProjectDynamicResponse getDynamicList(ProjectDynamicRequest request) {
        ProjectDynamicResponse response = new ProjectDynamicResponse();
        try {
            QueryParams<ProjectDynamicEntity> queryParams = new QueryParams<>(request.getSearchParams());
            Page page = request.getPaging();
            queryParams.setPaging(page);
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<ProjectDynamicEntity> projects = projectDynamicService.queryByPage(queryParams);

            response.setPaging(queryParams.getPaging());
            response.setObjectList(projects);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public List<BaseAttachment> queryDynamicPicByResouceType(String channel) {
        return projectDynamicService.queryDynamicPicByResouceType(channel);
    }

    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }


}
