/**
 * Description: HouseInfoWS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-18 下午 15:44:53
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.HouseInfoEntity;
import com.house365.beans.system.Page;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.HouseInfoListRequest;
import com.house365.ws.beans.request.HouseInfoRequest;
import com.house365.ws.beans.response.HouseInfoListResponse;
import com.house365.ws.beans.response.HouseInfoResponse;
import com.house365.ws.interfaces.server.IHouseInfo;
import com.house365.ws.service.interfaces.IHouseInfoService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * HouseInfoWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-18
 * @see
 * @since 1.0
 */
@Service("houseInfo")
public class HouseInfoImpl implements IHouseInfo {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(HouseInfoImpl.class);

    /**
     * HouseInfo服务对象
     */
    @Autowired
    IHouseInfoService<HouseInfoEntity> houseInfoService;

    /**
     * HouseInfo列表查询
     *
     * @param request HouseInfo列表查询请求
     * @return HouseInfo列表查询响应
     */
    @Override
    public HouseInfoListResponse getHouseInfoList(HouseInfoListRequest request) {
        HouseInfoListResponse response = new HouseInfoListResponse();
        try {
            QueryParams<HouseInfoEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<HouseInfoEntity> houseInfos = houseInfoService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(houseInfos);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存HouseInfo
     *
     * @param request HouseInfo请求
     * @return 保存HouseInfo响应
     */
    @Override
    public HouseInfoResponse addHouseInfo(HouseInfoRequest request) {
        HouseInfoResponse response = new HouseInfoResponse();
        try {
            HouseInfoEntity entity = request.getEntity();
            houseInfoService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除HouseInfo通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除HouseInfo响应
     */
    @Override
    public HouseInfoResponse deleteHouseInfoById(Integer id) {
        HouseInfoResponse response = new HouseInfoResponse();
        try {
            houseInfoService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改HouseInfo
     *
     * @param request 修改HouseInfo请求
     * @return 修改HouseInfo响应
     */
    @Override
    public HouseInfoResponse updateHouseInfo(HouseInfoRequest request) {
        HouseInfoResponse response = new HouseInfoResponse();
        try {
            houseInfoService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取HouseInfo
     *
     * @param id 唯一标识
     * @return 通过ID获取HouseInfo响应
     */
    @Override
    public HouseInfoResponse getHouseInfoById(Integer id) {
        HouseInfoResponse response = new HouseInfoResponse();
        try {
            HouseInfoEntity entity = houseInfoService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public HouseInfoListResponse getHouseInfoListByActiveId(Integer activeId) {
        HouseInfoListResponse response = new HouseInfoListResponse();
        try {
            Map<String, Object> searchMap = new HashMap<>();
            searchMap.put("EQ_activeId", activeId);
            QueryParams<HouseInfoEntity> queryParams = new QueryParams<>(searchMap);
            queryParams.setPaging(new Page(Integer.MAX_VALUE));
            List<HouseInfoEntity> houseInfos = houseInfoService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(houseInfos);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public void updateHouseNameByActiveId(Integer id, String city) {
        houseInfoService.updateHouseNameByActiveId(id, city);
    }


    /**
     * 以下均为自动生成
     */
    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
