/**
 * Description: EvaluateUserCustomerLogWS接口
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-01-16 下午 18:38:35
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-01-16   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.EvaluateUserCustomerLogEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.EvaluateUserCustomerLogListRequest;
import com.house365.ws.beans.request.EvaluateUserCustomerLogRequest;
import com.house365.ws.beans.response.EvaluateUserCustomerLogListResponse;
import com.house365.ws.beans.response.EvaluateUserCustomerLogResponse;
import com.house365.ws.interfaces.server.IEvaluateUserCustomerLog;
import com.house365.ws.service.interfaces.IEvaluateUserCustomerLogService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * EvaluateUserCustomerLogWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-01-16
 * @see
 * @since 1.0
 */
@Service("evaluateUserCustomerLog")
public class EvaluateUserCustomerLogImpl implements IEvaluateUserCustomerLog {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory
            .getLogger(EvaluateUserCustomerLogImpl.class);

    /**
     * EvaluateUserCustomerLog服务对象
     */
    @Autowired
    IEvaluateUserCustomerLogService<EvaluateUserCustomerLogEntity> evaluateUserCustomerLogService;

    /**
     * EvaluateUserCustomerLog列表查询
     *
     * @param request EvaluateUserCustomerLog列表查询请求
     * @return EvaluateUserCustomerLog列表查询响应
     */
    @Override
    public EvaluateUserCustomerLogListResponse getEvaluateUserCustomerLogList(
            EvaluateUserCustomerLogListRequest request) {
        EvaluateUserCustomerLogListResponse response = new EvaluateUserCustomerLogListResponse();
        try {
            QueryParams<EvaluateUserCustomerLogEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn("a.id");
            queryParams.setOrderMode("desc");
            List<EvaluateUserCustomerLogEntity> evaluateUserCustomerLogs = evaluateUserCustomerLogService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(evaluateUserCustomerLogs);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存EvaluateUserCustomerLog
     *
     * @param request EvaluateUserCustomerLog请求
     * @return 保存EvaluateUserCustomerLog响应
     */
    @Override
    public EvaluateUserCustomerLogResponse addEvaluateUserCustomerLog(EvaluateUserCustomerLogRequest request) {
        EvaluateUserCustomerLogResponse response = new EvaluateUserCustomerLogResponse();
        try {
            EvaluateUserCustomerLogEntity entity = request.getEntity();
            evaluateUserCustomerLogService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除EvaluateUserCustomerLog通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除EvaluateUserCustomerLog响应
     */
    @Override
    public EvaluateUserCustomerLogResponse deleteEvaluateUserCustomerLogById(Integer id) {
        EvaluateUserCustomerLogResponse response = new EvaluateUserCustomerLogResponse();
        try {
            evaluateUserCustomerLogService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改EvaluateUserCustomerLog
     *
     * @param request 修改EvaluateUserCustomerLog请求
     * @return 修改EvaluateUserCustomerLog响应
     */
    @Override
    public EvaluateUserCustomerLogResponse updateEvaluateUserCustomerLog(
            EvaluateUserCustomerLogRequest request) {
        EvaluateUserCustomerLogResponse response = new EvaluateUserCustomerLogResponse();
        try {

            EvaluateUserCustomerLogEntity oldEntity = evaluateUserCustomerLogService.getById(request.getEntity().getId());
            if (oldEntity.getIsEvaluated() == 1) {
                response.setResultCode(ReturnResult.FAIL.getResultCode());
                response.setResultMessage("该带看已被评价！");
                return response;
            }
            evaluateUserCustomerLogService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取EvaluateUserCustomerLog
     *
     * @param id 唯一标识
     * @return 通过ID获取EvaluateUserCustomerLog响应
     */
    @Override
    public EvaluateUserCustomerLogResponse getEvaluateUserCustomerLogById(Integer id) {
        EvaluateUserCustomerLogResponse response = new EvaluateUserCustomerLogResponse();
        try {
            EvaluateUserCustomerLogEntity entity = evaluateUserCustomerLogService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public EvaluateUserCustomerLogResponse evaluateUser(Integer id, Integer score, String content, String tags) {
        EvaluateUserCustomerLogResponse response = new EvaluateUserCustomerLogResponse();
        try {

            EvaluateUserCustomerLogEntity entity = evaluateUserCustomerLogService.getById(id);
            if (entity.getIsEvaluated() == 1) {
                response.setResultCode(ReturnResult.FAIL.getResultCode());
                response.setResultMessage("该带看已被评价！");
                return response;
            }
            entity.setContentTags(tags);
            entity.setScore(score);
            entity.setContent(content);
            entity.setEvaluateTime(new Date());
            entity.setIsEvaluated(1);
            evaluateUserCustomerLogService.update(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public EvaluateUserCustomerLogResponse check(Integer id, Integer checkStatus, String userName) {
        EvaluateUserCustomerLogResponse response = new EvaluateUserCustomerLogResponse();
        try {
            EvaluateUserCustomerLogEntity entity = evaluateUserCustomerLogService.getById(id);
            entity.setCheckStatus(checkStatus);
            entity.setCheckTime(new Date());
            entity.setCheckMan(userName);
            evaluateUserCustomerLogService.update(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
