/**
 * Description: ProjectSourceStatistics数据访问实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-17 下午 14:59:25
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import java.util.List;

import com.house365.beans.system.QueryParams;
import org.springframework.stereotype.Repository;

import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.IProjectSourceStatisticsDao;
import com.house365.beans.entity.ProjectSourceStatisticsEntity;
import com.house365.beans.po.ProjectSrouceParaPo;
import com.house365.beans.po.ProjectSrouceRePo;

/**
 * ProjectSourceStatistics数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-17
 * @see
 * @since 1.0
 */
@Repository("projectSourceStatisticsDao")
public class ProjectSourceStatisticsDaoImpl extends DefaultDaoImpl<ProjectSourceStatisticsEntity> implements IProjectSourceStatisticsDao<ProjectSourceStatisticsEntity> {

    @Override
    public List<ProjectSrouceRePo> queryByDay(ProjectSrouceParaPo para) {
        return this.getReadTemplate().queryForList(getStatement(), para);
    }

    @Override
    public List<ProjectSrouceRePo> queryByWeek(ProjectSrouceParaPo para) {
        return this.getReadTemplate().queryForList(getStatement(), para);
    }

    @Override
    public List<ProjectSrouceRePo> queryByMonth(ProjectSrouceParaPo para) {
        return this.getReadTemplate().queryForList(getStatement(), para);
    }

    @Override
    public List<ProjectSourceStatisticsEntity> statisticCustomer(QueryParams<?> queryParams) {
        return this.getReadTemplate().queryForList(getStatement(), queryParams);
    }

    @Override
    public void updateProjectName() {
        this.getReadTemplate().update(getStatement());
    }

    @Override
    public void updateSourceName() {
        this.getReadTemplate().update(getStatement());
    }

    @Override
    public void updateCityName() {
        this.getReadTemplate().update(getStatement());
    }

    @Override
    public void deleteByDate(String startDateStr) {
        this.getReadTemplate().delete(getStatement(), startDateStr);
    }
}
