/**
 * Description: 抢客WS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-05 上午 09:44:17
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.RushCustomerListRequest;
import com.house365.ws.beans.request.RushCustomerRequest;
import com.house365.ws.beans.response.RushCustomerListResponse;
import com.house365.ws.beans.response.RushCustomerResponse;

import java.util.Map;


/**
 * 抢客WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
public interface IRushCustomer extends IService {

    /**
     * 抢客列表查询
     *
     * @param request 抢客列表查询请求
     * @return 抢客列表查询响应
     */
    RushCustomerListResponse getRushCustomerList(
            RushCustomerListRequest request);

    /**
     * 保存抢客
     *
     * @param request 抢客请求
     * @return 保存抢客响应
     */
    RushCustomerResponse addRushCustomer(RushCustomerRequest request);

    /**
     * 删除抢客通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除抢客响应
     */
    RushCustomerResponse deleteRushCustomerById(Integer id);

    /**
     * 修改抢客
     *
     * @param request 修改抢客请求
     * @return 修改抢客响应
     */
    RushCustomerResponse updateRushCustomer(
            RushCustomerRequest request);

    /**
     * 通过ID获取抢客
     *
     * @param id 唯一标识
     * @return 通过ID获取抢客响应
     */
    RushCustomerResponse getRushCustomerById(Integer id);

    void bindUser(String[] customerIds, Integer userId, Integer operId,String userName) throws Exception;

    RushCustomerListResponse getRushCustomerList(String timeType, String startTime, String endTime, String type, String phone, Integer userId, String city, Integer number);

    Map<String, Object> getRushCustomerCounts(String timeType, String startTime, String endTime, Integer userId, String city, String phone);
}
