/**
 * Description: ProjectSalerWS接口
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-01-23 下午 17:14:15
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-01-23   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.beans.entity.ProjectSalerEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.rest.context.IService;
import com.house365.rest.exception.ServiceException;
import com.house365.ws.beans.request.ProjectSalerListRequest;
import com.house365.ws.beans.request.ProjectSalerRequest;
import com.house365.ws.beans.response.ProjectSalerListResponse;
import com.house365.ws.beans.response.ProjectSalerResponse;

import java.util.List;


/**
 * ProjectSalerWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-01-23
 * @see
 * @since 1.0
 */
public interface IProjectSaler extends IService {

    /**
     * ProjectSaler列表查询
     *
     * @param request ProjectSaler列表查询请求
     * @return ProjectSaler列表查询响应
     */
    ProjectSalerListResponse getProjectSalerList(ProjectSalerListRequest request);

    ProjectSalerResponse addProjectSaler(ProjectSalerRequest request);

    ProjectSalerResponse deleteProjectSalerById(Integer id);

    ProjectSalerResponse updateProjectSaler(ProjectSalerRequest request);

    ProjectSalerResponse getProjectSalerById(Integer id);

    List<UserEntity> queryUserByPrjId(Integer projectId, String city);

    void deleteByProjectId(Integer projectId);

    void doBindSaler(UserEntity userEntity, String userIds, String projectIds) throws ServiceException;

    List<ProjectSalerEntity> queryAllList();

    String syncData(List<ProjectSalerEntity> list);
}
