/**
 * Description: EvaluateUserCustomerLogWS接口
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-01-16 下午 18:38:35
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-01-16   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.EvaluateUserCustomerLogListRequest;
import com.house365.ws.beans.request.EvaluateUserCustomerLogRequest;
import com.house365.ws.beans.response.EvaluateUserCustomerLogListResponse;
import com.house365.ws.beans.response.EvaluateUserCustomerLogResponse;


/**
 * EvaluateUserCustomerLogWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-01-16
 * @see
 * @since 1.0
 */
public interface IEvaluateUserCustomerLog extends IService {

    /**
     * EvaluateUserCustomerLog列表查询
     *
     * @param request EvaluateUserCustomerLog列表查询请求
     * @return EvaluateUserCustomerLog列表查询响应
     */
    EvaluateUserCustomerLogListResponse getEvaluateUserCustomerLogList(
            EvaluateUserCustomerLogListRequest request);

    /**
     * 保存EvaluateUserCustomerLog
     *
     * @param request EvaluateUserCustomerLog请求
     * @return 保存EvaluateUserCustomerLog响应
     */
    EvaluateUserCustomerLogResponse addEvaluateUserCustomerLog(EvaluateUserCustomerLogRequest request);

    /**
     * 删除EvaluateUserCustomerLog通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除EvaluateUserCustomerLog响应
     */
    EvaluateUserCustomerLogResponse deleteEvaluateUserCustomerLogById(Integer id);

    /**
     * 修改EvaluateUserCustomerLog
     *
     * @param request 修改EvaluateUserCustomerLog请求
     * @return 修改EvaluateUserCustomerLog响应
     */
    EvaluateUserCustomerLogResponse updateEvaluateUserCustomerLog(
            EvaluateUserCustomerLogRequest request);

    /**
     * 通过ID获取EvaluateUserCustomerLog
     *
     * @param id 唯一标识
     * @return 通过ID获取EvaluateUserCustomerLog响应
     */
    EvaluateUserCustomerLogResponse getEvaluateUserCustomerLogById(Integer id);

    EvaluateUserCustomerLogResponse evaluateUser(Integer id, Integer score, String content, String tags);

    EvaluateUserCustomerLogResponse check(Integer id, Integer checkStatus, String userName);
}
