package com.house365.ws.interfaces.server;

import com.house365.ws.beans.request.AttachmentTypeListRequest;
import com.house365.ws.beans.request.AttachmentTypeRequest;
import com.house365.ws.beans.response.AttachmentTypeListResponse;
import com.house365.ws.beans.response.AttachmentTypeResponse;

public interface IAttachmentTypeInterface {

    /**
     * 查询
     *
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     * @param request
     * @return
     * @since
     */
    AttachmentTypeListResponse getAttachmentTypes(AttachmentTypeListRequest request);

    /**
     * 查询单个
     *
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     * @param id
     * @return
     * @since
     */
    AttachmentTypeResponse getAttachmentType(Integer id);

    /**
     * 添加
     *
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     * @param request
     * @return
     * @since
     */
    AttachmentTypeResponse addAttachmentType(AttachmentTypeRequest request);

    /**
     * 修改
     *
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     * @param request
     * @return
     * @since
     */
    AttachmentTypeResponse updateAttachmentType(AttachmentTypeRequest request);

    /**
     * 删除
     * 
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     * @param id
     * @return
     * @since
     */
    AttachmentTypeResponse deleteAttachmentType(Integer id);

    /**
     * 根据文件 后缀 查询 类型
     *
     * @author duhui
     * @version [v1.0.0, 2015-1-18]
     * @param suffix
     * @return
     * @since
     */
    AttachmentTypeListResponse getAttachmentTypesBySuffix(String suffix);

}
