<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<style type="text/css">
    .img-show {
        width: 160px;
        height: 120px;
        border: 1px solid #ccc;
        padding: 2px;
        border-radius: 5px;
        -webkit-border-radius: 5px;
        -moz-border-radius: 5px;
        -ms-border-radius: 5px;
        -o-border-radius: 5px;
    }
</style>
<body>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/user/<c:if test="${action=='edit'}">${entity.id}/</c:if>?search_EQ_deptId=${sessionTreeDept}"
      method="post">
    <%--<input type="hidden" id="limitLogin" name="limitLogin" value="" />--%>
    <!-- 面包屑 begin -->
    <c:if test="${!param['detail']}">
        <div class="row-fluid">
            <div class="span12">

                <ul class="breadcrumb">
                    <li>
                        <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                        <a href="${ctx}/user/?search_EQ_deptId=${sessionTreeDept}">员工列表</a>
                    </li>
                    <li class="active">
                        <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                        <c:choose>
                            <c:when test="${action=='create'}">
                                <span class="inline">新增</span>
                            </c:when>
                            <c:when test="${action=='edit'}">
                                <span class="inline"> ${entity.id} </span>
                            </c:when>
                            <c:otherwise>
                                <span class="inline"> ${entity.id}</span>
                            </c:otherwise>
                        </c:choose>
                    </li>
                </ul>

            </div>
        </div>
    </c:if>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span12">
            <%-- <shiro:hasPermission name="USER_EDIT"> --%>
            <%--<c:if test="${!param['detail']}">--%>
            <div class="portlet-header">
                <div class="operation-btn pull-right">
                    <c:choose>
                        <c:when test="${action=='edit'}">
                            <input type="button" class="btn blue" onclick="revertPassword('${entity.id}')"
                                   value="重置密码"/>

                            <button class="btn blue" type="submit"><i
                                    class="icon-save"></i>&nbsp;保存
                            </button>
                            <a href="${ctx}/user/${entity.id}" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;取消</a>
                        </c:when>
                        <c:when test="${action=='create'}">
                            <button class="btn blue"><i class="icon-save"></i>&nbsp;保存</button>
                            <a href="${ctx}/user/?search_EQ_deptId=${sessionTreeDept}" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:when>
                        <c:otherwise>
                            <a href="${ctx}/user/${entity.id}?action=edit" class="btn blue"><i
                                    class="icon-edit"></i>&nbsp;编辑</a>
                            <a href="${ctx}/user/?search_EQ_deptId=${sessionTreeDept}" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:otherwise>
                    </c:choose>
                </div>
            </div>
            <%--</c:if> --%>
            <%-- </shiro:hasPermission> --%>
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <c:choose>
                            <c:when test="${action=='create'}">
                                <h5>新增</h5>
                            </c:when>
                            <c:when test="${action=='edit'}">
                                <h5>编辑</h5>
                            </c:when>
                            <c:otherwise>
                                <h5>详情</h5>
                            </c:otherwise>
                        </c:choose>
                    </div>
                    <input name="entity.id" type="hidden" value="${entity.id}"/>
                    <div class="row-fluid">
                        <c:choose>
                            <c:when test="${action=='create'}">
                                <div class="span6 control-group">
                                    <label class="control-label">初始密码<span style="color: red;">*</span>:</label>
                                    <div class="controls">
                                        <span class="inline">House365**</span>
                                    </div>
                                </div>
                            </c:when>
                        </c:choose>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">用户名<span style="color: red;">*</span>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.name"
                                               name="entity.name" class="required" maxlength="24"
                                               value="${entity.name}"/>
                                        <span color="red"><form:errors path="userVo.entity.name"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.name}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>

                        <div class="span6 control-group">
                            <label class="control-label">姓名<span style="color: red;">*</span>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.realName"
                                               name="entity.realName" class="required" maxlength="64"
                                               value="${entity.realName}"/>
                                        <span color="red"><form:errors path="userVo.entity.realName"/></span>
                                    </c:when>
                                    <c:otherwise>
                                       <span class="inline">
                                        ${entity.realName}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">手机号<span style="color: red;">*</span>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.mobile"
                                               name="entity.mobile" class="required mobile"
                                               value="${entity.mobile}"/>
                                        <span color="red"><form:errors path="userVo.entity.mobile"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.mobile}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">职位<span style="color: red;">*</span>:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.position"
                                               name="entity.position" class="required" maxlength="100"
                                               value="${entity.position}"/>
                                        <span color="red"><form:errors path="userVo.entity.position"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.position}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">部门:</label>
                            <c:if test="${action =='show'}">
                                <div class="controls">
                                    <span class="inline">${entity.deptName}&nbsp;</span>
                                </div>
                            </c:if>
                            <c:if test="${action =='edit'}">
                                <div class="controls">
                                    <select name="entity.deptId" id="deptId">
                                        <c:forEach items="${departList}" var="dept">
                                            <option value="${dept.id}"
                                                    <c:if test="${dept.id eq currentDept.id}">selected="selected"</c:if>>${dept.name}</option>
                                        </c:forEach>
                                    </select>
                                </div>

                            </c:if>
                        </div>

                        <div class="span6 control-group">
                            <label class="control-label">限制外网登录:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action!='create' and action!='edit'}">
                                        <span class="inline">
                                            <c:if test="${'1' eq entity.limitLogin}">是</c:if>
                                            <c:if test="${'1' ne entity.limitLogin}">否</c:if></span>
                                    </c:when>
                                    <c:otherwise>
                                        <input type="checkbox" id="limitLogin" name="entity.limitLogin" onchange="limitLoginInput()" <c:if test="${'1' eq entity.limitLogin}">checked</c:if> value="${entity.limitLogin}" />
                                        限制外网登录（勾选后在省建大厦外登录PC版需要授权）
                                    </c:otherwise>
                                </c:choose>


                            </div>
                        </div>

                    </div>
                    <div class="row-fluid">
                        <div class="span10 control-group">
                            <label class="control-label"></label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' or action=='edit'}">
                                        <input type="checkbox" name="entity.isFreeMan" <c:if test="${'1' eq entity.isFreeMan}">checked</c:if> value="1"/>取消客户转移限制(即所有人都可以向该用户转移客户)
                                    </c:when>
                                    <c:otherwise>
                                        <%--<span class="inline">${entity.deptName}&nbsp;</span>--%>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <input type="hidden" id="entity.deptId"
                               name="entity.deptId"
                               value="${sessionTreeDept}"/>
                    </div>

                    <div class="row-fluid">
                        <c:choose>
                            <c:when test="${action!='create' && action!='edit'}">
                                <div class="span6 control-group">
                                    <label class="control-label">创建人用户名:</label>
                                    <div class="controls">
                                        <span class="inline">${entity.createUsername}&nbsp;</span>
                                    </div>
                                </div>
                            </c:when>
                        </c:choose>
                        <c:choose>
                            <c:when test="${action!='create' && action!='edit'}">
                                <div class="span6 control-group">
                                    <label class="control-label">创建时间:</label>
                                    <div class="controls">
                                        <span class="inline"><fmt:formatDate type='both' value='${entity.createTime}'
                                                                             pattern='yyyy-MM-dd HH:mm:ss'/>&nbsp;</span>
                                    </div>
                                </div>
                            </c:when>
                        </c:choose>
                    </div>
                    <div class="row-fluid">
                        <c:choose>
                            <c:when test="${action!='create' && action!='edit'}">
                                <div class="span6 control-group">
                                    <label class="control-label">最后一次修改人用户名:</label>
                                    <div class="controls">
                                        <span class="inline">${entity.updateUsername}&nbsp;</span>
                                    </div>
                                </div>
                            </c:when>
                        </c:choose>
                        <c:choose>
                            <c:when test="${action!='create' && action!='edit'}">
                                <div class="span6 control-group">
                                    <label class="control-label">最后一次修改时间:</label>
                                    <div class="controls">
                                        <span class="inline"><fmt:formatDate type='both' value='${entity.updateTime }'
                                                                             pattern='yyyy-MM-dd HH:mm:ss'/>&nbsp;</span>
                                    </div>
                                </div>
                            </c:when>
                        </c:choose>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<c:if test="${action!='create'}">
    <div class="form-horizontal house365Page">
        <div class="house365Border">
            <!-- 片段头 begin -->
            <div class="sectionTitle">
                <h5>个人资料</h5>
            </div>
            <div class="row-fluid">
                <div class="span6 control-group">
                    <label class="control-label">400号码<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <span class="inline">&nbsp;4008908365&nbsp;${entity.hotlinephone}</span>
                    </div>
                </div>
                <div class="span6 control-group">
                    <label class="control-label">回拨短号<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <span class="inline">${entity.cornet}&nbsp;</span>
                    </div>
                </div>
            </div>

            <div class="row-fluid">
                <div class="span6 control-group">
                    <label class="control-label">微信号<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <span class="inline">${entity.wxNumber}&nbsp;</span>
                    </div>
                </div>
                <div class="span6 control-group">
                    <label class="control-label">初始带看次数<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <span class="inline">${entity.defaultVisit}&nbsp;</span>
                    </div>
                </div>
            </div>

            <div class="row-fluid">
                <div class="span6 control-group">
                    <label class="control-label">业务专长<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <span class="inline">${entity.goodat}&nbsp;</span>
                    </div>
                </div>
                <div class="span6 control-group">
                    <label class="control-label">个人介绍<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <span class="inline">${entity.description}&nbsp;</span>
                    </div>
                </div>
            </div>

            <div class="row-fluid">
                <div class="span6 control-group">
                    <label class="control-label">个人头像<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <%--<span class="inline">${entity.headImgURL}&nbsp;</span>--%>
                        <%--<tags:imageSection resourceId="${entity.id}"--%>
                                           <%--resourceType="hgs_user_headImg"--%>
                                           <%--bizType="1" editAble="true" title="个人头像" maxSize="1"/>--%>
                        <img class="img-show" src="${entity.headImgURL}" style="width: 10%" />
                    </div>
                </div>
                <div class="span6 control-group">
                    <label class="control-label">全身照<span style="color: red;">*</span>:</label>
                    <div class="controls">
                        <%--<tags:imageSection resourceId="${entity.id}"--%>
                                           <%--resourceType="hgs_user_fullImg"--%>
                                           <%--bizType="2" editAble="true" title="全身照" maxSize="1"/>--%>
                        <%--<span color="red"><form:errors path="entity.fullImgURL"/></span>--%>
                        <img class="img-show" src="${entity.fullImgURL}" style="width: 40%" />
                    </div>
                </div>
            </div>
        </div>
    </div>
</c:if>


<c:if test="${action!='create'}">
    <div class="row${fluid}">
        <div class="row-fluid">
            <div class="span12">
                <div class="portlet box grey">
                    <div class="portlet-title">
                        <h4> 权限组列表 </h4>
                        <c:if test="${action=='edit'}">
                            <div class="tools">
                                <a href="${ctx}/user/authorize/${entity.id}">分配权限组</a>
                                <a class="collapse" href="javascript:;"></a>
                            </div>
                        </c:if>
                    </div>
                    <div id="permission_list_container" class="portlet-body lazy-section"
                         base-url="${ctx}/role/roleListSection/${entity.id}"></div>
                </div>
            </div>
        </div>
    </div>
</c:if>
<script>
    function revertPassword(userId) {
        House365Util.createModal("重置密码", "确认重置密码？", function () {
            $.ajax({
                url: '${ctx}/user/revertPassword',
                type: "GET",
                data: {
                    userId: userId
                },
                success: function () {
                    alert("重置成功");
                }
            });
        });
    }

    function limitLoginInput() {
        var checked = $('[name="entity.limitLogin"]:checked').length;
        if (checked > 0) {
            $("#limitLogin").val("1");
        }else{
            $("#limitLogin").val("0");
        }
    }
</script>
</body>
</html>
