<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>成交状态抽查报表</title>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>统计与分析
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>成交状态抽查报表
            </li>
        </ul>
    </div>
</div>

<div class="page-container">
    <div class="row${fluid}">
        <form id="filterForm" name="filterForm" class="form-inline filterForm"
              action="${ctx}/statistic/transactionStatusReport" method="get">

            <div style="margin-top:10px;">
                客户姓名：<input type="text" id="search_name" style="border: 1px solid #d5d5d5;" name="search_name"
                            value="${param['search_name']}"
                            class="m-wrap small" placeholder="客户姓名">&nbsp;&nbsp;&nbsp;&nbsp;
                客户手机：<input type="text" id="search_phone" style="border: 1px solid #d5d5d5;"
                            name="search_phone" value="${param['search_phone']}"
                            class="m-wrap small" placeholder="客户手机">&nbsp;&nbsp;&nbsp;&nbsp;
                项目名称：<input type="text" id="search_projectName" style="border: 1px solid #d5d5d5;"
                            name="search_projectName" value="${param['search_projectName']}"
                            class="m-wrap small" placeholder="项目名称">&nbsp;&nbsp;&nbsp;&nbsp;
                <select style="width: 6rem" name="search_dateType" id="search_dateType">
                    <option value="1"
                            <c:if test="${'1' eq param['search_dateType']}">selected="selected"</c:if>>
                        约看时间
                    </option>
                    <option value="2"
                            <c:if test="${'2' eq param['search_dateType']}">selected="selected"</c:if>>
                        到访时间
                    </option>
                    <option value="3"
                            <c:if test="${'3' eq param['search_dateType']}">selected="selected"</c:if>>
                        认筹时间
                    </option>
                    <option value="4"
                            <c:if test="${'4' eq param['search_dateType']}">selected="selected"</c:if>>
                        认购时间
                    </option>
                    <option value="5"
                            <c:if test="${'5' eq param['search_dateType']}">selected="selected"</c:if>>
                        签约时间
                    </option>
                    <option value="6"
                            <c:if test="${'6' eq param['search_dateType']}">selected="selected"</c:if>>
                        退房时间
                    </option>
                </select>
                <input type="text" name="startTime" id="startTime" class="m-wrap small mydate span2" autocomplete="off"
                       placeholder="起始时间">到
                <input type="text" name="endTime" id="endTime" class="m-wrap small mydate span2" autocomplete="off"
                       placeholder="截止时间">&nbsp;&nbsp;
                状态匹配：
                <select style="width: 6rem" name="search_isMatch" id="search_isMatch">
                    <option value="0"
                            <c:if test="${'0' eq param['search_isMatch']}">selected="selected"</c:if>>
                        全部
                    </option>
                    <option value="1"
                            <c:if test="${'1' eq param['search_isMatch']}">selected="selected"</c:if>>
                        不匹配
                    </option>
                    <option value="2"
                            <c:if test="${'2' eq param['search_isMatch']}">selected="selected"</c:if>>
                        匹配
                    </option>
                </select>
                <a class="btn" onclick="btnSubmit();">搜索</a>
            </div>
        </form>

        <table class="table table-bordered table-advance table-hover">
            <tr class="info">
                <td width="100" style="text-align:center">序号</td>
                <td width="100" style="text-align:center">项目名称</td>
                <td width="100" style="text-align:center">合同编号</td>
                <td width="100" style="text-align:center">客户姓名</td>
                <td width="100" style="text-align:center">客户手机</td>
                <td width="100" style="text-align:center">置业顾问</td>

                <td width="100" style="text-align:center">全链条当前状态</td>
                <td width="100" style="text-align:center">经管最新状态</td>
                <td width="100" style="text-align:center">约看时间</td>
                <td width="100" style="text-align:center">到访时间</td>
                <td width="100" style="text-align:center">认筹时间</td>

                <td width="100" style="text-align:center">认购时间</td>
                <td width="100" style="text-align:center">签约时间</td>
                <td width="100" style="text-align:center">退房时间</td>
                <td width="100" style="text-align:center">驻场人员</td>
                <td width="100" style="text-align:center">操作</td>
            </tr>
            <c:if test="${not empty dataList}">
                <c:forEach items="${dataList}" var="item" varStatus="i">
                    <tr>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${i.index+1}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.projectName}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.contract}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.name}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.phone}
                        </td>

                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.managerName}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                            <c:if test="${ item.jgStatus eq item.status}">
                                <c:if test="${ '1' eq item.status}">
                                    约看
                                </c:if>
                                <c:if test="${ '2' eq item.status}">
                                    到访
                                </c:if>
                                <c:if test="${ '3' eq item.status}">
                                    认筹
                                </c:if>
                                <c:if test="${ '4' eq item.status}">
                                    认购
                                </c:if>
                                <c:if test="${ '5' eq item.status}">
                                    签约
                                </c:if>
                                <c:if test="${ '6' eq item.status}">
                                    退房
                                </c:if>
                            </c:if>
                            <c:if test="${ item.jgStatus ne item.status}">
                                <span style="color: red">
                                    <c:if test="${ '1' eq item.status}">
                                        约看
                                    </c:if>
                                    <c:if test="${ '2' eq item.status}">
                                        到访
                                    </c:if>
                                    <c:if test="${ '3' eq item.status}">
                                        认筹
                                    </c:if>
                                    <c:if test="${ '4' eq item.status}">
                                        认购
                                    </c:if>
                                    <c:if test="${ '5' eq item.status}">
                                        签约
                                    </c:if>
                                    <c:if test="${ '6' eq item.status}">
                                        退房
                                    </c:if>
                                </span>
                            </c:if>
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                            <c:if test="${ '3' eq item.jgStatus}">
                                认筹
                            </c:if>
                            <c:if test="${ '4' eq item.jgStatus}">
                                认购
                            </c:if>
                            <c:if test="${ '5' eq item.jgStatus}">
                                签约
                            </c:if>
                            <c:if test="${ '6' eq item.jgStatus}">
                                退房
                            </c:if>
                            <c:if test="${ '0' eq item.jgStatus}">
                                无匹配
                            </c:if>
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                            <c:if test="${null ne item.status1 && '' ne item.status1}">
                                <f:formatDate value='${item.status1}'
                                              pattern='yyyy-MM-dd HH:mm:ss'/>
                            </c:if>
                            <c:if test="${null eq item.status1 || '' eq item.status1}">
                                -
                            </c:if>
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                            <c:if test="${null ne item.status2 && '' ne item.status2}">
                                <f:formatDate value='${item.status2}'
                                              pattern='yyyy-MM-dd HH:mm:ss'/>
                            </c:if>
                            <c:if test="${null eq item.status2 || '' eq item.status2}">
                                -
                            </c:if>
                        </td>

                        <td nowrap="nowrap" style="text-align:center;">
                            <c:if test="${null ne item.status3 && '' ne item.status3}">
                                <f:formatDate value='${item.status3}'
                                              pattern='yyyy-MM-dd HH:mm:ss'/>
                            </c:if>
                            <c:if test="${null eq item.status3 || '' eq item.status3}">
                                -
                            </c:if>
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                            <c:if test="${null ne item.status4 && '' ne item.status4}">
                                <f:formatDate value='${item.status4}'
                                              pattern='yyyy-MM-dd HH:mm:ss'/>
                            </c:if>
                            <c:if test="${null eq item.status4 || '' eq item.status4}">
                                -
                            </c:if>
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                            <c:if test="${null ne item.status5 && '' ne item.status5}">
                                <f:formatDate value='${item.status5}'
                                              pattern='yyyy-MM-dd HH:mm:ss'/>
                            </c:if>
                            <c:if test="${null eq item.status5 || '' eq item.status5}">
                                -
                            </c:if>
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                            <c:if test="${null ne item.status6 && '' ne item.status6}">
                                <f:formatDate value='${item.status6}'
                                              pattern='yyyy-MM-dd HH:mm:ss'/>
                            </c:if>
                            <c:if test="${null eq item.status6 || '' eq item.status6}">
                                -
                            </c:if>
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.residentUserName}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                <%--<button onclick="geDetail(${item.cpId})">详情</button>--%>
                            <button type="button" class="btn btn-default"
                                    onclick="geDetail(${item.cpId},${item.id},${item.isRepeat})">详情
                            </button>
                        </td>
                    </tr>
                </c:forEach>
            </c:if>
            <c:if test="${ empty dataList}">
                <tr>
                    <td colspan="15" style="text-align: center">暂未找到与条件相关的数据，请重新搜索</td>
                </tr>
            </c:if>

        </table>
        <div class="row${fluid}">
            <house365:pagination page="${page}"/>
        </div>
    </div>

</div>


<link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-multiselect.css" type="text/css">
<script type="text/javascript" src="${static_common }/script/bootstrap/js/bootstrap-multiselect.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>

<script type="text/javascript">

    function btnSubmit() {
        $('#filterForm').submit();
    }

    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    });

    $(document).ready(function () {
        var timeStart = "${startTime}";
        var timeEnd = "${endTime}";
        if (timeEnd == '' && timeStart == '') {
            $(".mydate").unbind("focus");
            $(".mydate").bind("focus", function () {
                WdatePicker({dateFmt: 'yyyy-MM-dd', autoPickDate: false, maxDate: '%y-%M-{%d}'});
            });
        } else {
            $("#startTime").val(timeStart);
            $("#endTime").val(timeEnd);
        }
    });

    function geDetail(cpId, id, isRepeat) {
        if (isRepeat == 1) {
            alert("该客户为重客，无法维护");
            return;
        }
        $.ajax({
            url: '${ctx}/customer/judgePrivate/' + id,
            type: "POST",
            success: function (data) {
                if (data.status == 0) {
                    window.open("/house365-hgs-web/customer/updateProjectInfo/" + cpId, "_blank");
                } else {
                    alert(data.errorMessage);
                }
            }
        });
    }

</script>
</body>
</html>
