<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>项目来源分析</title>
</head>
<body>

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" name="filterForm" class="form-inline filterForm"
                  action="${ctx}/statistic/projectSource" method="get">
                <select name="status" id="status" data-placeholder="客户状态">
                    <option value="">全部</option>
                    <option value="1" <c:if test="${'1' eq param['status']}">selected="selected"</c:if>>约看</option>
                    <option value="2" <c:if test="${'2' eq param['status']}">selected="selected"</c:if>>到访</option>
                    <option value="3" <c:if test="${'3' eq param['status']}">selected="selected"</c:if>>认筹</option>
                    <option value="4" <c:if test="${'4' eq param['status']}">selected="selected"</c:if>>认购</option>
                    <option value="5" <c:if test="${'5' eq param['status']}">selected="selected"</c:if>>签约</option>
                    <option value="6" <c:if test="${'6' eq param['status']}">selected="selected"</c:if>>退房</option>
                </select>

                <select name="dateViewType" id="dateViewType" class="form-inline chosen">
                    <option value="1" <c:if test="${param['dateViewType']==1}">selected="selected"</c:if>>日视图</option>
                    <option value="2" <c:if test="${param['dateViewType']==2}">selected="selected"</c:if>>周视图</option>
                    <option value="3" <c:if test="${param['dateViewType']==3}">selected="selected"</c:if>>月视图</option>
                </select>
                <input type="text" name="startTime" id="startTime"
                       value="${startDate}"
                       class="m-wrap small mydate span2 " placeholder="添加时间">到
                <input type="text" name="endTime" id="endTime"
                       value="${endDate}"
                       class="m-wrap small mydate span2 " placeholder="添加时间">

                <select name="project" id="project" class="span10 nochosen  multiselect" multiple="multiple"
                        data-placeholder="请输入项目名">
                    <c:forEach items="${projects}" var="p">
                        <option value="${p.id}"
                                <c:if test="${p.flag}">selected="selected"</c:if> >${p.projectName}</option>
                    </c:forEach>
                </select>
                <input type="hidden" id="projectIds" name="projectIds" value="${projectIds}"/>
                <input type="hidden" id="projectNames" name="projectNames" value="${projectNames}"/>


                <div class="buttons pull-right" style="margin-left:15px;">
                    <a class="btn " onclick="btnSubmit();">项目来源分析</a>
                    <a class="btn " onclick="exportExcel();">下载</a>
                </div>
            </form>
        </div>
        <ul class="nav nav-tabs" role="tablist">
            <li id="reportLi" role="presentation" class="active"><a href="#" onclick="dispayFun(1)">条形图展示</a></li>
            <li id="tableLi" role="presentation"><a href="#" onclick="dispayFun(2)">表格详情</a></li>
        </ul>

        <div class="span12" id="report" style="max-height:1200px;height:${hight}px;min-height:300px;">
            <!-- <div hidden="hidden" id="emptyMsg">
                 <span>请选择查询条件</span>
             </div> -->
            <!--  <div id="emptyMsg" class="alert alert-success span2" role="alert">请选择查询条件</div> -->
        </div>
        <div class="span12" id="table" style="display:none;">
            <table class="table table-bordered table-advance table-hover">
                <tr class="info">
                    <td width="100" style="text-align:center">城市</td>
                    <td width="100" style="text-align:center">客户状态</td>
                    <td width="100" style="text-align:center">项目</td>
                    <td width="100" style="text-align:center">来源</td>
                    <td width="100" style="text-align:center">日期</td>
                    <td width="100" style="text-align:center">客户数量</td>
                    <td width="100" style="text-align:center">环比</td>
                </tr>
                <c:forEach items="${tableData}" var="item">
                    <tr>
                        <td nowrap="nowrap" style="text-align:center;"><c:out
                                value="${sessionCurrDept.name}"></c:out></td>
                        <td nowrap="nowrap" style="text-align:center"><c:out value="${item.statusMsg}"></c:out></td>
                        <td nowrap="nowrap" style="text-align:center"><c:out value="${item.projectName}"></c:out></td>
                        <td nowrap="nowrap" style="text-align:center"><c:out value="${item.sourceName}"></c:out></td>
                        <td nowrap="nowrap" style="text-align:center">${item.time}</td>
                        <td nowrap="nowrap" style="text-align:center"><c:out value="${item.count}"></c:out></td>
                        <td nowrap="nowrap" style="text-align:center"><c:out value="${item.dayBaseRatio}"></c:out></td>
                    </tr>
                </c:forEach>
            </table>
        </div>
    </div>

</div>

<link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-multiselect.css" type="text/css">
<script type="text/javascript" src="${static_common }/script/bootstrap/js/bootstrap-multiselect.js"></script>
<script src="${ctx}/resources/script/echarts/echarts.min.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>
<script type="text/javascript">
    $(document).ready(function () {

        $('#project').multiselect({
            includeSelectAllOption: true,
            enableFiltering: true,
            maxHeight: 500,
            buttonWidth: 320,
            numberDisplayed: 2,
            filterPlaceholder: '请输入项目名',
            includeSelectAllOption: false,
            templates: {
                filterClearBtn: '<span></span>',
            },
            buttonText: function (options) {
                if (options.length == 0) {
                    return '未选择项目 ';
                } else if (options.length > 2) {
                    return '已选' + options.length + '个 ';
                } else {
                    var selected = '';
                    options.each(function () {
                        selected += $(this).text() + ', ';
                    });
                    return selected.substr(0, selected.length - 2);
                }
            },
            /*  label: function(element) {
             return "<label style='margin-top:7px;'>"+$(element).html()+"</label>";
             }, */
            optionLabel: function (element) {
                return $(element).html();
            },
            /*  optionClass: function(element) {
             return "aa";
             }, */
            onInitialized: function (select, container) {
                var selectedOptions = $('#project option:selected');

                if (selectedOptions.length >= 5) {
                    var nonSelectedOptions = $('#project option').filter(function () {
                        return !$(this).is(':selected');
                    });

                    var dropdown = $('#project').siblings('.multiselect-container');
                    nonSelectedOptions.each(function () {
                        var input = $('input[value="' + $(this).val() + '"]');
                        input.prop('disabled', true);
                        input.parent('li').addClass('disabled');
                    });
                }
                else {
                    var dropdown = $('#project').siblings('.multiselect-container');
                    $('#project option').each(function () {
                        var input = $('input[value="' + $(this).val() + '"]');
                        input.prop('disabled', false);
                        input.parent('li').addClass('disabled');
                    });
                }
            },
            onChange: function (option, checked) {
                var selectedOptions = $('#project option:selected');

                if (selectedOptions.length >= 5) {
                    var nonSelectedOptions = $('#project option').filter(function () {
                        return !$(this).is(':selected');
                    });

                    var dropdown = $('#project').siblings('.multiselect-container');
                    nonSelectedOptions.each(function () {
                        var input = $('input[value="' + $(this).val() + '"]');
                        input.prop('disabled', true);
                        input.parent('li').addClass('disabled');
                    });
                }
                else {
                    var dropdown = $('#project').siblings('.multiselect-container');
                    $('#project option').each(function () {
                        var input = $('input[value="' + $(this).val() + '"]');
                        input.prop('disabled', false);
                        input.parent('li').addClass('disabled');
                    });
                }
            }
        });


        var startTime = $("#startTime");
        var endTime = $("#endTime");
        endTime.bind("focus", function () {
            WdatePicker({
                startDate: "%y-{%M}-%d",
                dateFmt: "yyyy-MM-dd",
                autoPickDate: false,
                maxDate: '%y-%M-{%d-1}',
                firstDayOfWeek: 1
            });
        });
        startTime.bind("focus", function () {
            WdatePicker({
                startDate: "%y-{%M}-%d",
                dateFmt: "yyyy-MM-dd",
                autoPickDate: false,
                maxDate: '%y-%M-{%d-1}',
                firstDayOfWeek: 1,
                onpicked: function () {
                    WdatePicker({
                        /* doubleCalendar: true, */
                        startDate: "%y-{%M-1}-%d",
                        dateFmt: "yyyy-MM-dd",
                        firstDayOfWeek: 1,
                        autoPickDate: true,
                        maxDate: '%y-%M-{%d-1}',
                        el: 'endTime'
                    })
                }
            });
        });

        $("#dateViewType").change(function () {
            var val = $(this).val();
            $(".mydate").val("");
            if (val == 1) {
                $(".mydate").unbind("focus");
                $(".mydate").bind("focus", function () {
                    WdatePicker({dateFmt: 'yyyy-MM-dd', maxDate: '%y-%M-{%d-1}', firstDayOfWeek: 1});
                });
            } else if (val == 2) {
                $(".mydate").unbind("focus");
                $(".mydate").bind("focus", function () {
                    WdatePicker({isShowWeek: true, maxDate: '%y-%M-{%d-1}', firstDayOfWeek: 1});
                });
            } else {
                $(".mydate").unbind("focus");
                $(".mydate").bind("focus", function () {
                    WdatePicker({dateFmt: 'yyyy-MM', maxDate: '%y-%M-{%d-1}', firstDayOfWeek: 1});
                });
            }

            setTime();
        });
        drawReport();

        setTime();
    })

    function drawReport() {
        var myChart = echarts.init(document.getElementById('report'));
        var option = {
            title: {
                text: ''
            },
            tooltip: {
                trigger: 'axis',
                axisPointer: {
                    type: 'shadow'
                }
            },
            legend: {
                data: ${sourceList},
                itemHeight: 14,
                textStyle: {
                    fontSize: 12
                }
            },
            xAxis: {
                type: 'value'
            },
            yAxis: {
                type: 'category',
                data:  ${projectList}
            },
            grid: {
                left: '3%',
                right: '4%',
                top: '120px',
                bottom: '3%',
                containLabel: true
            },
            series: ${viewList}
        };
        myChart.setOption(option);

        window.onresize = function () {
            myChart.resize();
        }

    }
    function exportExcel() {
        document.filterForm.action = "${ctx}/statistic/projectSourceExcel";
        filterForm.submit();
        document.filterForm.action = "${ctx}/statistic/projectSource";
    }

    function btnSubmit() {
        var tmp = ",";
        var tmpName = ",";
        $("#project").find("option:selected").each(function () {
            tmp = tmp + $(this).val() + ",";
            tmpName = tmpName + $(this).text() + ",";
        });
        if (tmp == ",") {
            House365Util.createModal("未选择项目", "请选择项目", function () {
            });
            return;
        }

        $("#projectIds").val(tmp);
        $("#projectNames").val(tmpName);
        $('#filterForm').submit();
    }

    function dispayFun(obj) {
        if (obj == 1) {
            $("#report").show();
            $("#table").hide();
            $("#reportLi").addClass("active");
            $("#tableLi").removeClass("active");
        } else {
            $("#table").show();
            $("#report").hide();
            $("#tableLi").addClass("active");
            $("#reportLi").removeClass("active");
        }
    }
    function exportExcel() {
        document.filterForm.action = "${ctx}/statistic/projectSourceExcel";
        document.filterForm.submit();
        document.filterForm.action = "${ctx}/statistic/projectSource";
    }
</script>
</body>
</html>
