<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <c:if test="${not empty managerName}">
        <title>${managerName}的客户</title>
    </c:if>
    <c:if test="${empty managerName}">
        <title>我的客户</title>
    </c:if>
</head>
<body>
<link rel="stylesheet" href="${static_common}/jquery.qtip.custom/jquery.qtip.min.css" type="text/css">
<link rel="stylesheet" type="text/css" href="${static_common}/jquery-ui/jquery-ui.min.css"/>
<link rel="stylesheet" type="text/css" href="${static_common}/label/tag.css"/>

<style>
    .container-fluid {
        min-width: 1440px;
    }

    .dataTables_info {
        position: absolute;
        right: 753px;
        top: 77px;
    }

    .inputSearch {
        margin-right: 20px;
    }

    .table-complex {
        background-color: #f9f9f9;
    }

    .table-star {
        background-color: #FFEB3B;
    }

    .lastChoseCustomer {
        background-color: #91bfbf;
    }

    .numbers {
        font-size: 14px;
        color: #AAB5BC;
        font-weight: 600;
        text-transform: uppercase;
    }

    .font-blue-sharp {
        color: #5C9BD1 !important;
    }

    .dashboard-stat2 {
        -webkit-border-radius: 2px;
        -moz-border-radius: 2px;
        -ms-border-radius: 2px;
        -o-border-radius: 2px;
        border-radius: 2px;
        background: #eff3f8;
        padding: 15px 15px 30px;
        margin-bottom: 20px;
    }

    .dashboard-stat2 .display .number {
        float: left;
        display: inline-block;
    }

    .dashboard-stat2 .display .number small {
        font-size: 14px;
        color: #AAB5BC;
        font-weight: 600;
        text-transform: uppercase;
    }

    .dashboard-stat2 .display .number h5 {
        margin: 0 0 2px;
        padding: 0;
        font-size: 20px;
        font-weight: 400;
    }

    .dashboard-stat2, .dashboard-stat2 .display {
        margin-bottom: 20px;
    }

    .dashboard-stat2 .display .icon {
        display: inline-block;
        float: right;
        padding: 0;
    }

    .dashboard-stat2 .display .icon > i {
        color: #cbd4e0;
        font-size: 26px;
    }

    input[type='text'] {
        margin-right: 15px;
    }

    .num3 {
        background: green;
        color: #fff;
        padding: 1px 6px;
        border-radius: 10px;
    }

    .tag-item {
        color: white;
    }

    #labelModel, #myModal {
        display: none;
    }

    .temp {
        border: 1px solid #cccccc;
        width: 430px !important;
        height: 160px !important;
        position: relative;
        top: -26px;
        left: 81px;
    }

    .bt {
        padding: 0 10px;
        background-color: white;
        border-radius: 5px;
        outline: 0;
        border-color: transparent;
        box-shadow: none;
        margin: 0 5px;
        display: inline-block;
        height: 30px;
        line-height: 30px;
    }

    .bat {
        padding: 0 10px;
        background-color: white;
        border-radius: 5px;
        outline: 0;
        border-color: transparent;
        box-shadow: none;
        margin: 0 5px;
        display: inline-block;
        height: 30px;
        line-height: 30px;
    }

    .bat2 {
        padding: 0 10px;
        background-color: white;
        border-radius: 5px;
        outline: 0;
        border-color: transparent;
        box-shadow: none;
        margin: 0 5px;
        display: inline-block;
        height: 30px;
        line-height: 30px;
    }

    .color_999 {
        border: 1px solid #999;
        color: #999;
    }

    .color_d9534f {
        border: 1px solid #d9534f;
        color: #d9534f;
    }

    .color_f0ad4e {
        border: 1px solid #f0ad4e;
        color: #f0ad4e;
    }

    .color_5cb85c {
        border: 1px solid #5cb85c;
        color: #5cb85c;
    }

    .color_5bc0de {
        border: 1px solid #5bc0de;
        color: #5bc0de;
    }

    .color_0275d8 {
        border: 1px solid #0275d8;
        color: #0275d8;
    }

    .color_663399 {
        border: 1px solid #663399;
        color: #663399;
    }

    .bt_last {
        background-color: #f0f0f0 !important;
        border: none !important;
        background-image: none !important;
    }

    .chosen-container {
        margin-left: 7px !important;
        width: 96px !important;
    }

    .shouc {
        position: absolute;
        right: 12px;
    }

    /*.table td.mangerItem.mangerOperate {*/
        /*width: 650px;*/
    /*}*/
    .table td.mangerItem.mangerlist {
        overflow: hidden;
        padding: 0;
        width: 33%;
    }
    .pace {
        display: inline-block;
        -webkit-pointer-events: none;
        pointer-events: none;

        -webkit-user-select: none;
        -moz-user-select: none;
        user-select: none;

        -webkit-box-sizing: border-box;
        -moz-box-sizing: border-box;
        -ms-box-sizing: border-box;
        -o-box-sizing: border-box;
        box-sizing: border-box;

        -webkit-border-radius: 10px;
        -moz-border-radius: 10px;
        border-radius: 10px;

        -webkit-background-clip: padding-box;
        -moz-background-clip: padding;
        background-clip: padding-box;

        z-index: 2000;
        position: fixed;
        margin: auto;
        top: 12px;
        left: 0;
        right: 0;
        bottom: 0;
        width: 200px;
        height: 50px;
        overflow: hidden;
    }
</style>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                <c:if test="${not empty managerName}">
                    ${managerName}的客户
                </c:if>
                <c:if test="${empty managerName}">
                    我的客户
                </c:if>
            </li>
            <li style="float: right;margin-top: -5px;">
                <button type="button" class="btn btn-default"
                        onclick="window.open('${ctx}/customer/newCustomer','_blank')">添加客户
                </button>
            </li>
        </ul>
    </div>
    <input type="hidden" id="markIds" name="markIds" value=""/>
</div>

<form id="filterForm" class="form-inline filterForm" action="${ctx}/customermanagement/myCustomerNew" method="get"
      style="margin: 11px 0 6px 0;">
    <div class="row-fluid"
         style="border-style: solid;border-width: thin;border-color: #d5d5d5;padding: 20px;margin-bottom: 20px;line-height: 43px;">
        <div class="span12">
            <c:if test="${'waitCall' eq param['type']}">
                派工时间： <input style="width: 7rem;border: 1px solid #d5d5d5;" type="text" name="search_GTE_bindTimeStart"
                             id="search_GTE_bindTimeStart" value="${param['search_GTE_bindTimeStart']}"
                             class="m-wrap small span2"
            >至
                <input style="width: 7rem;margin-left: 15px;border: 1px solid #d5d5d5;" type="text"
                       name="search_LTE_bindTimeEnd"
                       id="search_LTE_bindTimeEnd" value="${param['search_LTE_bindTimeEnd']}"
                       class="m-wrap small span2"
                >
                <span id="bindTimeAll" style="cursor: pointer;<c:if test="${'0' eq timePeriod}">color: #30A3DE;</c:if>"
                      onclick="bindTimeClick('0')">全部</span>&nbsp;&nbsp;
                <span id="bindTimeRecentSeven"
                      style="cursor: pointer;<c:if test="${'1' eq timePeriod }">color: #30A3DE;</c:if>"
                      onclick="bindTimeClick('1')">近7天</span>&nbsp;&nbsp;
                <span id="bindTimeRecentThirty"
                      style="cursor: pointer;<c:if test="${'2' eq timePeriod }">color: #30A3DE;</c:if>"
                      onclick="bindTimeClick('2')">30天</span>&nbsp;&nbsp;&nbsp;&nbsp;
                报名时间： <input style="width: 7rem;border: 1px solid #d5d5d5;" type="text"
                             name="search_GTE_singupTimeStart"
                             id="search_GTE_singupTimeStart" value="${param['search_GTE_singupTimeStart']}"
                             class="m-wrap small span2"
            >至
                <input style="width: 7rem;margin-left: 15px;border: 1px solid #d5d5d5;" type="text"
                       name="search_LTE_singupTimeEnd"
                       id="search_LTE_singupTimeEnd" value="${param['search_LTE_singupTimeEnd']}"
                       class="m-wrap small span2"
                >
                <br/>
                客户姓名：<input type="text" id="search_LIKE_name" style="border: 1px solid #d5d5d5;" name="search_LIKE_name" value="${param['search_LIKE_name']}"
                class="m-wrap small" placeholder="客户姓名">&nbsp;&nbsp;&nbsp;&nbsp;
                客户手机：<input type="text" id="search_LIKE_phone" style="border: 1px solid #d5d5d5;" name="search_LIKE_phone" value="${param['search_LIKE_phone']}"
                class="m-wrap small" placeholder="客户手机">&nbsp;&nbsp;&nbsp;&nbsp;
                报名项目：<input type="text" id="search_LIKE_bakPhone1" style="border: 1px solid #d5d5d5;" name="search_LIKE_bakPhone1" value="${param['search_LIKE_bakPhone1']}"
                class="m-wrap small" placeholder="报名项目">&nbsp;&nbsp;&nbsp;&nbsp;
                报名来源：<input type="text" id="search_LIKE_latestSource" style="border: 1px solid #d5d5d5;" name="search_LIKE_latestSource" value="${param['search_LIKE_latestSource']}"
                class="m-wrap small" placeholder="报名来源">
                <br/>
                活动名称：<input type="text" id="search_LIKE_actSource" style="border: 1px solid #d5d5d5;" name="search_LIKE_actSource" value="${param['search_LIKE_actSource']}"
                class="m-wrap small" placeholder="活动名称">&nbsp;&nbsp;&nbsp;&nbsp;
                置业顾问：<input type="text" id="search_LIKE_managerName" style="border: 1px solid #d5d5d5;" name="search_LIKE_managerName" value="${param['search_LIKE_managerName']}"
                class="m-wrap small" placeholder="置业顾问">&nbsp;&nbsp;&nbsp;&nbsp;
                营销活动：<select name="search_EQ_activeId" id="search_EQ_activeId" style="width: 10rem">
                <option value="">全部营销活动</option>
                <c:forEach items="${actList}" var="act">
                    <option value="${act.id}"
                            <c:if test="${act.id eq param['search_EQ_activeId']}">selected="selected"</c:if>>${act.name}</option>
                </c:forEach>
                </select>
            </c:if>
            <c:if test="${'waitCall' ne param['type']}">
                添加时间： <input style="width: 7rem;border: 1px solid #d5d5d5;" type="text"
                             name="search_GTE_createTimeStart"
                             id="search_GTE_createTimeStart" value="${param['search_GTE_createTimeStart']}"
                             class="m-wrap small span2"
            >至
                <input style="width: 7rem;margin-left: 15px;border: 1px solid #d5d5d5;" type="text"
                       name="search_LTE_createTimeEnd"
                       id="search_LTE_createTimeEnd" value="${param['search_LTE_createTimeEnd']}"
                       class="m-wrap small span2"
                >
                <%--<span id="createTimeRecentSeven"--%>
                <%--style="cursor: pointer;<c:if test="${'0' eq timePeriod}">color: #30A3DE;</c:if>"--%>
                <%--onclick="createTimeClick('0')">近7天</span>&nbsp;&nbsp;--%>
                <%--<span id="createTimeRecentThirty"--%>
                <%--style="cursor: pointer;<c:if test="${'1' eq timePeriod}">color: #30A3DE;</c:if>"--%>
                <%--onclick="createTimeClick('1')">30天</span>&nbsp;&nbsp;--%>
                <%--<span id="createTimeAll"--%>
                <%--style="cursor: pointer;<c:if test="${'2' eq timePeriod}">color: #30A3DE;</c:if>"--%>
                <%--onclick="createTimeClick('2')">全部</span>&nbsp;&nbsp;--%>

                <span id="createTimeRecentSeven"
                      style="cursor: pointer;<c:if test="${'2' eq timePeriod}">color: #30A3DE;</c:if>"
                      onclick="createTimeClick('2')">近7天</span>&nbsp;&nbsp;
                <span id="createTimeRecentThirty"
                      style="cursor: pointer;<c:if test="${'1' eq timePeriod}">color: #30A3DE;</c:if>"
                      onclick="createTimeClick('1')">30天</span>&nbsp;&nbsp;
                <span id="createTimeAll"
                      style="cursor: pointer;<c:if test="${'0' eq timePeriod}">color: #30A3DE;</c:if>"
                      onclick="createTimeClick('0')">全部</span>&nbsp;&nbsp;
                &nbsp;&nbsp;
                派工时间： <input style="width: 7rem;border: 1px solid #d5d5d5;" type="text" name="search_GTE_bindTimeStart"
                             id="search_GTE_bindTimeStart" value="${param['search_GTE_bindTimeStart']}"
                             class="m-wrap small span2"
            >至
                <input style="width: 7rem;margin-left: 15px;border: 1px solid #d5d5d5;" type="text"
                       name="search_LTE_bindTimeEnd"
                       id="search_LTE_bindTimeEnd" value="${param['search_LTE_bindTimeEnd']}"
                       class="m-wrap small span2"
                >
                &nbsp;&nbsp;
                <select style="width: 6rem" name="search_EQ_customTimeType" id="search_EQ_customTimeType">
                    <option value="1"
                            <c:if test="${'1' eq param['search_EQ_customTimeType']}">selected="selected"</c:if>>
                        回访时间
                    </option>
                    <option value="2"
                            <c:if test="${'2' eq param['search_EQ_customTimeType']}">selected="selected"</c:if>>
                        约看时间
                    </option>
                    <option value="3"
                            <c:if test="${'3' eq param['search_EQ_customTimeType']}">selected="selected"</c:if>>
                        到访时间
                    </option>
                    <option value="4"
                            <c:if test="${'4' eq param['search_EQ_customTimeType']}">selected="selected"</c:if>>
                        认筹时间
                    </option>
                    <option value="5"
                            <c:if test="${'5' eq param['search_EQ_customTimeType']}">selected="selected"</c:if>>
                        认购时间
                    </option>
                    <option value="6"
                            <c:if test="${'6' eq param['search_EQ_customTimeType']}">selected="selected"</c:if>>
                        签约时间
                    </option>
                </select>
                <input style="width: 7rem;border: 1px solid #d5d5d5;" type="text"
                       name="search_GTE_customTimeStart"
                       id="search_GTE_customTimeStart" value="${param['search_GTE_customTimeStart']}"
                       class="m-wrap small span2"
                >至
                <input style="width: 7rem;margin-left: 15px;;border: 1px solid #d5d5d5;" type="text"
                       name="search_LTE_customTimeEnd"
                       id="search_LTE_customTimeEnd" value="${param['search_LTE_customTimeEnd']}"
                       class="m-wrap small span2"
                >
                <br/>
                客户姓名：<input style="width: 8rem;border: 1px solid #d5d5d5;" type="text" id="search_LIKE_name" name="search_LIKE_name" value="${param['search_LIKE_name']}"
                class="m-wrap small" placeholder="客户姓名">&nbsp;&nbsp;&nbsp;&nbsp;
                客户手机：<input style="width: 8rem;border: 1px solid #d5d5d5;" type="text" id="search_LIKE_phone" name="search_LIKE_phone" value="${param['search_LIKE_phone']}"
                class="m-wrap small" placeholder="客户手机">&nbsp;&nbsp;&nbsp;&nbsp;
                置业顾问：<input style="width: 8rem;border: 1px solid #d5d5d5;" type="text" id="search_LIKE_managerName" name="search_LIKE_managerName" value="${param['search_LIKE_managerName']}"
                class="m-wrap small" placeholder="置业顾问">&nbsp;&nbsp;&nbsp;&nbsp;
                回访记录：<input type="text" id="search_LIKE_callbackLog" style="border: 1px solid #d5d5d5;" name="search_LIKE_callbackLog" value="${param['search_LIKE_callbackLog']}"
                class="m-wrap small" placeholder="回访记录">
                约看楼盘：<input type="text" id="search_LIKE_projectName" style="border: 1px solid #d5d5d5;" name="search_LIKE_projectName" value="${param['search_LIKE_projectName']}"
                class="m-wrap small" placeholder="约看楼盘">
                <br/>
                回访状态：<select style="width: 8rem" name="search_EQ_isBack" id="search_EQ_isBack">
                <option value="1"
                        <c:if test="${'1' eq param['search_EQ_isBack']}">selected="selected"</c:if>>
                    全部
                </option>
                <option value="2"
                        <c:if test="${'2' eq param['search_EQ_isBack']}">selected="selected"</c:if>>
                    已回访
                </option>
                <option value="3"
                        <c:if test="${'3' eq param['search_EQ_isBack']}">selected="selected"</c:if>>
                    未回访
                </option>
                <option value="4"
                        <c:if test="${'4' eq param['search_EQ_isBack']}">selected="selected"</c:if>>
                    3~7天未回访
                </option>
                <option value="5"
                        <c:if test="${'5' eq param['search_EQ_isBack']}">selected="selected"</c:if>>
                    7~14天未回访
                </option>
                <option value="6"
                        <c:if test="${'6' eq param['search_EQ_isBack']}">selected="selected"</c:if>>
                    14天以上未回访
                </option>
                <option value="7"
                        <c:if test="${'7' eq param['search_EQ_isBack']}">selected="selected"</c:if>>
                    30天以上未回访
                </option>
                <option value="8"
                        <c:if test="${'8' eq param['search_EQ_isBack']}">selected="selected"</c:if>>
                    50天以上未回访
                </option>
                </select>&nbsp;&nbsp;&nbsp;&nbsp;
                客户状态：<select style="width: 6rem" name="search_EQ_projectStatus" id="search_EQ_projectStatus">
                <option value="">
                    全部
                </option>
                <option value="1"
                        <c:if test="${'1' eq param['search_EQ_projectStatus']}">selected="selected"</c:if>>
                    约看
                </option>
                <option value="2"
                        <c:if test="${'2' eq param['search_EQ_projectStatus']}">selected="selected"</c:if>>
                    到访
                </option>
                <option value="3"
                        <c:if test="${'3' eq param['search_EQ_projectStatus']}">selected="selected"</c:if>>
                    认筹
                </option>
                <option value="4"
                        <c:if test="${'4' eq param['search_EQ_projectStatus']}">selected="selected"</c:if>>
                    认购
                </option>
                <option value="5"
                        <c:if test="${'5' eq param['search_EQ_projectStatus']}">selected="selected"</c:if>>
                    签约
                </option>
                <option value="6"
                        <c:if test="${'6' eq param['search_EQ_projectStatus']}">selected="selected"</c:if>>
                    退房
                </option>
                </select>&nbsp;&nbsp;&nbsp;&nbsp;
                购房意向状态：<select style="width: 6rem" name="search_EQ_buyIntention" id="search_EQ_buyIntention">
                <option value="all">
                    全部
                </option>
                <option value=""
                        <c:if test="${'' eq param['search_EQ_buyIntention']}">selected="selected"</c:if>>
                    待定
                </option>
                <option value="1"
                        <c:if test="${'1' eq param['search_EQ_buyIntention']}">selected="selected"</c:if>>
                    A
                </option>
                <option value="2"
                        <c:if test="${'2' eq param['search_EQ_buyIntention']}">selected="selected"</c:if>>
                    B
                </option>
                <option value="3"
                        <c:if test="${'3' eq param['search_EQ_buyIntention']}">selected="selected"</c:if>>
                    C
                </option>
                <option value="4"
                        <c:if test="${'4' eq param['search_EQ_buyIntention']}">selected="selected"</c:if>>
                    D
                </option>
                <option value="5"
                        <c:if test="${'5' eq param['search_EQ_buyIntention']}">selected="selected"</c:if>>
                    E
                </option>
                </select>&nbsp;&nbsp;&nbsp;&nbsp;
                是否星标：<select style="width: 6rem" name="search_EQ_isStar" id="search_EQ_isStar">
                <option value="1"
                        <c:if test="${'1' eq param['search_EQ_isStar']}">selected="selected"</c:if>>
                    全部
                </option>
                <option value="2"
                        <c:if test="${'2' eq param['search_EQ_isStar']}">selected="selected"</c:if>>
                    是
                </option>
                <option value="3"
                        <c:if test="${'3' eq param['search_EQ_isStar']}">selected="selected"</c:if>>
                    否
                </option>
                </select>
                客户类型：<select style="width: 6rem" name="search_EQ_createSource" id="search_EQ_createSource">
                <option value="">
                    全部
                </option>
                <option value="CRM拉取"
                        <c:if test="${'CRM拉取' eq param['search_EQ_createSource']}">selected="selected"</c:if>>
                    营销活动
                </option>
                <option value="CRM导入"
                        <c:if test="${'CRM导入' eq param['search_EQ_createSource']}">selected="selected"</c:if>>
                    CRM导入
                </option>
                <option value="MANUAL"
                        <c:if test="${'MANUAL' eq param['search_EQ_createSource']}">selected="selected"</c:if>>
                    手动添加
                </option>
                <option value="HOTLINE"
                        <c:if test="${'HOTLINE' eq param['search_EQ_createSource']}">selected="selected"</c:if>>
                    400来电
                </option>
                <option value="IM咨询"
                        <c:if test="${'IM咨询' eq param['search_EQ_createSource']}">selected="selected"</c:if>>
                    IM咨询
                </option>
                <option value="留电"
                        <c:if test="${'留电' eq param['search_EQ_createSource']}">selected="selected"</c:if>>
                    留电
                </option>
                <%--<c:if test="${city == 'nj'}">--%>
                <option value="云迹"
                        <c:if test="${'云迹' eq param['search_EQ_createSource']}">selected="selected"</c:if>>
                    云迹
                </option>
                <option value="PT"
                        <c:if test="${'PT' eq param['search_EQ_createSource']}">selected="selected"</c:if>>
                    平台导入
                </option>
                <%--</c:if>--%>
                </select>

                <br/>
                <input name="id" type="hidden" value=""/>
                客户标签:
                <select id="labelId" name="labelId" class="selectpicker show-tick form-control"
                        multiple data-live-search="false">
                    <c:forEach items="${labellist}" var="singlelabel">
                        <option
                                <c:if test="${singlelabel.selected eq 1}">selected="selected"</c:if>
                                value="${singlelabel.labelId}">${singlelabel.labelName}</option>
                    </c:forEach>
                </select>


                活动名称：<input type="text" id="search_LIKE_sourceName" style="border: 1px solid #d5d5d5;" name="search_LIKE_sourceName" value="${param['search_LIKE_sourceName']}"
                class="m-wrap small" placeholder="活动名称">&nbsp;&nbsp;&nbsp;&nbsp;

            </c:if>

            <div style="float: right">
                <button type="button" class="btn btn-default"
                        onclick="$('#filterForm').submit();">搜索
                </button>&nbsp;&nbsp;&nbsp;&nbsp;
                <button type="button" class="btn btn-default"
                        onclick="resetForm()">重置
                </button>
            </div>
        </div>
    </div>

    <div class="page-container">
        <input type="hidden" id="managerId" name="managerId" value="${param['managerId']}"/>
        <input type="hidden" id="type" name="type" value="${param['type']}"/>
        <input type="hidden" name="summaryType" value="${summaryType}"/>
        <input type="hidden" id="currentUserId" name="currentUserId" value="${currentUserId}"/>
        <input type="hidden" id="timePeriod" name="timePeriod" value="${timePeriod}"/>

        <div class="row-fluid">
            <ul class="nav nav-tabs" style="margin-bottom: 0;position: relative;">
                <li <c:if test="${'waitCall' eq param['type']}">class="active"</c:if>>
                    <a href="javascript:linkTypeUrl('waitCall')">待回访</a>
                </li>
                <%--<c:if test="${city == 'nj'}">--%>
                <li <c:if test="${'cloud' eq param['type']}">class="active"</c:if>>
                    <a href="javascript:linkTypeUrl('cloud')">云迹</a>
                </li>
                <%--</c:if>--%>
                <li <c:if test="${'' eq param['type'] || empty param['type']}">class="active"</c:if>>
                    <a href="javascript:linkTypeUrl('')">全部</a>
                </li>
                <li <c:if test="${'newadd' eq param['type']}">class="active"</c:if>>
                    <a href="javascript:linkTypeUrl('newadd')">新增</a>
                </li>
                <li <c:if test="${'callback' eq param['type']}">class="active"</c:if>>
                    <a href="javascript:linkTypeUrl('callback')">回访</a>
                </li>
                <li <c:if test="${'valid' eq param['type']}">class="active"</c:if>>
                    <a href="javascript:linkTypeUrl('valid')">有效</a>
                </li>
                <li <c:if test="${'deal' eq param['type']}">class="active"</c:if>>
                    <a href="javascript:linkTypeUrl('deal')">成交</a>
                </li>
                <c:if test="${sessionCurrDept.id ne 2}">
                    <li <c:if test="${'respite' eq param['type']}">class="active"</c:if>>
                        <a href="javascript:linkTypeUrl('respite')">暂缓</a>
                    </li>
                </c:if>
                <li <c:if test="${'handover' eq param['type']}">class="active"</c:if>>
                    <a href="javascript:linkTypeUrl('handover')">交接</a>
                </li>
                <li <c:if test="${'active' eq param['type']}">class="active"</c:if>>
                    <a href="javascript:linkTypeUrl('active')">活跃</a>
                    <span style="margin-left: 55px;margin-top: -70px" class="glyphicon glyphicon-question-sign"
                          aria-hidden="true" data-toggle="tooltip" data-placement="top"
                          title="指48小时CRM视图有报名轨迹的客户"></span>
                </li>

                <li style="float: right;padding-top: 10px;padding-right: 10px;">
                    <c:if test="${'waitCall' eq param['type']}">
                        <select style="width: 120px" name="search_EQ_orderByTime" id="search_EQ_orderByTime"
                                onchange="$('#filterForm').submit();">
                            <option value="3"
                                    <c:if test="${'3' eq param['search_EQ_orderByTime']}">selected="selected"</c:if>>
                                派工时间降序
                            </option>
                            <option value="4"
                                    <c:if test="${'4' eq param['search_EQ_orderByTime']}">selected="selected"</c:if>>
                                派工时间升序
                            </option>
                        </select>
                    </c:if>

                    <c:if test="${'waitCall' ne param['type']}">
                        <select style="width: 120px" name="search_EQ_orderByTime" id="search_EQ_orderByTime"
                                onchange="$('#filterForm').submit();">
                            <option value="1"
                                    <c:if test="${'1' eq param['search_EQ_orderByTime']}">selected="selected"</c:if>>
                                添加时间降序
                            </option>
                            <option value="2"
                                    <c:if test="${'2' eq param['search_EQ_orderByTime']}">selected="selected"</c:if>>
                                添加时间升序
                            </option>
                            <option value="3"
                                    <c:if test="${'3' eq param['search_EQ_orderByTime']}">selected="selected"</c:if>>
                                派工时间降序
                            </option>
                            <option value="4"
                                    <c:if test="${'4' eq param['search_EQ_orderByTime']}">selected="selected"</c:if>>
                                派工时间升序
                            </option>
                            <option value="5"
                                    <c:if test="${'5' eq param['search_EQ_orderByTime']}">selected="selected"</c:if>>
                                回访时间降序
                            </option>
                            <option value="6"
                                    <c:if test="${'6' eq param['search_EQ_orderByTime']}">selected="selected"</c:if>>
                                回访时间升序
                            </option>
                        </select>
                    </c:if>
                </li>
            </ul>
        </div>
    </div>
</form>

<c:choose>
    <c:when test="${'waitCall' eq param['type']}">
        <table class="table table-striped table-advance table-hover">
            <tr>
                <td/>
                <td>ID</td>
                <td>姓名</td>
                <td>手机</td>
                <td>报名项目</td>
                <td>报名时间</td>
                <td>活动名称</td>
                <td>派工时间</td>
                <c:if test="${hasCustomerRemoveDaysNocall == true}">
                    <td>倒计时（小时）</td>
                </c:if>
                <td>置业顾问</td>
                <td>操作</td>
            </tr>

            <tbody>
            <c:forEach items="${customers}" var="customer" varStatus="vs">
                <tr>
                    <td nowrap="nowrap" style="text-align:center">
                        <input type="checkbox" name="memberCheck" value="${customer.id}" onclick="checkMember(this)"/>
                    </td>
                    <td>
                        <c:if test="${null ne customer.id && '' ne customer.id}">
                            <c:out value="${customer.id}"/>
                        </c:if>
                        <c:if test="${null eq customer.id || '' eq customer.id}">
                            &nbsp;
                        </c:if>
                    </td>
                    <td>
                        <c:if test="${null ne customer.name && '' ne customer.name}">
                            <c:choose>
                                <c:when test="${fn:length(customer.name) > 3}">
                                    <c:out value="${fn:substring(customer.name, 0, 3)}..."/>
                                </c:when>
                                <c:otherwise>
                                    <c:out value="${customer.name}"/>
                                </c:otherwise>
                            </c:choose>
                        </c:if>
                        <c:if test="${null eq customer.name || '' eq customer.name}">
                            &nbsp;
                        </c:if>
                    </td>
                    <td style="width: 150px;">
                        <span>${customer.phone}</span>
                        <c:if test="${customer.isPrivate == 1}">
                            <span class="num3">私</span>
                        </c:if>
                    </td>
                    <td>
                        <c:if test="${null ne customer.bakPhone1 && '' ne customer.bakPhone1}">
                            <c:out value="${customer.bakPhone1}"/>
                        </c:if>
                        <c:if test="${null eq customer.bakPhone1 || '' eq customer.bakPhone1}">
                            &nbsp;
                        </c:if>
                    </td>

                    <td>
                        <c:if test="${null ne customer.singupTime && '' ne customer.singupTime}">
                            <c:out value="${customer.singupTime}"/>
                        </c:if>
                        <c:if test="${null eq customer.singupTime || '' eq customer.singupTime}">
                            &nbsp;
                        </c:if>
                    </td>
                    <td>
                        <c:if test="${null ne customer.actSource && '' ne customer.actSource}">
                            <c:out value="${customer.actSource}"/>
                        </c:if>
                        <c:if test="${null eq customer.actSource || '' eq customer.actSource}">
                            &nbsp;
                        </c:if>
                    </td>
                    <td>
                        <c:if test="${null ne customer.bindTime && '' ne customer.bindTime}">
                            <f:formatDate value='${customer.bindTime}'
                                          pattern='yyyy-MM-dd HH:mm:ss'/>
                        </c:if>
                        <c:if test="${null eq customer.bindTime || '' eq customer.bindTime}">
                            &nbsp;
                        </c:if>
                    </td>
                    <c:if test="${hasCustomerRemoveDaysNocall == true}">
                        <td>
                            <c:if test="${null ne customer.countdownTime && '' ne customer.countdownTime}">
                                <c:out value="${customer.countdownTime}"/>
                            </c:if>
                            <c:if test="${null eq customer.countdownTime || '' eq customer.countdownTime}">
                                &nbsp;
                            </c:if>
                        </td>
                    </c:if>
                    <td>
                        <c:if test="${null ne customer.managerName && '' ne customer.managerName}">
                            <c:out value="${customer.managerName}"/>
                        </c:if>
                        <c:if test="${null eq customer.managerName || '' eq customer.managerName}">
                            &nbsp;
                        </c:if>
                    </td>
                    <td>
                        <a href="javascript:void(0)" onclick="getCRM(${customer.id})">CRM视图</a>
                        <a href="javascript:void(0)"
                           onclick="callCustomer('${customer.phone}','${customer.markedLabelId}','${customer.managerId}', '${customer.id}','${customer.buyIntention}','1','${customer.isPeer}', '${customer.starCustomer}')">回访</a>
                        <a href="javascript:void(0)" onclick="abandonCustomer(${customer.id})">放弃</a>
                        <c:if test="${customer.isPrivate == 1}">
                            <a href="javascript:void(0)"
                               onclick="waitCustomerInfo(${customer.id}, '1', ${customer.managerId})">详情</a>
                        </c:if>
                    </td>
                </tr>
            </c:forEach>
            </tbody>
        </table>
        <div class="row-fluid" style="position: relative">
            <div class="bottomBtn" style="overflow: hidden">
                <div class="checkAll">选择全部：<input type="checkbox" onclick="checkAll(this)"/></div>
                <c:if test="${isDirector == true}">
                    <div class="bottomBtnR" style="margin:0 15px 0 15px;" onclick="batchAssignManager()">批量改派</div>
                </c:if>
            </div>
            <house365:newPagination page="${page}"/>
        </div>
    </c:when>
    <c:otherwise>
        <div class="row-fluid" style="position: relative">
            <div class="bottomBtn" style="overflow: hidden">
                <div class="checkAll">选择全部：<input type="checkbox" onclick="checkAll(this)"/></div>
                <div class="bottomBtnL" onclick="assignHouse()">批量约看</div>
                <div class="bottomBtnR" onclick="assignManager()">客户转移</div>
                <div class="bottomBtnR" onclick="addCustomerLabel()">添加标签</div>
                <c:if test="${'waitCall' ne param['type'] && isDirector == true}">
                    <div class="bottomBtnR" style="margin:0 15px 0 15px;" onclick="batchRemove()">批量转出</div>
                </c:if>
            </div>
        </div>
        <table class="table table-advance mine">
            <tbody>
            <c:forEach items="${customers}" var="customer" varStatus="vs">
                <tr id="customerId_${customer.id}" class="header expand
                         <c:if test="${customer.star ne 'on' && vs.index%2==0}">table-complex</c:if>
                         <c:if test="${customer.star eq 'on'}">table-star</c:if>">
                    <td class="mangerId mangerItem mine">
                        <div class="mangerItem__border"></div>
                        <input type="checkbox" name="memberCheck" value="${customer.id}"
                               onclick="checkMember(this)">
                        <span class="mangerId_num mine">${customer.id}</span>
                        <span class="mangerId_name">
                            <c:if test="${null ne customer.name && '' ne customer.name}">
                                <c:choose>
                                    <c:when test="${fn:length(customer.name) > 3}">
                                        <c:out value="${fn:substring(customer.name, 0, 3)}..."/>
                                    </c:when>
                                    <c:otherwise>
                                        <c:out value="${customer.name}"/>
                                    </c:otherwise>
                                </c:choose>
                            </c:if>
                            <c:if test="${null eq customer.name || '' eq customer.name}">
                                &nbsp;
                            </c:if>
                        </span>
                        <div class="mangerId_content">
                            <div class="mangerId_phone">
                                <c:if test="${null ne customer.phone && '' ne customer.phone}">
                                    <a href="javascript:void(0)" onclick="getCRM(${customer.id})"><c:out
                                            value="${customer.phone}"/></a>
                                </c:if>
                                <c:if test="${null eq customer.phone || '' eq customer.phone}">
                                    &nbsp;
                                </c:if>
                                <c:if test="${hasPhone == 1}">
                                    <span id="star" class="icon-phone-sign"
                                          onclick="callCustomer('${customer.phone}','${customer.markedLabelId}','${customer.managerId}', '${customer.id}','${customer.buyIntention}','0','${customer.isPeer}', '${customer.starCustomer}')"></span>
                                </c:if>
                            </div>
                            <div class="mangerId_person">
                                <c:if test="${null ne customer.createSource && '' ne customer.createSource}">
                                    <c:out value="${customer.createSource}"/>
                                </c:if>
                                <c:if test="${null eq customer.createSource || '' eq customer.createSource}">
                                    &nbsp;
                                </c:if>
                            </div>
                            <div class="mangerId_person">
                                <div class="mangerId_avar">
                                    <c:if test="${null ne customer.managerName && '' ne customer.managerName}">
                                        <c:out value="${customer.managerName}"/>
                                    </c:if>
                                    <c:if test="${null eq customer.managerName || '' eq customer.managerName}">
                                        &nbsp;
                                    </c:if>
                                </div>
                                <div class="mangerId_up">
                                    <c:choose>
                                        <c:when test="${customer.buyIntention eq '1'}">
                                            A
                                        </c:when>
                                        <c:when test="${customer.buyIntention eq '2'}">
                                            B
                                        </c:when>
                                        <c:when test="${customer.buyIntention eq '3'}">
                                            C
                                        </c:when>
                                        <c:when test="${customer.buyIntention eq '4'}">
                                            D
                                        </c:when>
                                        <c:when test="${customer.buyIntention eq '5'}">
                                            E
                                        </c:when>
                                        <c:otherwise>
                                            待定
                                        </c:otherwise>
                                    </c:choose>
                                </div>
                            </div>
                        </div>
                        <div class="mangerId_state">
                            <c:if test="${not empty customer.traceStatus}">
                                <c:choose>
                                    <c:when test="${customer.traceStatus eq '1'}">
                                        <span class="inline">有效</span>
                                    </c:when>
                                    <c:when test="${customer.traceStatus eq '2'}">
                                        <span class="inline">已购</span>
                                    </c:when>
                                    <c:when test="${customer.traceStatus eq '3'}">
                                        <span class="inline">我购</span>
                                    </c:when>
                                    <c:when test="${customer.traceStatus eq '4'}">
                                        <span class="inline">暂缓</span>
                                    </c:when>
                                </c:choose>
                            </c:if>
                            <c:if test="${empty customer.traceStatus}">
                            </c:if>
                        </div>
                        <!-- 标签 -->
                        <div style="margin-top: 40px;text-indent:0">
                            <c:forEach items="${customer.lids}" var="lid">
                                <c:if test="${1 eq lid.colorId}">
                                    <%--<span class="tag-item gray can_close" style="background-color: #999;" data-index="1"--%>
                                    <%--onclick="delCustomerLabel(${customer.id},${customer.managerId},${lid.labelId})">${lid.labelName}</span>--%>
                                    <span class="tag-item gray" style="background-color: #999;"
                                          data-index="1">
                                            ${lid.labelName}
                                        <span class="glyphicon glyphicon-remove" aria-hidden="true"
                                              onclick="delCustomerLabel(${customer.id},${customer.managerId},${lid.labelId})"></span>
                                    </span>
                                </c:if>
                                <c:if test="${2 eq lid.colorId}">
                                    <span class="tag-item red" style="background-color: #d9534f;"
                                          data-index="2">
                                            ${lid.labelName}

                                        <span class="glyphicon glyphicon-remove" aria-hidden="true"
                                              onclick="delCustomerLabel(${customer.id}, ${customer.managerId},${lid.labelId})"></span>
                                    </span>
                                </c:if>
                                <c:if test="${3 eq lid.colorId}">
                                    <span class="tag-item orange" style="background-color: #f0ad4e;"
                                          data-index="3">
                                            ${lid.labelName}
                                        <span class="glyphicon glyphicon-remove" aria-hidden="true"
                                              onclick="delCustomerLabel(${customer.id}, ${customer.managerId},${lid.labelId})"></span>
                                    </span>
                                </c:if>
                                <c:if test="${4 eq lid.colorId}">
                                    <span class="tag-item green" style="background-color: #5cb85c;"
                                          data-index="4">
                                            ${lid.labelName}
                                         <span class="glyphicon glyphicon-remove" aria-hidden="true"
                                               onclick="delCustomerLabel(${customer.id}, ${customer.managerId},${lid.labelId})"></span>
                                    </span>
                                </c:if>
                                <c:if test="${5 eq lid.colorId}">
                                    <span class="tag-item blue" style="background-color: #5bc0de;"
                                          data-index="5">
                                            ${lid.labelName}
                                    <span class="glyphicon glyphicon-remove" aria-hidden="true"
                                          onclick="delCustomerLabel(${customer.id}, ${customer.managerId},${lid.labelId})"></span>
                                    </span>
                                </c:if>
                                <c:if test="${6 eq lid.colorId}">
                                    <span class="tag-item darkblue" style="background-color: #0275d8;"
                                          data-index="6"
                                          onclick="delCustomerLabel(${customer.id}, ${customer.managerId},${lid.labelId})">${lid.labelName}
                                        <span class="glyphicon glyphicon-remove" aria-hidden="true"></span>
                                    </span>
                                </c:if>
                                <c:if test="${7 eq lid.colorId}">
                                    <span class="tag-item zi" style="background-color: #663399;"
                                          data-index="7">
                                            ${lid.labelName}
                                        <span class="glyphicon glyphicon-remove" aria-hidden="true"
                                              onclick="delCustomerLabel(${customer.id}, ${customer.managerId},${lid.labelId})"></span>
                                    </span>
                                </c:if>
                            </c:forEach>
                        </div>
                    </td>
                    <td class="mangerlist mangerItem" style="width: 40%">
                        <c:if test="${0 ne fn:length(customer.callbackLogEntities)}">
                            <div class="mangerlist__txt" style="width: 60%">
                                <div class="mangerlist__item">
                                    <c:forEach items="${customer.callbackLogEntities}" var="callbackLog"
                                               varStatus="index">
                                        <p>
                                            <c:if test="${empty callbackLog.content && index.count<=3}">
                                                <c:if test="${empty callbackLog.callRecordId}">
                                                    [电话已拨，但未接通或被挂断]
                                                </c:if>
                                                <c:if test="${not empty callbackLog.callRecordId && index.count<=3}">
                                                    [语音记录]
                                                </c:if>
                                            </c:if>
                                            <c:if test="${not empty callbackLog.content && index.count<=3}">
                                                <c:choose>
                                                    <c:when test="${fn:length(callbackLog.content) > 20}">
                                                        <c:out value="${fn:substring(callbackLog.content, 0, 20)}..."/>
                                                    </c:when>
                                                    <c:otherwise>
                                                        <c:out value="${callbackLog.content}"/>
                                                    </c:otherwise>
                                                </c:choose>
                                            </c:if>
                                        </p>
                                    </c:forEach>
                                </div>
                            </div>
                            <div class="mangerlist__date">
                                <div class="mangerlist__dateC">
                                    <c:forEach items="${customer.callbackLogEntities}" var="callbackLog"
                                               varStatus="index">
                                        <p><c:if test="${index.count<=3}">
                                            <f:formatDate value='${callbackLog.createTime}' pattern='MM-dd HH:mm'/>
                                        </c:if>
                                        </p>
                                    </c:forEach>
                                </div>
                            </div>
                            <div class="mangerlist__record" onclick="showCustomerCallbackLogs('${customer.id}', '${customer.managerId}')">
                                查看回访记录
                            </div>
                        </c:if>
                        <c:if test="${0 eq fn:length(customer.callbackLogEntities)}">
                            <div class="mangerlist__txt">
                                <div class="mangerlist__item">
                                    暂无回访记录！
                                </div>
                            </div>
                            <div class="mangerlist__date">
                                <div class="mangerlist__dateC">
                                </div>
                            </div>
                        </c:if>
                        <div class="mangerItem__border"></div>
                    </td>
                    <td class="mangerItem mangerCollect ${customer.star}"
                        onclick="toggleCollect(this,'${customer.id}', '${customer.starUserId}', '${customer.star}', '${customer.managerId}')">
                        <div class="mangerItem__border"></div>
                    </td>
                    <td class="mangerItem mangerOperate" style="display: table;padding: 0;overflow:visible;">
                        <div class="mangerOperate__time" style="right:160px;width:150px;">
                            <c:if test="${null ne customer.bindTime && '' ne customer.bindTime}">
                                派工:<f:formatDate value='${customer.bindTime}'
                                                 pattern='MM-dd HH:mm'/>
                            </c:if>
                            <c:if test="${null eq customer.bindTime || '' eq customer.bindTime}">
                                &nbsp;
                            </c:if>
                        </div>
                        <div class="mangerOperate__time" style="right:0px">
                            <c:if test="${null ne customer.createTime && '' ne customer.createTime}">
                                <f:formatDate value='${customer.createTime}'
                                              pattern='MM-dd HH:mm'/>
                            </c:if>
                            <c:if test="${null eq customer.createTime || '' eq customer.createTime}">
                                &nbsp;
                            </c:if>
                        </div>
                        <div style="display: table-cell;vertical-align: middle">
                            <c:if test="${customer.hasCustomerProjects}">
                                <div class="mangerOperate__record" onclick="showCustomerProjects('${customer.id}','${customer.managerId}')"
                                     style="position: relative;">
                                    约看记录
                                    <c:if test="${customer.hasNewCustomerProjects}">
                                        <div style="position: absolute; width: 8px;height: 8px;background-color: red;border-radius: 50%;top: 5px;right: -7px;"></div>
                                    </c:if>
                                </div>
                            </c:if>
                            <c:if test="${!customer.hasCustomerProjects}">
                                <div class="mangerOperate__record none"
                                     style="position: relative;cursor: default;color:grey;">
                                    约看记录
                                </div>
                            </c:if>
                            <shiro:hasPermission name="FUNC:ADDCALL">
                                <c:set var='mmmm' value="${customer.markedLabelId}"/>
                                <div class="mangerOperate__add"
                                     onclick="addCallBack('${customer.id}','${customer.phone}','${customer.buyIntention}','${customer.isPeer}','${customer.markedLabelId}','${customer.starCustomer}')">
                                    添加回访
                                </div>
                            </shiro:hasPermission>
                            <div class="mangerOperate__guest"
                                 onclick="assignHouseSingle('${customer.id}'),setCookie('lastChoseCustomerId','${customer.id}');">
                                约看客户
                            </div>
                            <div class="mangerOperate__detail" onclick="customerInfo(${customer.id})">查看详情</div>
                            <c:if test="${'cloud' ne param['type']}">
                                <c:if test="${customer.hasReport == 0}">
                                    <div class="mangerOperate__detail" onclick="toAddReport(${customer.id})">创建置业报告
                                    </div>
                                </c:if>
                                <c:if test="${customer.hasReport == 1}">
                                    <div class="mangerOperate__detail" onclick="toEditReport(${customer.id})">修改置业报告
                                    </div>
                                </c:if>
                            </c:if>
                        </div>
                    </td>
                </tr>
            </c:forEach>
            </tbody>
        </table>
        <div class="row-fluid" style="position: relative">
            <div class="bottomBtn" style="overflow: hidden">
                <div class="checkAll">选择全部：<input type="checkbox" onclick="checkAll(this)"/></div>
                <div class="bottomBtnL" onclick="assignHouse()">批量约看</div>
                <div class="bottomBtnR" onclick="assignManager()">客户转移</div>
                <div class="bottomBtnR" onclick="addCustomerLabel()">添加标签</div>
                <c:if test="${'waitCall' ne param['type'] && isDirector == true}">
                    <div class="bottomBtnR" style="margin:0 15px 0 15px;" onclick="batchRemove()">批量转出</div>
                </c:if>
            </div>
            <house365:newPagination page="${page}"/>
        </div>
    </c:otherwise>
</c:choose>

<script type="text/html" id="customerCallbackLogsTemplate">
    <div class="returnWinList">
        {{if callbackLogs.length !=0}}
        {{each callbackLogs as log index}}
        <div class="returnWinItem">
            <div class="returnWinItem__txt">
                {{if log.content != "" && log.content != null}}
                {{log.content}}
                {{/if}}
                {{if log.callRecordId != "" && log.callRecordId != null}}
                <audio controls>
                    <source src="http://218.94.115.131:98/uncall_api/downloadFile.php?f_path={{log.callRecordName}}">
                    Your browser does not support this audio format.
                </audio>
                {{/if}}
                {{if (log.content == "" || log.content == null)}}
                {{if (log.callRecordId == "" || log.callRecordId == null)}}
                [电话已拨，但未接通或被挂断]
                {{/if}}
                {{if (log.callRecordId != "" && log.callRecordId != null)}}
                [语音记录]
                {{/if}}
                {{/if}}
            </div>
            <div class="returnWinItem__name" style="width:222px;top:35px;margin-left:-60px;">{{log.managerName}}</div>
            <div class="returnWinItem__date" style="width:222px;top:35px;margin-left:-60px;">{{log.createTime |
                dateFormat:'yyyy-MM-dd hh:mm:ss'}}
            </div>
            {{/each}}
            {{else}}
            暂无回访记录
            {{/if}}
        </div>
    </div>
</script>

<script type="text/html" id="customerProjectsTemplate">
    <div class="returnWinList list2">
        <div class="returnWinItem">
            <div class="reportWinItem bold date" style="text-indent: 27px;">约看楼盘</div>
            <div class="reportWinItem bold" style="text-indent: 12px;">案场报备</div>
            <div class="reportWinItem bold" style="text-indent: 12px;">客户状态</div>
            <div class="reportWinItem bold" style="text-indent: 12px;">贷款状态</div>
            <div class="reportWinItem bold" style="width:150px">约看时间</div>
            <div class="reportWinItem bold" style="text-indent: 12px;">操作</div>
        </div>
        {{if customerProjects.length !=0}}
        {{each customerProjects as cp index}}
        <div class="returnWinItem">
            <div class="reportWinItem date" style="text-indent: 27px;">
                <a href="{{ctx}}/project/{{cp.projectId}}" target="_blank">{{cp.projectName}}</a>
            </div>
            <div class="reportWinItem" style="text-indent: 12px;">
                {{if cp.recordedStatus == '1'}}
                <span>案场已报备</span>
                {{else if cp.recordedStatus == '0'}}
                <span>案场未报备</span>
                {{else}}
                <span>无</span>
                {{/if}}
            </div>
            <div class="reportWinItem" style="text-indent: 12px;">
                {{if cp.status == '1'}}
                <span>约看</span>
                {{else if cp.status == '2'}}
                <span>到访</span>
                {{else if cp.status == '3'}}
                <span>认筹</span>
                {{else if cp.status == '4'}}
                <span>认购</span>
                {{else if cp.status == '5'}}
                <span>签约</span>
                {{else if cp.status == '6'}}
                <span>退房</span>
                {{else}}
                <span>无</span>
                {{/if}}
            </div>
            <div class="reportWinItem" style="text-indent: 12px;">
                {{if cp.loanStatus == '0'}}
                <span>未办理</span>
                {{else if cp.loanStatus == '1'}}
                <span>申请中</span>
                {{else if cp.loanStatus == '2'}}
                <span>已下款</span>
                {{else if cp.loanStatus == '3'}}
                <span>被拒绝</span>
                {{else if cp.loanStatus == '4'}}
                <span>全款支付</span>
                {{else}}
                <span>无</span>
                {{/if}}
            </div>
            <div class="reportWinItem" style="width:150px">
                <span>{{cp.createTime | dateFormat:'yyyy.MM.dd hh:mm:ss'}}</span>
            </div>
            <div class="reportWinItem" style="text-indent: 12px;">
                <span><a href="{{ctx}}/customer/updateProjectInfo/{{cp.id}}" target="_blank">详情</a></span>
                <span color="red">{{cp.remark}}</span>
            </div>
        </div>
        {{/each}}
        {{else}}
        暂无约看记录
        {{/if}}
    </div>
</script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/jquery.qtip.custom/jquery.qtip.min.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/customize/js/template.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/customize/js/utils.js"></script>
<script type="text/javascript" src="${ctx}/resources/script/counterup/jquery.waypoints.min.js"></script>
<script type="text/javascript" src="${ctx}/resources/script/counterup/jquery.counterup.min.js"></script>

<script language="javascript" type="text/javascript">
    Date.prototype.pattern = function (fmt) {
        var o = {
            "M+": this.getMonth() + 1, //月份
            "d+": this.getDate(), //日
            "h+": this.getHours() % 12 == 0 ? 12 : this.getHours() % 12, //小时
            "H+": this.getHours(), //小时
            "m+": this.getMinutes(), //分
            "s+": this.getSeconds(), //秒
            "q+": Math.floor((this.getMonth() + 3) / 3), //季度
            "S": this.getMilliseconds() //毫秒
        };
        var week = {
            "0": "/u65e5",
            "1": "/u4e00",
            "2": "/u4e8c",
            "3": "/u4e09",
            "4": "/u56db",
            "5": "/u4e94",
            "6": "/u516d"
        };
        if (/(y+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
        }
        if (/(E+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, ((RegExp.$1.length > 1) ? (RegExp.$1.length > 2 ? "/u661f/u671f" : "/u5468") : "") + week[this.getDay() + ""]);
        }
        for (var k in o) {
            if (new RegExp("(" + k + ")").test(fmt)) {
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
            }
        }
        return fmt;
    }
</script>
<script src="${static_common}/jquery-ui/jquery-ui.min.js" type="text/javascript"></script>
<script type="text/javascript">

    var enterFlag = 0;
    $(document).keydown(function (event) {
        var style = document.getElementById("modal_dialog").style.display;
        if (style == 'block') {
            enterFlag = 1;
        } else {
            enterFlag = 0;
        }
        if (enterFlag == 0 && event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    });

    var lastChoseCustomerId = getCookie("lastChoseCustomerId");

    $(function () {
        $('[data-toggle="tooltip"]').tooltip()
    });

    $(function () {
        $('.counter').counterUp({
            delay: 100,
            time: 2000
        });
        $("#customerId_" + lastChoseCustomerId).addClass("lastChoseCustomer");

        // 初始化添加时间
        if ($('#timePeriod').val() == '0') {
            createTimeClick('0');
        }

        // 派工时间
        var bindTimeStart = $("#search_GTE_bindTimeStart")
        var bindTimeEnd = $("#search_LTE_bindTimeEnd");
        bindTimeEnd.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                minDate: bindTimeStart.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true
            });
            $("#bindTimeAll").css("color", "#000000");
            $("#bindTimeRecentSeven").css("color", "#000000");
            $("#bindTimeRecentThirty").css("color", "#000000");
        });
        bindTimeStart.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                maxDate: bindTimeEnd.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true,
                onpicked: function () {
                    WdatePicker({
                        startDate: "%y-{%M-1}-%d",
                        minDate: bindTimeStart.val(),
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        el: 'search_LTE_bindTimeEnd'
                    })
                }
            });
            $("#bindTimeAll").css("color", "#000000");
            $("#bindTimeRecentSeven").css("color", "#000000");
            $("#bindTimeRecentThirty").css("color", "#000000");
        });

        // 添加时间
        var createTimeStart = $("#search_GTE_createTimeStart")
        var createTimeEnd = $("#search_LTE_createTimeEnd");
        createTimeEnd.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                minDate: createTimeStart.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true
            });
            $("#createTimeRecentSeven").css("color", "#000000");
            $("#createTimeRecentThirty").css("color", "#000000");
            $("#createTimeAll").css("color", "#000000");
            $("#timePeriod").val('3');
        });
        createTimeStart.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                maxDate: bindTimeEnd.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true,
                onpicked: function () {
                    WdatePicker({
                        startDate: "%y-{%M-1}-%d",
                        minDate: createTimeStart.val(),
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        el: 'search_LTE_createTimeEnd'
                    })
                }
            });
            $("#createTimeRecentSeven").css("color", "#000000");
            $("#createTimeRecentThirty").css("color", "#000000");
            $("#createTimeAll").css("color", "#000000");
            $("#timePeriod").val('3');
        });

        // 报名时间
        var singupTimeStart = $("#search_GTE_singupTimeStart");
        var singupTimeEnd = $("#search_LTE_singupTimeEnd");
        singupTimeEnd.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                minDate: singupTimeStart.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true
            });
        });
        singupTimeStart.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                maxDate: singupTimeEnd.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true,
                onpicked: function () {
                    WdatePicker({
                        startDate: "%y-{%M-1}-%d",
                        minDate: singupTimeStart.val(),
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        el: 'singupTimeEnd'
                    })
                }
            });
        });

        // 自定义时间
        var customTimeStart = $("#search_GTE_customTimeStart");
        var customTimeEnd = $("#search_LTE_customTimeEnd");
        customTimeEnd.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                minDate: customTimeStart.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true
            });
        });
        customTimeStart.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                maxDate: customTimeEnd.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true,
                onpicked: function () {
                    WdatePicker({
                        startDate: "%y-{%M-1}-%d",
                        minDate: customTimeStart.val(),
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        el: 'search_LTE_customTimeEnd'
                    })
                }
            });
        });

        $('.baobei').each(function () { // Notice the .each() loop, discussed below
            $(this).qtip({
                content: {
                    text: $(this).next('div') // Use the "div" element next to this for the content
                },
                position: {
                    at: 'bottom center', // at the bottom right of...
                    target: $(this) // my target
                }
            });
        });

        $('.header').each(function () {
            $(this).nextUntil('tr.header').hide();
        });

        $('.header').click(function () {
            $(this).toggleClass('expand').nextUntil('tr.header').slideToggle(100);
        });
    });

    function delCustomerLabel(customerId, managerId, labelId) {
        $.ajax({
            url: '/house365-hgs-web/labelmanager/delCustomerLabel?customerId=' + customerId + "&labelId=" + labelId + "&managerId=" + managerId,
            type: "DELETE",
            success: function (data) {
                if (data == "success") {
                    window.location.reload();
                } else {
                    alert("删除失败");
                    return false;
                }
            }
        });
    }

    function assignHouse() {
        var customerIds = "";
        for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
            if (document.getElementsByName('memberCheck')[i].checked) {
                customerIds += document.getElementsByName('memberCheck')[i].value + ",";
            }
        }
        if (customerIds == '') {
            alert("请至少选择一个客户!");
            return false;
        }
        $.ajax({
            url: '/house365-hgs-web/customer/judgeSee',
            data: {
                "customerIds": customerIds
            },
            type: "GET",
            success: function (data) {
                if (data.status == 0) {
                    House365Util.createRemoteModal("批量约看客户", "/house365-hgs-web/customer/assignProject?customerId=" + customerIds, null, function () {
                        var userIds = "";
                        if ($("#custom-headers").find("option:selected").length == 0) {
                            alert("约看项目不可为空!");
                            return false;
                        }

                        $("#custom-headers").find("option:selected").each(function () {
                            userIds = userIds + $(this).val() + ",";
                        });

                        if (customerIds == '') {
                            alert("至少要选择一个客户!");
                            return false;
                        }

                        $.ajax({
                            url: '/house365-hgs-web/customer/bindProject',
                            data: {
                                "projectIds": userIds,
                                "customerIds": customerIds
                            },
                            type: "GET",
                            success: function (data) {
                                if (data.result == '1') {
                                    window.location.href = window.location.href;
                                } else {
                                    alert("操作失败，" + data.msg);
                                }
                            }
                        });
                        return true;
                    });
                } else {
                    alert(data.errorMessage);
                }
            }
        });

        $(".modal").css("width", "560px");
    }

    function assignHouseSingle(obj) {
        $.ajax({
            url: '/house365-hgs-web/customer/judgeSee',
            data: {
                "customerIds": obj
            },
            type: "GET",
            success: function (data) {
                if (data.status == 0) {
                    House365Util.createRemoteModal("约看客户", "/house365-hgs-web/customer/assignProject?customerId=" + obj, null, function () {
                        var userIds = "";
                        if ($("#custom-headers").find("option:selected").length == 0) {
                            alert("约看项目不可为空!");
                            return false;
                        }

                        $("#custom-headers").find("option:selected").each(function () {
                            userIds = userIds + $(this).val() + ",";
                        });

                        if (obj == '') {
                            alert("至少要选择一个客户!");
                            return false;
                        }

                        $.ajax({
                            url: '/house365-hgs-web/customer/bindProject',
                            data: {
                                "projectIds": userIds,
                                "customerIds": obj
                            },
                            type: "GET",
                            success: function (data) {
                                window.location.reload();
                            }
                        });
                        return true;
                    });

                } else {
                    alert(data.errorMessage);
                }
            }
        });

        $(".modal").css("width", "560px");
        //重置modal框样式
//        $("#myModal").css("height", "0px");
//        $("#myModal").css("width", "0px");
    }

    function resetForm() {
        // 重置派工时间 全部 近7天 近30天 选中状态
        $("#bindTimeAll").css("color", "#30A3DE");
        $("#bindTimeRecentSeven").css("color", "#000000");
        $("#bindTimeRecentThirty").css("color", "#000000");
        // 重置添加时间 近7天 近30天 全部 选中状态
//        $("#createTimeRecentSeven").css("color", "#30A3DE");
//        $("#createTimeRecentThirty").css("color", "#000000");
//        $("#createTimeAll").css("color", "#000000");
        $("#createTimeRecentSeven").css("color", "#000000");
        $("#createTimeRecentThirty").css("color", "#000000");
        $("#createTimeAll").css("color", "#30A3DE");

        // 重置form
        $("#filterForm")[0].reset();
        $("#search_GTE_bindTimeStart").val('');
        $("#search_LTE_bindTimeEnd").val('');
        $("#search_GTE_singupTimeStart").val('');
        $("#search_LTE_singupTimeEnd").val('');
        $("#search_LIKE_name").val('');
        $("#search_LIKE_phone").val('');
        $("#search_LIKE_bakPhone1").val('');
        $("#search_LIKE_latestSource").val('');
        $("#search_LIKE_actSource").val('');
        $("#search_LIKE_managerName").val('');
        $("#search_GTE_createTimeStart").val('');
        $("#search_LTE_createTimeEnd").val('');
        $("#search_LIKE_sourceName").val('');
        // 下拉框自定义时间
        $("#search_EQ_customTimeType").val('1');
        $("#search_GTE_customTimeStart").val('');
        $("#search_LTE_customTimeEnd").val('');

        $("#search_LIKE_callbackLog").val('');
        $("#search_LIKE_projectName").val('');

        // 重置营销活动下拉框
        $("#labelId").val("");
        $("#labelId").trigger('chosen:updated');
        $("#search_EQ_createSource").val("");
        $("#search_EQ_createSource").trigger('chosen:updated');
        $("#search_EQ_activeId").val("");
        $("#search_EQ_activeId").trigger('chosen:updated');
        // 重置回访状态下拉框
        $("#search_EQ_isBack").val("1");
        $("#search_EQ_isBack").trigger('chosen:updated');
        // 重置客户状态下拉框
        $("#search_EQ_projectStatus").val("");
        $("#search_EQ_projectStatus").trigger('chosen:updated');
        // 重置购房意向状态下拉框
        $("#search_EQ_buyIntention").val("all");
        $("#search_EQ_buyIntention").trigger('chosen:updated');
        // 重置是否星标下拉框
        $("#search_EQ_isStar").val("1");
        $("#search_EQ_isStar").trigger('chosen:updated');

        // 重置添加时间 近7天 开始时间结束时间
        createTimeClick('0');
    }

    function sortCreateTime() {
        var mode = $("#sort_createTime").val();
        if (mode == 'desc') {
            mode = 'asc';
        } else if (mode == 'asc') {
            mode = 'desc';
        } else if (mode == '' || mode == undefined) {
            mode = 'desc';
        }
        $("#sort_createTime").val(mode);

        $("#filterForm").submit();
    }

    function sortStar() {
        var mode = $("#sort_star").val();
        if (mode == 'desc') {
            mode = '';
        } else if (mode == 'asc') {
            mode = 'desc';
        } else if (mode == '' || mode == undefined) {
            mode = 'desc';
        }
        $("#sort_star").val(mode);

        $("#filterForm").submit();
    }

    var customerIdList = [];
    function addCustomerLabel() {
        var haslabel = "${haslabel}";
        if (haslabel != 1) {
            alert("暂无标签,请到标签管理中添加");
            return false;
        }
        var customerIds = "";
        var selectObj = document.getElementsByName('memberCheck');
        if (selectObj.length == 0) {
            alert("请选择想要标记的客户");
            return false;
        }

        for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
            if (document.getElementsByName('memberCheck')[i].checked) {
                customerIds += document.getElementsByName('memberCheck')[i].value + ",";
                customerIdList.push(document.getElementsByName('memberCheck')[i].value);
            }
        }
        if (customerIds == '') {
            alert("请选择想要标记的客户");
            return false;
        }
        $("#labelModel").modal('show');
    }

    function assignManager() {
        var customerIds = "",
            customerCont = 0;
        for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
            if (document.getElementsByName('memberCheck')[i].checked) {
                customerIds += document.getElementsByName('memberCheck')[i].value + ",";
                customerCont += 1;
            }
        }

        if (customerIds == '') {
            alert("请至少选择一个客户!");
            return false;
        }

        House365Util.createRemoteModal("客户转移", "/house365-hgs-web/customer/transManager?customerCount=" + customerCont, null, function () {
            var userIds = "";
            if ($("#custom-headers").find("option:selected").length == 0) {
                alert("分派人员不可为空!");
                return false;
            }

            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });

            if (customerIds == '') {
                alert("至少要选择一个客户!");
                return false;
            }

            $.ajax({
                url: '/house365-hgs-web/customer/assign',
                data: {
                    "userIds": userIds,
                    "customerIds": customerIds,
                    "type": 'handover'
                },
                type: "GET",
                success: function (data) {
                    if (data.result == '1') {
                        window.location.reload();
                    } else {
                        alert("操作失败，" + data.msg);
                    }
                }
            });
            return true;
        });
        $(".modal").css("width", "560px");
        //重置modal框样式
//        $("#myModal").css("height", "0px");
//        $("#myModal").css("width", "0px");
    }

    function batchAssignManager() {
        var customerIds = "",
            customerCont = 0;
        for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
            if (document.getElementsByName('memberCheck')[i].checked) {
                customerIds += document.getElementsByName('memberCheck')[i].value + ",";
                customerCont += 1;
            }
        }

        if (customerIds == '') {
            alert("请至少选择一个客户!");
            return false;
        }

        House365Util.createRemoteModal("批量改派", "/house365-hgs-web/customer/assignManager?multyassign=1&customerCount=" + customerCont, null, function () {
            var userIds = "";
            if ($("#custom-headers").find("option:selected").length == 0) {
                alert("分派人员不可为空!");
                return false;
            }

            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });

            if (customerIds == '') {
                alert("至少要选择一个客户!");
                return false;
            }

            $.ajax({
                url: '/house365-hgs-web/customer/assign',
                data: {
                    "userIds": userIds,
                    "customerIds": customerIds,
                    "type": 'daihuifang'
                },
                type: "GET",
                success: function (data) {
                    if (data.result == '1') {
                        alert(data.msg);
                        window.location.reload();
                    } else {
                        alert("操作失败，" + data.msg);
                    }
                }
            });
            return true;
        });
        $(".modal").css("width", "560px");
    }

    function batchRemove() {
        var customerIds = "";
        for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
            if (document.getElementsByName('memberCheck')[i].checked) {
                customerIds += document.getElementsByName('memberCheck')[i].value + ",";
            }
        }
        if (customerIds == '') {
            alert("请至少选择一个客户!");
            return false;
        }
        House365Util.createModal("提示", "您确定要将客户移入公海吗？", function () {
            $.ajax({
                url: '${ctx}/customer/batchRemove',
                data: {
                    "customerIds": customerIds
                },
                type: "POST",
                success: function (data) {
                    if (data.result == '1') {
                        alert("所选用户已全部移入公海");
                        setTimeout("window.location.reload()", 1000);
                    } else {
                        alert("操作失败，" + data.msg);
                    }
                }
            });
        });
        $(".modal").css("width", "560px");
        //重置modal框样式
//        $("#myModal").css("height", "0px");
//        $("#myModal").css("width", "0px");
    }

    //全选
    var checkNum = 0;
    function checkAll(btn) {
        if (btn.checked) {
            for (var i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                checkNum++;
                document.getElementsByName('memberCheck')[i].checked = "checked";
            }
        } else {
            for (var i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                checkNum++;
                document.getElementsByName('memberCheck')[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        } else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    function showCustomerCallbackLogs(_customerId, managerId) {
        setCookie("lastChoseCustomerId", _customerId);
        $.ajax({
            url: '${ctx}/customermanagement/getCustomerCallbackLogs',
            data: {
                "customerId": _customerId,
                "managerId": managerId
            },
            type: "GET",
            success: function (data) {

                var callContentHtml = template('customerCallbackLogsTemplate', {
                    ctx: "${ctx}",
                    callbackLogs: data
                });
                House365Util.createModal("回访记录", callContentHtml, function () {
                });
                $(".modal").css("width", "900px");
            }
        });
    }

    function showCustomerProjects(_customerId, managerId) {
        setCookie("lastChoseCustomerId", _customerId);
        $.ajax({
            url: '${ctx}/customermanagement/getCustomerProjects',
            data: {
                "customerId": _customerId,
                "managerId": managerId
            },
            type: "GET",
            success: function (data) {

                var callContentHtml = template('customerProjectsTemplate', {
                    ctx: "${ctx}",
                    customerProjects: data
                });
                House365Util.createModal("约看记录", callContentHtml, function () {
                });
                $(".modal").css("width", "900px");
            }
        });
    }

    function bindTimeClick(bindTimeType) {
        var timeStart, timeEnd;
        var myDate = new Date();
        $("#timePeriod").val(bindTimeType);

        switch (bindTimeType) {
            case "0":
                timeEnd = "";
                timeStart = "";
                $("#bindTimeAll").css("color", "#30A3DE");
                $("#bindTimeRecentSeven").css("color", "#000000");
                $("#bindTimeRecentThirty").css("color", "#000000");
                break;
            case "1":
                timeEnd = myDate.pattern("yyyy-MM-dd");
                myDate.setDate(myDate.getDate() - 7 + 1);
                timeStart = myDate.pattern("yyyy-MM-dd");
                $("#bindTimeAll").css("color", "#000000");
                $("#bindTimeRecentSeven").css("color", "#30A3DE");
                $("#bindTimeRecentThirty").css("color", "#000000");
                break;
            case "2":
                timeEnd = myDate.pattern("yyyy-MM-dd");
                myDate.setDate(myDate.getDate() - 30 + 1);
                timeStart = myDate.pattern("yyyy-MM-dd");
                $("#bindTimeAll").css("color", "#000000");
                $("#bindTimeRecentSeven").css("color", "#000000");
                $("#bindTimeRecentThirty").css("color", "#30A3DE");
                break;
            default:
                break;
        }
        $("#search_GTE_bindTimeStart").val(timeStart);
        $("#search_LTE_bindTimeEnd").val(timeEnd);
    }

    function createTimeClick(createTimeType) {
        var timeStart, timeEnd;
        var myDate = new Date();
        $("#timePeriod").val(createTimeType);

        switch (createTimeType) {
            case "2":
                timeEnd = myDate.pattern("yyyy-MM-dd");
                myDate.setDate(myDate.getDate() - 7 + 1);
                timeStart = myDate.pattern("yyyy-MM-dd");
                $("#createTimeRecentSeven").css("color", "#30A3DE");
                $("#createTimeRecentThirty").css("color", "#000000");
                $("#createTimeAll").css("color", "#000000");
                break;
            case "1":
                timeEnd = myDate.pattern("yyyy-MM-dd");
                myDate.setDate(myDate.getDate() - 30 + 1);
                timeStart = myDate.pattern("yyyy-MM-dd");
                $("#createTimeRecentSeven").css("color", "#000000");
                $("#createTimeRecentThirty").css("color", "#30A3DE");
                $("#createTimeAll").css("color", "#000000");
                break;
            case "0":
                timeEnd = "";
                timeStart = "";
                $("#createTimeRecentSeven").css("color", "#000000");
                $("#createTimeRecentThirty").css("color", "#000000");
                $("#createTimeAll").css("color", "#30A3DE");
                break;
            default:
                break;
        }
        $("#search_GTE_createTimeStart").val(timeStart);
        $("#search_LTE_createTimeEnd").val(timeEnd);
    }

    function customerInfo(id) {
        setCookie("lastChoseCustomerId", id);
        window.open("/house365-hgs-web/customer/customerInfo?action=edit&customerId=" + id, "_blank");
    }

    function toAddReport(id) {
        window.open("/house365-hgs-web/propertyreport/toAdd/" + id, "_blank");
    }

    function toEditReport(id) {
        window.open("/house365-hgs-web/propertyreport/toEdit/" + id, "_blank");
    }

    function waitCustomerInfo(id, waitFlag, managerId) {
        setCookie("lastChoseCustomerId", id);
        window.open("/house365-hgs-web/customer/customerInfo?action=edit&customerId=" + id + "&waitFlag=" + waitFlag + "&managerId=" + managerId, "_blank");
//        window.open("/house365-hgs-web/customer/customerInfoNew?action=edit&customerId=" + id, "_blank");
    }

    function viewCustomer(type) {
        window.open("/house365-hgs-web/customermanagement/myCustomerNew?summaryType=" + type, "_blank");
    }

    function toggleCollect(_this, _customerId, userId, star, managerId) {
        setCookie("lastChoseCustomerId", _customerId);
        var currentUserId = $("#currentUserId").val();
        if (star == 'on' && managerId != currentUserId) {
            alert("其他人的星标客户不能取消哦");
            return false;
        }
        if (star == 'off' && userId != '' && userId != currentUserId) {
            alert("不能为其他客户添加星标哦");
            return false;
        }
        if (star == 'off' && userId == '' && managerId != currentUserId) {
            alert("不能为其他客户添加星标哦");
            return false;
        }
        //收藏
        var flag = "off";
        if ($(_this).hasClass('on')) {
            $(_this).removeClass('on');
            $(_this).parents("tr").removeClass("table-star");
        } else {
            flag = "on";
            $(_this).addClass('on');
            $(_this).parents("tr").addClass("table-star");
        }

        $.ajax({
            url: "${ctx}/customermanagement/starToggle",
            data: {flag: flag, 'customerId': _customerId},
            success: function (data) {
                window.location.reload();
            }
        });

    }

    //排序
    function sortBy(column, mode) {
        $("form input[name='orderColumn']").val(column);
        $("form input[name='orderMode']").val(mode);
        $('#filterForm').submit();
    }

    function linkTypeUrl(_type) {
        var linkTypeUrl = "${ctx}/customermanagement/myCustomerNew?type=" + _type;
        if ($("#managerId").val() != "") {
            linkTypeUrl += "&managerId=" + $("#managerId").val();
        }
        if ('waitCall' == _type) {
            linkTypeUrl += "&search_EQ_orderByTime=3";
        }
        if ('waitCall' != _type) {
//            linkTypeUrl += "&search_EQ_orderByTime=1";
            linkTypeUrl += "&search_EQ_orderByTime=5";
            $("#bindTimeAll").css("color", "#000000");
            $("#bindTimeRecentSeven").css("color", "#000000");
            $("#bindTimeRecentThirty").css("color", "#30A3DE");
        }
        window.location.href = linkTypeUrl;
    }

    //读取cookies
    function getCookie(name) {
        var arr, reg = new RegExp("(^| )" + name + "=([^;]*)(;|$)");

        if (arr = document.cookie.match(reg))

            return unescape(arr[2]);
        else
            return null;
    }

    //写cookies
    function setCookie(name, value) {
        $(".lastChoseCustomer").removeClass("lastChoseCustomer");
        $("#customerId_" + value).addClass("lastChoseCustomer");
        var Days = 30;
        var exp = new Date();
        exp.setTime(exp.getTime() + Days * 24 * 60 * 60 * 1000);
        document.cookie = name + "=" + escape(value) + ";expires=" + exp.toGMTString();
    }

    var curnet = "${sessionUser.cornet}";
    var initopen = 0;
    function callCustomer(memPhone, markedLabelId, managerId, customerId, buyIntention, abandon, isPeer, star) {
        //先将bat2样式清楚
        $(".bat2").removeAttr("style");
        document.getElementById("info11").innerHTML = '';
        if (markedLabelId != undefined && markedLabelId != '') {
            arr2 = markedLabelId.split(",");
            if (arr2.length > 0) {
                for (var i = 0; i < arr2.length; i++) {
                    $(".bat2[data-index=" + arr2[i] + "]").trigger("click");
                }
            }
        }

        $.ajax({
            url: "${ctx}/cityCall/judgeCall",
            data: '',
            type: "get",
            dataType: 'json',
            success: function (result) {
                if (result.status != 0) {
                    $("#tempCustomerId").val(customerId);
                    $("#waitPhone").val(memPhone);
                    $("#waitManagerId").val(managerId);
                    $("#starType").val(abandon);
                    $("#info11").val('');
                    $("#returnTime").val('');

                    $("#myModal").modal('show');
                    $("#btnGive").css("display", "block");
                    $("input[name='isPeer']").removeAttr('checked');
                    if (isPeer == 0) {
                        $("input[name='isPeer'][value='0']").prop("checked", true);
                    } else if (isPeer == 1) {
                        $("input[name='isPeer'][value='1']").prop("checked", true);
                    }
                    if (star == 0) {
                        $('#starImage').attr("src", "${ctx}/resources/img/collect_no.png")
                    } else if (star == 1) {
                        $('#starImage').attr("src", "${ctx}/resources/img/collect_yes.png")
                    }
                    $("#buyIntention1").val('');
                    $("#buyIntention1").trigger("chosen:updated");
                } else {
                    $("#myModal").hide();
                    $("#labelModel").hide();
                    if (curnet == "") {
                        House365Util.createModal("电话回访",
                            "对不起，您尚未填写固定电话短号，请前往个人中心设置", function () {
                                window.location.href = "${ctx}/role/edit/${sessionUserId}";
                            }, "前往设置");
                        return;
                    }
                    $("#callDialog").load("${ctx}/customermanagement/callCustomer?memPhone=" + memPhone + "&markedLabelId=" + markedLabelId + "&managerId=" + managerId + "&customerId=" + customerId
                        + "&buyIntention=" + buyIntention + "&abandon=" + abandon + "&isPeer=" + isPeer + "&star=" + star, null, function () {

                        $("#returnTime2").datetimepicker({
                            format: 'yyyy-mm-dd hh:ii:ss',
                            maxView: "decade",
                            minView: "hour",
                            startView: "month",
                            autoclose: true,
                            language: 'zh-CN',
                            viewSelect: "decade",
                            minuteStep: 10,
                            pickerPosition: "bottom-left"
                        });
                    });
                    $("#callDialog").dialog({
                        closeOnEscape: false,
                        autoOpen: false,
                        draggable: false,
                        modal: true,
                        open: function (event, ui) {
                            $(".ui-dialog-titlebar-close", $(this).parent()).hide();
                        },
                        show: {
                            effect: "blind",
                            duration: 100
                        },
                        hide: {
                            effect: "explode",
                            duration: 100
                        },
                        width: 600
                    }).dialog("open");
                }
            }
        });
    }

    function getCRM(customerId) {
        $.ajax({
            url: '${ctx}/customer/getCRMURL',
            data: {"customerId": customerId},
            type: "GET",
            success: function (data) {
                if (data.result == '1') {
                    if (data.data.entity == "") {
                        alert("该用户暂未推送至CRM");
                        return false;
                    }
                    window.open(data.data.entity);
                } else {
                    alert("操作失败，" + data.msg);
                }
            }
        });
    }

    function abandonCustomer(customerId) {
        House365Util.createModal("放弃客户", "警告，您正在放弃跟踪此客户，是否继续？", function () {
            $.ajax({
                url: '${ctx}/customer/abandonCustomer',
                data: {"customerId": customerId},
                type: "GET",
                success: function (data) {
                    if (data.result == '1') {
                        window.location.reload();
                    } else {
                        alert("操作失败，" + data.msg);
                    }
                }
            });
        });
    }

    var arr = new Array();
    var arr2 = new Array();
    var callId;
    function addCallBack(_customerId, _phone, _buyIntention, isPeer, markedLabelId, star) {
        $("#myModal").hide();
        $("#labelModel").hide();
        callId = _customerId;
        var hasOwnlabel = ${hasOwnlabel};
        if (markedLabelId != undefined && markedLabelId != '') {
            arr = markedLabelId.split(",");
        }

        setCookie("lastChoseCustomerId", _customerId);
        var addType = $("#type").val();
        var callContentHtml = "";
        callContentHtml += "<div class='row-fluid' ><div class='span5 control-group' style='position: relative'>"
            + " <label class='control-label'>购房意向：</label>"
            + "<div class='controls' style='position: absolute;top: -4px;left: 74px'><select name='entity.buyIntention' id='buyIntention'>"
            + "<option value=''";
        if (_buyIntention == "" || _buyIntention == null) {
            callContentHtml += "selected = 'selected'";
        }
        callContentHtml += ">请选择</option><option value='1'";
        if (_buyIntention == "1") {
            callContentHtml += "selected = 'selected'";
        }
        callContentHtml += ">A</option><option value='2'";
        if (_buyIntention == "2") {
            callContentHtml += "selected = 'selected'";
        }
        callContentHtml += ">B</option><option value='3'";
        if (_buyIntention == "3") {
            callContentHtml += "selected = 'selected'";
        }
        callContentHtml += ">C</option><option value='4'";
        if (_buyIntention == "4") {
            callContentHtml += "selected = 'selected'";
        }
        callContentHtml += ">D</option><option value='5'";
        if (_buyIntention == "5") {
            callContentHtml += "selected = 'selected'";
        }
        callContentHtml += ">E(丢入公海)</option>";
        callContentHtml += "</select>";
        callContentHtml += "<span style='margin-left: 211px;'>";
        if (star == 1) {
            callContentHtml += "<img style='margin-left: 200px;margin-top: -40px' id='starImage2' class='newCollect' src='${ctx}/resources/img/collect_yes.png' alt=''>";
        } else {
            callContentHtml += "<img style='margin-left: 200px;margin-top: -40px' id='starImage2' class='newCollect' src='${ctx}/resources/img/collect_no.png' alt=''>";
        }
        callContentHtml += "</span></div></div></div>";

        callContentHtml += "<div class='row-fluid'><div class='span5 control-group'  style='width: 100%;position: relative;'>"
            + " <label class='control-label'>回访内容：</label>";
        callContentHtml += "<p contenteditable='true' class='temp' cols='10' rows='5' style='margin: 0px 0px 10px;left:81px; width: 436px; height: 70px;' id='cusinfo' name='cusinfo'>" +
            "<div style='position: absolute;bottom: 39px;width: 400px;left:90px'>" +
            "<c:forEach items='${callbackTemplateList}' var='item'>" +
            "<button type='button' class='btn bt_last' style='margin: 5px' onclick='setCallbackContent2(this)'>${item.content}</button>" +
            "</c:forEach>" +
            "</div></p></div>";

        callContentHtml += "<div class='row-fluid'>" + "<div style='display: inline-flex;'><span>客户标签：</span>";
        if (hasOwnlabel == 1) {
            callContentHtml += "<div class='clearfix' style='display: flex;flex-wrap: wrap;width: 370px;\n" +
                "    line-height: 35px;\n" +
                "    height: auto;'>";
            callContentHtml += "<div style='margin-top: -5px;float:left;margin-left: 7px'>";

            callContentHtml += "<c:forEach items='${userLabelList}' var='lid'>";
            <%--callContentHtml += "<c:forEach items='${arr}' var='markId'>";--%>
            <c:choose>
            <c:when test="${fn:contains(markedLabelId, lid.labelId)}">
            callContentHtml += "<c:if test='${1 eq lid.colorId}'><span class='bat color_999' data-index='${lid.labelId}' opsel='' style='background-color: rgb(153, 153, 153); color: white;'>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${2 eq lid.colorId}'><span class='bat color_d9534f' data-index='${lid.labelId}' opsel='' style='background-color: rgb(217, 83, 79); color: white;'>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${3 eq lid.colorId}'><span class='bat color_f0ad4e' data-index='${lid.labelId}' opsel='' style='background-color: rgb(240, 173, 78); color: white;'>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${4 eq lid.colorId}'><span class='bat color_5cb85c' data-index='${lid.labelId}' opsel='' style='background-color: rgb(92, 184, 92); color: white;'>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${5 eq lid.colorId}'><span class='bat color_5bc0de' data-index='${lid.labelId}' opsel='' style='background-color: rgb(91, 192, 222); color: white;'>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${6 eq lid.colorId}'><span class='bat color_0275d8' data-index='${lid.labelId}' opsel='' style='background-color: rgb(2, 117, 216); color: white;'>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${7 eq lid.colorId}'><span class='bat color_663399' data-index='${lid.labelId}' opsel='' style='background-color: rgb(102, 51, 153); color: white;'>${lid.labelName}</span>";
            callContentHtml += "</c:if>";
            </c:when>
            <c:otherwise>
            callContentHtml += "<c:if test='${1 eq lid.colorId}'><span class='bat color_999' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${2 eq lid.colorId}'><span class='bat color_d9534f' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${3 eq lid.colorId}'><span class='bat color_f0ad4e' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${4 eq lid.colorId}'><span class='bat color_5cb85c' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${5 eq lid.colorId}'><span class='bat color_5bc0de' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${6 eq lid.colorId}'><span class='bat color_0275d8' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
            callContentHtml += "</c:if>";

            callContentHtml += "<c:if test='${7 eq lid.colorId}'><span class='bat color_663399' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
            callContentHtml += "</c:if>";
            </c:otherwise>
            </c:choose>
            callContentHtml += "</c:forEach></div></div></div></div>";
            callContentHtml += decodeURI('%3Cscript%3E for (lableId in arr) { $(".bat[data-index=" + arr[lableId] + "]").trigger("click"); }%3C/script%3E');
        } else {
            callContentHtml += "暂无标签,请到标签管理中添加</div></div>";
        }
        callContentHtml += "<div style='margin-top: 10px;'>" + "<span>回访提醒：</span>";
        callContentHtml += "<input type='text' style='width: 200px;margin-left: 12px' autocomplete='off' class='datetime-picker span2 input-large' id='returnTime' date-language='zh-CN' date-format='yyyy-mm-dd hh:ii:ss' placeholder='/年/月/日'>";
        callContentHtml += "</div>";

        if (isPeer == 0) {
            callContentHtml += "<div class='row-fluid'><div>" + "<span>中介同行：</span>" + "<input style='margin-left:12px' type='radio' name='isPeer1' value='0' checked>" + "否";
            callContentHtml += "<input style='margin-left: 20px;' type='radio' name='isPeer1' value='1'>" + "是" + "</div></div>";
        } else if (isPeer == 1) {
            callContentHtml += "<div class='row-fluid'><div>" + "<span>中介同行：</span>" + "<input type='radio' name='isPeer1' value='0'>" + "否";
            callContentHtml += "<input style='margin-left: 20px;' type='radio' name='isPeer1' value='1' checked>" + "是" + "</div></div>";
        }
        House365Util.createModal("添加回访", callContentHtml, function () {
//            var callContent = $("#callContent").val().replace(/(^\s*)|\s*$/g, '');
            var callContent = $("#cusinfo").text().replace(/(^\s*)|\s*$/g, '');
            var buyIntention = $("#buyIntention").val();
            var isPeer = $("input[name='isPeer1']:checked").val();
            var customerId = _customerId;
            var returnTime = $("#returnTime").val();
            var starImage = $('#starImage2').attr("src");
            var customerStar;
            if (starImage === '${ctx}/resources/img/collect_no.png') {
                customerStar = 0;
            } else {
                customerStar = 1;
            }

            //获取选中标签值
            var ids = "";
            if (arr.length > 0) {
                for (var i = 0; i < arr.length; i++) {
                    ids += arr[i] + ",";
                }
            }
            if (ids.indexOf(",") != -1) {
                ids = ids.substring(0, ids.length - 1);
            }

            if (buyIntention == null || buyIntention == '') {
                alert("请选择购房意向");
                return false;
            }
            if (returnTime != null && returnTime != '') {
                var date = new Date();
                var date1 = new Date(returnTime);
                if (date.getTime() > date1.getTime()) {
                    alert("回访提醒时间不能小于当前时间");
                    return false;
                }
            }
            $("#hiddenBuyIntention").val(buyIntention);
            if (!callContent || callContent == "") {
                alert("回访内容不能为空");
                return false;
            } else if (callContent.length > 600) {
                alert("不能超过600个字");
                return false;
            } else if (buyIntention == 5) {
                House365Util.createModal("提示", "您确定要将客户移入公海吗？", function () {
                    $.ajax({
                        url: '${ctx}/customer/addCall',
                        data: {
                            "content": callContent,
                            "customerId": customerId,
                            "buyIntention": buyIntention,
                            "labelIds": ids,
                            "phone": _phone,
                            "addType": addType
                        },
                        type: "GET",
                        success: function (data) {
                            if (data.result == '1') {
                                //更新客户是否中介同行状态
                                $.ajax({
                                    url: '${ctx}/customermanagement/updatePeerAndTime/' + 1,
                                    contentType: 'application/json',
                                    data: JSON.stringify({
                                        id: customerId,
                                        isPeer: isPeer,
                                        buyIntention: buyIntention,
                                        starCustomer: customerStar,
                                        returnRemindTime: returnTime
                                    }),
                                    dataType: 'json',
                                    type: "POST",
                                    success: function (data) {
                                        if (data.status == 0) {
                                            window.location.reload();
                                        } else {
                                            alert(data.errorMessage);
                                        }
                                    }
                                });
                            } else {
                                alert("操作失败，" + data.msg);
                            }
                        }
                    });
                });
                $(".modal").css("width", "560px");
                return false;
            } else {
                $.ajax({
                    url: '${ctx}/customer/addCall',
                    data: {
                        "content": callContent,
                        "customerId": customerId,
                        "buyIntention": buyIntention,
                        "labelIds": ids,
                        "phone": _phone,
                        "addType": addType
                    },
                    type: "GET",
                    success: function (data) {
                        if (data.result == '1') {
                            //更新客户是否中介同行状态
                            $.ajax({
                                url: '${ctx}/customermanagement/updatePeerAndTime/' + 1,
                                contentType: 'application/json',
                                data: JSON.stringify({
                                    id: customerId,
                                    isPeer: isPeer,
                                    starCustomer: customerStar,
                                    buyIntention: buyIntention,
                                    returnRemindTime: returnTime
                                }),
                                dataType: 'json',
                                type: "POST",
                                success: function (data) {
                                    if (data.status == 0) {
                                        window.location.reload();
                                    } else {
                                        alert(data.errorMessage);
                                    }
                                }
                            });
                        } else {
                            alert("操作失败，" + data.msg);
                        }
                    }
                });
            }
        });
    }

    $(document).on('click', '.bat2', function () {
//        var bor_color = $(this).css("border-color");
        var bor_color = $(this).css("borderRightColor");
        var bg_color = $(this).css("background-color");
        var labelIds = $("#labelIds").val();


        if (bg_color === 'rgb(255, 255, 255)') {
            $(this).css("background-color", bor_color);
            $(this).css("color", "white");
            $(this).attr("opsel", 1);
            var lid = $(this).attr("data-index");
            if (arr2.indexOf(lid) == -1) {
                arr2.push(lid);
            }
            initopen++;
        } else {
            initopen = 0;
            $(this).css("background-color", "rgb(255, 255, 255)");
            $(this).css("color", bor_color);
            $(this).attr("opsel", 0);
            var lid = $(this).attr("data-index");
            for (var i = 0; i < arr2.length; i++) {
                if (arr2[i] == lid) {
                    arr2.splice(i, 1);
                }
            }
        }
    });

    $(document).on('click', '.bat', function () {
//        var bor_color = $(this).css("border-color");
        var bor_color = $(this).css("borderRightColor");
        var bg_color = $(this).css("background-color");
        var labelIds = $("#labelIds").val();

        if (bg_color === 'rgb(255, 255, 255)') {
            $(this).css("background-color", bor_color);
            $(this).css("color", "white");
            $(this).attr("opsel", 1);
            var lid = $(this).attr("data-index");
            if (arr.indexOf(lid) == -1) {
                arr.push(lid);
            }
        } else {
            $(this).css("background-color", "rgb(255, 255, 255)");
            $(this).css("color", bor_color);
            $(this).attr("opsel", 0);
            var lid = $(this).attr("data-index");
            for (var i = 0; i < arr.length; i++) {
                if (arr[i] == lid) {
                    arr.splice(i, 1);
                }
            }
        }
    });

    function searchBack() {
        $("#filterForm").submit();
    }

    function save() {
        var customerId = $("#tempCustomerId").val();
        var waitManagerId = $("#waitManagerId").val();
        var waitPhone = $("#waitPhone").val();
        var buyIntention = $("#buyIntention1").val();
        var callContent = $("#info11").text().replace(/(^\s*)|\s*$/g, '');
        var returnTime = $("#returnTime1").val();
        var addType = $("#type").val();
        var starImage = $('#starImage').attr("src");
        var starType = $("#starType").val();
        var customerStar;
        if (starImage === '${ctx}/resources/img/collect_no.png') {
            customerStar = 0;
        } else {
            customerStar = 1;
        }

        //获取选中标签值
        var ids = "";
        if (arr2.length > 0) {
            for (var i = 0; i < arr2.length; i++) {
                ids += arr2[i] + ",";
            }
        }
        if (ids.indexOf(",") != -1) {
            ids = ids.substring(0, ids.length - 1);
        }

        if (buyIntention == null || buyIntention == '') {
            alert("请选择购房意向");
            return false;
        }
        if (returnTime != null && returnTime != '') {
            var date = new Date();
            var date1 = new Date(returnTime);
            if (date.getTime() > date1.getTime()) {
                alert("回访提醒时间不能小于当前时间");
                return false;
            }
        }

        if (!callContent || callContent == "") {
            alert("回访内容不能为空");
            return false;
        } else if (callContent.length > 600) {
            alert("不能超过600个字");
            return false;
        } else if (buyIntention == 5) {
            House365Util.createModal("提示", "您确定要将客户移入公海吗？", function () {
                $.ajax({
                    url: '${ctx}/customer/addCall',
                    data: {
                        "content": callContent,
                        "customerId": customerId,
                        "buyIntention": buyIntention,
                        "labelIds": ids,
                        "managerId": waitManagerId,
                        "phone": waitPhone,
                        "addType": addType
                    },
                    type: "GET",
                    success: function (data) {
                        if (data.result == '1') {
                            //更新客户是否中介同行状态
                            var isPeer = $("input[name='isPeer']:checked").val();
                            $.ajax({
                                url: '${ctx}/customermanagement/updatePeerAndTime/' + 0,
                                contentType: 'application/json',
                                data: JSON.stringify({
                                    id: customerId,
                                    isPeer: isPeer,
                                    starCustomer: customerStar,
                                    buyIntention: buyIntention,
                                    returnRemindTime: returnTime
                                }),
                                dataType: 'json',
                                type: "POST",
                                success: function (data) {
                                    if (data.status == 0) {
                                        $("#myModel").modal('hide');
                                        window.location.reload();
                                    } else {
                                        alert(data.errorMessage);
                                    }
                                }
                            });
                        } else {
                            alert("操作失败，" + data.msg);
                        }
                    }
                });
            });
            $(".modal").css("width", "560px");
            return false;
        } else {
            $.ajax({
                url: '${ctx}/customer/addCall',
                data: {
                    "content": callContent,
                    "customerId": customerId,
                    "buyIntention": buyIntention,
                    "labelIds": ids,
                    "managerId": waitManagerId,
                    "phone": waitPhone,
                    "addType": addType
                },
                type: "GET",
                success: function (data) {
                    if (data.result == '1') {
                        //更新客户是否中介同行状态
                        var isPeer = $("input[name='isPeer']:checked").val();
                        $.ajax({
                            url: '${ctx}/customermanagement/updatePeerAndTime/' + 0,
                            contentType: 'application/json',
                            data: JSON.stringify({
                                id: customerId,
                                isPeer: isPeer,
                                starCustomer: customerStar,
                                buyIntention: buyIntention,
                                returnRemindTime: returnTime
                            }),
                            dataType: 'json',
                            type: "POST",
                            success: function (data) {
                                if (data.status == 0) {
                                    $("#myModel").modal('hide');
                                    window.location.reload();
                                } else {
                                    alert(data.errorMessage);
                                }
                            }
                        });
                    } else {
                        alert("操作失败，" + data.msg);
                    }
                }
            });
        }
    }

    function giveUp() {
        var customerId = $("#tempCustomerId").val();
        var waitManagerId = $("#waitManagerId").val();
        var waitPhone = $("#waitPhone").val();
        var buyIntention = $("#buyIntention1").val();
        var callContent = $("#info11").val();
        var returnTime = $("#returnTime1").val();
        var starImage = $('#starImage').attr("src");
        var customerStar;
        if (starImage === '${ctx}/resources/img/collect_no.png') {
            customerStar = 0;
        } else {
            customerStar = 1;
        }
        if (returnTime != null && returnTime != '') {
            var date = new Date();
            var date1 = new Date(returnTime);
            if (date.getTime() > date1.getTime()) {
                alert("回访提醒时间不能小于当前时间");
                return false;
            }
        }

        //获取选中标签值
        var ids = "";
        if (arr2.length > 0) {
            for (var i = 0; i < arr2.length; i++) {
                ids += arr2[i] + ",";
            }
        }
        if (ids.indexOf(",") != -1) {
            ids = ids.substring(0, ids.length - 1);
        }

        if (buyIntention == 5) {
            House365Util.createModal("提示", "您确定要将客户移入公海吗？", function () {
                $.ajax({
                    url: '${ctx}/customer/addCall',
                    data: {
                        "content": callContent,
                        "customerId": customerId,
                        "isGiveUp": 1,
                        "labelIds": ids,
                        "managerId": waitManagerId,
                        "phone": waitPhone,
                        "buyIntention": buyIntention
                    },
                    type: "GET",
                    success: function (data) {
                        if (data.result == '1') {
                            //更新客户是否中介同行状态
                            var isPeer = $("input[name='isPeer']:checked").val();
                            $.ajax({
                                url: '${ctx}/customermanagement/updatePeerAndTime/' + 0,
                                contentType: 'application/json',
                                data: JSON.stringify({
                                    id: customerId,
                                    isPeer: isPeer,
                                    buyIntention: buyIntention,
                                    starCustomer: customerStar,
                                    returnRemindTime: returnTime
                                }),
                                dataType: 'json',
                                type: "POST",
                                success: function (data) {
                                    if (data.status == 0) {
                                        window.location.reload();
                                    } else {
                                        alert(data.errorMessage);
                                    }
                                }
                            });
                        } else {
                            alert("操作失败，" + data.msg);
                        }
                    }
                });
            });
            $(".modal").css("width", "560px");
            return false;
        } else {
            $.ajax({
                url: '${ctx}/customer/addCall',
                data: {
                    "content": callContent,
                    "customerId": customerId,
                    "isGiveUp": 1,
                    "labelIds": ids,
                    "managerId": waitManagerId,
                    "phone": waitPhone,
                    "buyIntention": buyIntention
                },
                type: "GET",
                success: function (data) {
                    if (data.result == '1') {
                        //更新客户是否中介同行状态
                        var isPeer = $("input[name='isPeer']:checked").val();
                        $.ajax({
                            url: '${ctx}/customermanagement/updatePeerAndTime/' + 0,
                            contentType: 'application/json',
                            data: JSON.stringify({
                                id: customerId,
                                isPeer: isPeer,
                                buyIntention: buyIntention,
                                starCustomer: customerStar,
                                returnRemindTime: returnTime
                            }),
                            dataType: 'json',
                            type: "POST",
                            success: function (data) {
                                if (data.status == 0) {
                                    window.location.reload();
                                } else {
                                    alert(data.errorMessage);
                                }
                            }
                        });
                    } else {
                        alert("操作失败，" + data.msg);
                    }
                }
            });
        }
    }

    function confirmBuyIntention(buyIntention) {
        if (buyIntention == 5) {
            $("#confirmMessage").text("您确定要将客户移入公海吗？");
        } else {
            $("#confirmMessage").text("");
        }
    }

    function setCallbackContent(template) {
        var content = $(template).text();
        var obj = document.getElementById("info11");
        obj.innerHTML = content;
        console.info(obj)
    }
    function setCallbackContent2(template) {
        var content = $(template).text();
        var obj = document.getElementById("cusinfo");
        obj.innerHTML = content;
        console.info(obj)
    }

    function saveLabel() {
        var data = {labelIdList: resultNum, mycustomerSource: 1, customerIdList: customerIdList};
        data = JSON.stringify(data);
        $.ajax({
            url: '${ctx}/labelmanager/saveCustomersLabel',
            type: 'POST',
            contentType: 'application/json',
            data: data,
            dataType: 'json',
            cache: false,
            success: function (result) {
                if (result.status == 0) {
                    alert("新增成功！");
                    $("#labelModel").modal('hide');
                    window.location.reload();
                } else {
                    alert(result.errorMessage);
                }
            }
        });
    }

    var resultNum = [];
    $(document).on('click', '.bt', function () {
//        var bor_color = $(this).css("border-color");
        var bor_color = $(this).css("borderRightColor");
        var bg_color = $(this).css("background-color");
        if (bg_color === 'rgb(255, 255, 255)') {
            resultNum.push($(this).attr("value"));
            $(this).css("background-color", bor_color);
            $(this).css("color", "white");
        } else {
            resultNum.splice(resultNum.indexOf($(this).attr("value")), 1);
            $(this).css("background-color", "rgb(255, 255, 255)");
            $(this).css("color", bor_color);
        }
    });

    $(document).on('click', '.collect', function () {
        var customerId = $("#tempCustomerId").val();
        $.ajax({
            url: '${ctx}/customermanagement/judgeStar/' + customerId,
            type: "GET",
            success: function (data) {
                if (data.status == 0) {
                    var img_src = $('#starImage').attr("src");
                    if (img_src === '${ctx}/resources/img/collect_no.png') {
                        $('#starImage').attr("src", "${ctx}/resources/img/collect_yes.png")
                    } else {
                        $('#starImage').attr("src", "${ctx}/resources/img/collect_no.png")
                    }
                } else {
                    alert(data.errorMessage);
                }
            }
        });
    });

    $(document).on('click', '.newCollect', function () {
        var customerId = callId;
        $.ajax({
            url: '${ctx}/customermanagement/judgeStar/' + customerId,
            type: "GET",
            success: function (data) {
                if (data.status == 0) {
                    var img_src = $('#starImage2').attr("src");
                    if (img_src === '${ctx}/resources/img/collect_no.png') {
                        $('#starImage2').attr("src", "${ctx}/resources/img/collect_yes.png")
                    } else {
                        $('#starImage2').attr("src", "${ctx}/resources/img/collect_no.png")
                    }
                } else {
                    alert(data.errorMessage);
                }
            }
        });
    })

</script>
<div id="callDialog" style="display: none" title="电话回访">

</div>

<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h5 class="modal-title" id="myModalLabel">添加回访</h5>
            </div>
            <div class="modal-body">
                <input id="tempCustomerId" type="hidden">
                <input id="waitPhone" type="hidden">
                <input id="waitManagerId" type="hidden">
                <input id="starType" type="hidden">
                <div style="position:relative;">
                    <span>客户意向：</span>
                    <select style="width: 6rem;margin-left: 6px" name="buyIntention" id="buyIntention1"
                            onchange="confirmBuyIntention(this.value)">
                        <option value="" selected="selected">
                            请选择
                        </option>
                        <c:forEach items="${fns:getDictList('crm_visit_result')}" var="dict">
                            <c:if test="${dict.dicValue < 5}">
                                <option value="${dict.dicValue}">${dict.dicName}</option>
                            </c:if>
                        </c:forEach>
                    </select>
                    <span id="confirmMessage" style="color: red;"></span>
                    <span style="margin-left: 200px;" class="shouc">
                        <img id="starImage" class="collect" src="${ctx}/resources/img/collect_no.png" alt="">
                    </span>
                </div>
                <div class='row-fluid'>
                    <div class="span5 control-group" style="width: 100%;position: relative;top:10px">
                        <label class='control-label'>回访内容：</label>
                        <p contenteditable="true" class="temp" cols="10" rows="5"
                           style="margin: 0px 0px 10px; width: 436px; height: 70px;" id="info11" name="info11">
                        <div style="position: absolute;bottom: 39px;width: 80%;left:85px">
                            <c:forEach items="${callbackTemplateList}" var="item">
                                <button type="button" class="btn bt_last" style="margin:3px"
                                        onclick="setCallbackContent(this)">${item.content}</button>
                            </c:forEach>
                        </div>
                        </p>
                    </div>
                    <div class="row-fluid">
                        <div style="display: inline-flex;"><span>客户标签：</span>
                            <div class="clearfix"
                                 style="display: flex;flex-wrap: wrap;width: 370px;line-height: 35px;height: auto;">
                                <div style="margin-top: -5px;float:left;margin-left: 6px">
                                    <c:forEach items='${userLabelList}' var='lid'>
                                        <c:choose>
                                            <c:when test="${fn:contains(markedLabelId, lid.labelId)}">
                                                <c:if test="${1 eq lid.colorId}"><span class="bat color_999"
                                                                                       data-index="${lid.labelId}"
                                                                                       opsel=""
                                                                                       style="background-color: rgb(153, 153, 153); color: white;">${lid.labelName}</span></c:if>
                                                <c:if test="${2 eq lid.colorId}"><span class="bat color_d9534f"
                                                                                       data-index="${lid.labelId}"
                                                                                       opsel=""
                                                                                       style="background-color: rgb(217, 83, 79); color: white;">${lid.labelName}</span></c:if>
                                                <c:if test="${3 eq lid.colorId}"><span class="bat color_f0ad4e"
                                                                                       data-index="${lid.labelId}"
                                                                                       opsel=""
                                                                                       style="background-color: rgb(240, 173, 78); color: white;">${lid.labelName}</span></c:if>
                                                <c:if test="${4 eq lid.colorId}"><span class="bat color_5cb85c"
                                                                                       data-index="${lid.labelId}"
                                                                                       opsel=""
                                                                                       style="background-color: rgb(92, 184, 92); color: white;">${lid.labelName}</span></c:if>
                                                <c:if test="${5 eq lid.colorId}"><span class="bat color_5bc0de"
                                                                                       data-index="${lid.labelId}"
                                                                                       opsel=""
                                                                                       style="background-color: rgb(91, 192, 222); color: white;">${lid.labelName}</span></c:if>
                                                <c:if test="${6 eq lid.colorId}"><span class="bat color_0275d8"
                                                                                       data-index="${lid.labelId}"
                                                                                       opsel=""
                                                                                       style="background-color: rgb(2, 117, 216); color: white;">${lid.labelName}</span></c:if>
                                                <c:if test="${7 eq lid.colorId}"><span class="bat color_663399"
                                                                                       data-index="${lid.labelId}"
                                                                                       opsel=""
                                                                                       style="background-color: rgb(102, 51, 153); color: white;">${lid.labelName}</span></c:if>
                                            </c:when>
                                            <c:otherwise>
                                                <c:if test="${1 eq lid.colorId}"><span class="bat2 color_999"
                                                                                       data-index="${lid.labelId}"
                                                                                       opsel="">${lid.labelName}</span></c:if>
                                                <c:if test="${2 eq lid.colorId}"><span class="bat2 color_d9534f"
                                                                                       data-index="${lid.labelId}"
                                                                                       opsel="">${lid.labelName}</span></c:if>
                                                <c:if test="${3 eq lid.colorId}"><span class="bat2 color_f0ad4e"
                                                                                       data-index="${lid.labelId}"
                                                                                       opsel="">${lid.labelName}</span></c:if>
                                                <c:if test="${4 eq lid.colorId}"><span class="bat2 color_5cb85c"
                                                                                       data-index="${lid.labelId}"
                                                                                       opsel="">${lid.labelName}</span></c:if>
                                                <c:if test="${5 eq lid.colorId}"><span class="bat2 color_5bc0de"
                                                                                       data-index="${lid.labelId}"
                                                                                       opsel="">${lid.labelName}</span></c:if>
                                                <c:if test="${6 eq lid.colorId}"><span class="bat2 color_0275d8"
                                                                                       data-index="${lid.labelId}"
                                                                                       opsel="">${lid.labelName}</span></c:if>
                                                <c:if test="${7 eq lid.colorId}"><span class="bat2 color_663399"
                                                                                       data-index="${lid.labelId}"
                                                                                       opsel="">${lid.labelName}</span></c:if>
                                            </c:otherwise>
                                        </c:choose>
                                    </c:forEach>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div style="margin-top: 10px;">
                        <span>回访提醒：</span>
                        <input type="text" style="width: 200px;margin-left: 7px" autocomplete="off"
                               class="datetime-picker span2 input-large" id="returnTime1"
                               date-language="zh-CN" date-format="yyyy-mm-dd hh:ii:ss"
                               placeholder="/年/月/日">
                    </div>
                    <div style="margin-top: 10px;">
                        <span>中介同行：</span>
                        <input type="radio" style=";margin-left: 7px" name="isPeer" value="0" id="radio1"> 否
                        <input style="margin-left: 20px;" type="radio" name="isPeer" value="1" id="radio2"> 是
                    </div>
                </div>
            </div>
            <div id="btnGive" class="modal-footer">
                <button type="button" class="btn btn-primary" onclick="save()">确认</button>
                <button type="button" class="btn" onclick="giveUp()">放弃</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="labelModel" tabindex="-1" role="dialog" aria-labelledby="myLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h5 class="modal-title" id="myLabel">添加标签</h5>
            </div>
            <div class="modal-body">
                <div>
                    <span>请选择客户标签：</span>
                    <div style="margin-top: 10px;">
                        <%--客户标签模板--%>
                        <c:forEach items="${labList}" var="item">
                            <c:if test="${1 eq item.colorId}">
                                <button id="color1" class="bt color_999" style="margin: 5px"
                                        value="${item.labelId}">${item.labelName}</button>
                            </c:if>
                            <c:if test="${2 eq item.colorId}">
                                <button id="color2" class="bt color_d9534f" style="margin: 5px"
                                        value="${item.labelId}">${item.labelName}</button>
                            </c:if>
                            <c:if test="${3 eq item.colorId}">
                                <button id="color3" class="bt color_f0ad4e" style="margin: 5px"
                                        value="${item.labelId}">${item.labelName}</button>
                            </c:if>
                            <c:if test="${4 eq item.colorId}">
                                <button id="color4" class="bt color_5cb85c" style="margin: 5px"
                                        value="${item.labelId}">${item.labelName}</button>
                            </c:if>
                            <c:if test="${5 eq item.colorId}">
                                <button id="color5" class="bt color_5bc0de" style="margin: 5px"
                                        value="${item.labelId}">${item.labelName}</button>
                            </c:if>
                            <c:if test="${6 eq item.colorId}">
                                <button id="color6" class="bt color_0275d8" style="margin: 5px"
                                        value="${item.labelId}">${item.labelName}</button>
                            </c:if>
                            <c:if test="${7 eq item.colorId}">
                                <button id="color7" class="bt color_663399" style="margin: 5px"
                                        value="${item.labelId}">${item.labelName}</button>
                            </c:if>
                        </c:forEach>
                    </div>
                </div>
            </div>
            <div id="labelBtnGive" class="modal-footer">
                <button type="button" class="btn btn-primary" onclick="saveLabel()">确认</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">取消</button>
            </div>
        </div>
    </div>
</div>
<script>
    $(function(){
        setTimeout(function () {
            $(".pace").hide()
        },1000)
    })

</script>
</body>
</html>
