package com.house365.web.controller;

import com.house365.beans.entity.DepartmentEntity;
import com.house365.beans.entity.ReportAttachEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.SessionConstants;
import com.house365.ws.beans.util.HResult;
import com.house365.ws.interfaces.server.IReportAttachInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 置业报告资质controller
 *
 * @author Created by Administrator on 2020/4/21.
 */
@Controller
@RequestMapping("/repoetattach")
public class ReportAttachController extends BaseController {

    private static final Logger logger = LoggerFactory.getLogger(ReportAttachController.class);

    @Autowired
    private IReportAttachInterface reportAttachInterface;

    /**
     * 置业报告资质列表
     *
     * @param model
     * @param request
     * @return
     */
    @RequestMapping(value = "/marketAttach")
    public String marketAttach(Model model, HttpServletRequest request) {
        try {
            DepartmentEntity departmentEntity = (DepartmentEntity) request.getSession().getAttribute(SessionConstants.SESSION_CURRNET_DEPT_KEY);
            String cityCode = departmentEntity.getDescripition();
            Map<String, Object> map = new HashMap<>(10);
            map.put("city", cityCode);
            map.put("type", 1);
            List<ReportAttachEntity> list = reportAttachInterface.queryByConditions(map);
            model.addAttribute("dataList", list);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("查询置业报告资质列表失败", e);
        }
        return getAutoUrl();
    }

    /**
     * 置业报告资质广告列表
     *
     * @param model
     * @param request
     * @return
     */
    @RequestMapping(value = "/adAttach")
    public String adAttach(Model model, HttpServletRequest request) {
        try {
            DepartmentEntity departmentEntity = (DepartmentEntity) request.getSession().getAttribute(SessionConstants.SESSION_CURRNET_DEPT_KEY);
            String cityCode = departmentEntity.getDescripition();
            Map<String, Object> map = new HashMap<>(10);
            map.put("city", cityCode);
            map.put("type", 2);
            List<ReportAttachEntity> list = reportAttachInterface.queryByConditions(map);
            model.addAttribute("dataList", list);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("查询置业报告资质广告列表失败", e);
        }
        return getAutoUrl();
    }

    /**
     * 新增置业报告资质
     *
     * @return 结果视图
     */
    @RequestMapping(value = "/save")
    @ResponseBody
    public HResult save(HttpServletRequest request) {
        HResult result = new HResult();
        try {
            UserEntity userEntity = (UserEntity) request.getSession().getAttribute(SessionConstants.THREAD_USER_KEY);
            ReportAttachEntity entity = new ReportAttachEntity();
            entity.setCreateId(userEntity.getId());
            entity.setCreateName(userEntity.getRealName());
            entity.setUpdateId(userEntity.getId());
            entity.setUpdateName(userEntity.getRealName());
            Date date = new Date();
            entity.setCreateTime(date);
            entity.setUpdateTime(date);
            result = reportAttachInterface.save(entity);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("新增置业报告失败", e);
            result.setStatus(-1);
            result.setErrorMessage("新增置业报告失败");
        }
        return result;
    }

    @RequestMapping(value = "/update")
    @ResponseBody
    public HResult update(@RequestBody ReportAttachEntity entity,HttpServletRequest request) {
        HResult result = new HResult();
        try {
            UserEntity userEntity = (UserEntity) request.getSession().getAttribute(SessionConstants.THREAD_USER_KEY);
            result = reportAttachInterface.update(entity,userEntity);
        } catch (Exception e) {
            e.printStackTrace();
            result.setStatus(500);
            result.setErrorMessage("更新资质失败");
            logger.error("更新资质失败", e);
        }
        return result;
    }

}
