/**
 * Description: ProjectSourceStatistics控制器
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-17 下午 14:59:25
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import com.house365.beans.entity.ProjectSourceStatisticsEntity;
import com.house365.beans.system.Page;
import com.house365.beans.vo.ProjectSourceStatisticsVo;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.request.ProjectSourceStatisticsListRequest;
import com.house365.ws.beans.request.ProjectSourceStatisticsRequest;
import com.house365.ws.beans.response.ProjectSourceStatisticsListResponse;
import com.house365.ws.beans.response.ProjectSourceStatisticsResponse;
import com.house365.ws.interfaces.server.IProjectSourceStatistics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.Map;

/**
 * ProjectSourceStatistics控制器<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-17
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/projectsourcestatistics")
public class ProjectSourceStatisticsController extends BaseController {

    /**
     * 自动注入ProjectSourceStatisticsWS实现
     */
    @Autowired
    private IProjectSourceStatistics projectSourceStatistics;

    /**
     * 去新增ProjectSourceStatistics
     *
     * @return 结果视图
     */
    @RequestMapping(value = "", params = "action=create")
    public String createForm(Model model) {
        model.addAttribute("action", "create");
        return getAutoUrl("form");
    }

    /**
     * 新增ProjectSourceStatistics
     *
     * @param vo     ProjectSourceStatistics页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "", method = {RequestMethod.POST})
    public String createProjectSourceStatistics(@Valid ProjectSourceStatisticsVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model) {
        ProjectSourceStatisticsEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                ProjectSourceStatisticsRequest request = new ProjectSourceStatisticsRequest();
                request.setEntity(entity);
                ProjectSourceStatisticsResponse response = projectSourceStatistics
                        .addProjectSourceStatistics(request);
                Integer id = response.getEntity().getId();
                return "redirect:/projectsourcestatistics/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 删除ProjectSourceStatistics
     *
     * @param id ProjectSourceStatistics页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.DELETE})
    @ResponseStatus(HttpStatus.OK)
    public void delete(@PathVariable String id) {
        if (!StringUtils.isEmpty(id)) {
            if (id.contains(",")) {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    projectSourceStatistics.deleteProjectSourceStatisticsById(Integer.valueOf(ids[i]));
                }
            } else {
                projectSourceStatistics.deleteProjectSourceStatisticsById(Integer.valueOf(id));
            }
        }
    }

    /**
     * 去查看ProjectSourceStatistics
     *
     * @param id ProjectSourceStatistics页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET})
    public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        ProjectSourceStatisticsResponse response = projectSourceStatistics
                .getProjectSourceStatisticsById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
    }

    /**
     * 去修改ProjectSourceStatistics
     *
     * @param id ProjectSourceStatistics页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET}, params = "action=edit")
    public String updateForm(@PathVariable(value = "id") Integer id, Model model) {
        ProjectSourceStatisticsResponse response = projectSourceStatistics
                .getProjectSourceStatisticsById(id);
        model.addAttribute("entity", response.getEntity());
        model.addAttribute("action", "edit");
        return getAutoUrl("form");
    }

    /**
     * 修改ProjectSourceStatistics
     *
     * @param vo     ProjectSourceStatistics页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.POST})
    public String updateProjectSourceStatistics(@Valid ProjectSourceStatisticsVo vo, BindingResult result, @PathVariable Integer id, RedirectAttributes redirectAttributes, Model model) {
        ProjectSourceStatisticsEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                ProjectSourceStatisticsRequest request = new ProjectSourceStatisticsRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused")
                ProjectSourceStatisticsResponse rersponse = projectSourceStatistics
                        .updateProjectSourceStatistics(request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/projectsourcestatistics/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 查询ProjectSourceStatistics
     *
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "", method = RequestMethod.GET)
    public String list(Integer number, Model model, HttpServletRequest request) {
        // 获取查询条件
        Map<String, Object> searchParams = Servlets.getParametersStartingWith(
                request, "search_");
        Page page = new Page(20);
        if (null != number) {
            page.setCurrentPage(number);
        }
        ProjectSourceStatisticsListRequest listRequest = new ProjectSourceStatisticsListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        ProjectSourceStatisticsListResponse response = projectSourceStatistics.getProjectSourceStatisticsList(listRequest);
        model.addAttribute("page", response.getPaging());
        model.addAttribute("projectSourceStatisticss", response.getObjectList());
        model.addAttribute("searchParams", Servlets
                .encodeParameterStringWithPrefix(searchParams, "search_"));
        return getAutoUrl();
    }
}
